/**
 * Copyright ken.trustest ( http://wonderfl.net/user/ken.trustest )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bw4i
 */

package {
    import caurina.transitions.Tweener;
    
    import flash.display.*;
    import flash.events.Event;
    import flash.events.EventDispatcher;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.geom.Transform;
    import flash.geom.Vector3D;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.*;
    
    import org.osmf.media.LoadableElementBase;
    
    [SWF(backGroundColor=0x000000, width=465, height=465, frameRate=30)]    
    
    public class SPECvol5 extends Sprite {
        
        //set global property
        private var vy:int = 5;
        private var cardW:int = 255;
        private var color:ColorTransform = new ColorTransform(1.0, 1.0, 1.0, 1.0, cardW, cardW, cardW, 0);

        // round on circle
        private static var roundPos:int = 0;
        private static var roundSpeed:Number = 3;
        private static var roundHeight:int = BG02_WIDTH-SUB_CARD_HEIGHT;
        private static var roundHankei:Number;
        
        private static     var circle_stage:int = 0;

        //timer
        private var delay:uint = 800;
        //const
        private static const BG02_WIDTH:uint   = 465;
        private static const BG02_HEIGHT:uint  = 465;
        private static const MAGIC_WIDTH:uint  = 208;
        private static const MAGIC_HEIGHT:uint = 206;
        
        private static const MAIN_CARD_WIDTH:uint  = 120;
        private static const MAIN_CARD_HEIGHT:uint = 144;
        private static const SUB_CARD_WIDTH:uint   = 60;
        private static const SUB_CARD_HEIGHT:uint  = 72;        
        private static const SUB_CARD_NUM:uint     = 10; 
        private static const SUP_CARD_NUM:uint     = 10; 

        private static const KIRA_WIDTH:uint  = 35;
        private static const KIRA_HEIGHT:uint = 35;
        
        private static const LVUP_WIDTH:uint  = 180;
        private static const LVUP_HEIGHT:uint = 86;
        
        //bitmap
        private var _bitmap:Bitmap;
        private var _bitmapData:BitmapData;
        private var screenWhite:Bitmap;        
        private var screenWhiteData:BitmapData;
        

        //maincard preload
        private var urlMainCard:String = "http://jsdo.it/img/event/spec/vol5/material_fl/card01.jpg";

          //subcard preload
        private var urlSubCard:String = "http://jsdo.it/img/event/spec/vol5/material_fl/card02.jpg";

          //bg preload
        private var urlBg:String = "http://jsdo.it/img/event/spec/vol5/material_fl/bg02.jpg";

          //mahoujin preload
        private var urlMahoujin:String = "http://jsdo.it/img/event/spec/vol5/material_fl/magic.png ";

        //lvup preload
        private var urlLvup:String = "http://jsdo.it/img/event/spec/vol5/material_fl/lvup.png";

        //kira preload
        private var urlKira:String = "http://jsdo.it/img/event/spec/vol5/material_fl/kira02.png";

          //kira small preload
        private var urlKiraSmall:String = "http://jsdo.it/img/event/spec/vol5/material_fl/kira.png";

 /***
        //maincard preload
        private var urlMainCard:String =    "imgs/card01.jpg";

        //subcard preload
        private var urlSubCard:String =    "imgs/card02.jpg";

        //bg preload
        private var urlBg:String =         "imgs/bg02.jpg";

        //mahoujin preload
        private var urlMahoujin:String =    "imgs/magic.png";

        //lvup preload
        private var urlLvup:String =         "imgs/lvup.png";

        //kira preload
        private var urlKira:String =        "imgs/kira02.png";

        //kira preload
        private var urlKiraSmall:String =    "imgs/kira.png";
***/
        
        private var urlReqMainCard:URLRequest = new URLRequest(urlMainCard);
        private var main_card:Loader = new Loader();
        
        private var urlReqSubCard:URLRequest = new URLRequest(urlSubCard);
        
        private var urlReqBg:URLRequest = new URLRequest(urlBg);
        private var bg:Loader = new Loader();
        
        private var urlReqMahoujin:URLRequest = new URLRequest(urlMahoujin);
        private var mahoujin:Loader = new Loader();

        private var mahoujinRoot:Sprite = new Sprite();
        
        private var urlReqLvup:URLRequest = new URLRequest(urlLvup);
        private var lvup:Loader = new Loader();
        
        private var urlReqKira:URLRequest = new URLRequest(urlKira);
        private var kira:Loader = new Loader();
        
        private var urlReqKiraSmall:URLRequest = new URLRequest(urlKiraSmall);
        private var kiraSmall:Loader = new Loader();

        
        private var cards:Array = new Array();
        private var sub_card1:Loader = new Loader();
        private var sub_card2:Loader = new Loader();
        private var sub_card3:Loader = new Loader();
        private var sub_card4:Loader = new Loader();
        private var sub_card5:Loader = new Loader();
        private var sub_card6:Loader = new Loader();
        private var sub_card7:Loader = new Loader();
        private var sub_card8:Loader = new Loader();                        
        private var sub_card9:Loader = new Loader();
        private var sub_card10:Loader = new Loader();
        
        private var sup_card1:Loader = new Loader();
        private var sup_card2:Loader = new Loader();
        private var sup_card3:Loader = new Loader();
        private var sup_card4:Loader = new Loader();
        private var sup_card5:Loader = new Loader();
        private var sup_card6:Loader = new Loader();
        private var sup_card7:Loader = new Loader();
        private var sup_card8:Loader = new Loader();                        
        private var sup_card9:Loader = new Loader();
        private var sup_card10:Loader = new Loader();        
        
        //transform
        private var matMainCard:Matrix3D = new Matrix3D();
        private var matLvup:Matrix3D = new Matrix3D();

//        private var sub_mat1:Matrix = new Matrix();
//        private var matMainCard:Matrix = main_card.transform.matrix;
//        private var sub_mat1:Matrix = sub_card1.transform.matrix;
//        private var sub_mat2:Matrix = sub_card2.transform.matrix;
        
            
        /*********************************************************************************************************************************
         Main : setup item
         **********************************************************************************************************************************/
        public function SPECvol5(){
            //
            setPerspective();
            
            setScreen();            
            setBg();
            setMahoujin();
            setWhiteScreen();

            setLvup();
            setKira();
            //
            setupMainCard();    // goto1stAction();
            setupSubCard();
            setupSupCard();
        }
        
        private function setPerspective():void{
            root.transform.perspectiveProjection.projectionCenter = new Point(465/2, 465*2/3);

//            root.transform.perspectiveProjection.fieldOfView = 1;
//            root.transform.perspectiveProjection.focalLength = 0;
        }
        
        //set Black Screen
        private function setScreen():void{
            _bitmapData = new BitmapData(465, 465, false, 0x000000);
            _bitmap = addChild(new Bitmap(_bitmapData, PixelSnapping.NEVER, false)) as Bitmap;

            _bitmap.alpha = 0.5;
            _bitmap.x = 0;
            _bitmap.y = 0;
            _bitmap.z = 465;
            
            setChildIndex(_bitmap, 0);
        }
        
        //set bg
        private function setBg():void{
            bg.load(urlReqBg);
            addChild(bg);

            bg.x = 0;
            bg.y = 0;
            bg.z = 465;

            setChildIndex(bg, 1);
        }
        
        private function setMahoujin():void{
            mahoujin.contentLoaderInfo.addEventListener(Event.COMPLETE, onSetMahoujinComplete);
            mahoujin.load(urlReqMahoujin);

            // 真黒
            var bmD:BitmapData = new BitmapData(465, 465, false, 0x000000);
            var bm:Bitmap = addChild(new Bitmap(bmD, PixelSnapping.NEVER, false)) as Bitmap;

            bm.x = 0;
            bm.y = 0;
            mahoujinRoot.addChild( bm );
            
            mahoujinRoot.x = 0;
            mahoujinRoot.y = BG02_HEIGHT;
            mahoujinRoot.z = 0;
            mahoujinRoot.rotationX = 90;
            
            addChild(mahoujinRoot);
            setChildIndex(mahoujinRoot, 2);
        }
        
        //init mahoujin property
        private function onSetMahoujinComplete(e:Event):void{
            mahoujin.x = (465-MAGIC_WIDTH*2)/2;
            mahoujin.y = (465-MAGIC_HEIGHT*2)/2;
            mahoujin.scaleX = 2;
            mahoujin.scaleY = 2;
            
            mahoujinRoot.addChild( mahoujin );
        }
        
        //set White Screen
        private function setWhiteScreen():void{
            screenWhiteData = new BitmapData(465, 465, false, 0xffffff);
            screenWhite = addChild(new Bitmap(screenWhiteData, PixelSnapping.NEVER, false)) as Bitmap;
            screenWhite.alpha = 0;
            
            setChildIndex(screenWhite, 3);
        }
        
        //set levelup   
        private function setLvup():void{
            lvup.contentLoaderInfo.addEventListener(Event.COMPLETE, onSetLvupComplete);
            lvup.load(urlReqLvup);            
        }
        
        //init levelup property
        private function onSetLvupComplete(e:Event):void{
            lvup.z = 0;
            matLvup.appendTranslation(0, -(LVUP_HEIGHT*1.5)/2, 0);
            lvup.transform.matrix3D = matLvup;            
            
            lvup.alpha = 1;            
            lvup.x = (465-LVUP_WIDTH*1.5)/2;
            lvup.y = 230;
            lvup.z = 2000;

            lvup.scaleX = 1.5;
            lvup.scaleY = 1.5;
        }
        
        //set kira
        private function setKira():void{
            kira.contentLoaderInfo.addEventListener(Event.COMPLETE, onSetKiraComplete);
            kiraSmall.contentLoaderInfo.addEventListener(Event.COMPLETE, onSetKiraComplete);

            kira.load(urlReqKira);
            kiraSmall.load(urlReqKiraSmall);
        }

        private function onSetKiraComplete(e:Event):void{
            var info:LoaderInfo = e.currentTarget as LoaderInfo;
            var kirax:Loader    = info.loader;
            
            kirax.alpha = 0;
            kirax.x = 0;
            kirax.y = 0;
            kirax.z = 0;
        }
        
        /*********************************************************************************************************************************
         1st action : set main card -> raize and down & flash.
         **********************************************************************************************************************************/        
        // set main_card
        private function setupMainCard():void{
            main_card.contentLoaderInfo.addEventListener(Event.COMPLETE, onSetMainCardComplete);
            main_card.load(urlReqMainCard);            
        }
        
        // init main_card property
        private function onSetMainCardComplete(e:Event):void{
            // 初期位置は、３Ｄ領域の下枠外
            main_card.x = (BG02_WIDTH-MAIN_CARD_WIDTH)/2;
            main_card.y = (BG02_HEIGHT-MAIN_CARD_HEIGHT)/2 + BG02_HEIGHT;
            main_card.z = MAGIC_HEIGHT/2;

            // メインカードの原点を移動 (,transformは使わない)
//            main_card.x -= MAIN_CARD_WIDTH/2;
//            main_card.y -= MAIN_CARD_HEIGHT/2;
//            matMainCard.appendTranslation(-MAIN_CARD_WIDTH/2, -MAIN_CARD_HEIGHT/2, 0);
//            main_card.transform.matrix3D = matMainCard;
            
            goto1stAction();
        }
        
        // goto1stAction
        public function goto1stAction():void{
            // 1st action
            addChild(main_card);
            cardAppear( main_card );
        }

        private function tweenMainCardCompleteHandler(main_card:Loader):void
        {
            setTimeout(start_flash_MainCard, 50);
        }
        
        private function start_flash_MainCard():void
        {
            color = new ColorTransform(1.0, 1.0, 1.0, 1.0, cardW, cardW, cardW, 0);
            main_card.addEventListener(Event.ENTER_FRAME, color_mUpdate);            
        }
        
        // main_card color update
        private function color_mUpdate(e:Event):void{
            //getting brightness -> 0
            if(color.redOffset > 0){
                color.redOffset   -=15;
                color.greenOffset -=15;
                color.blueOffset  -=15;
                main_card.transform.colorTransform = color;
            }
            else{
                //adjust////////////////////////////////////////////////////////
                color.redOffset   =0;
                color.greenOffset =0;
                color.blueOffset  =0;
                main_card.transform.colorTransform = color;
                ////////////////////////////////////////////////////////////////
                main_card.removeEventListener(Event.ENTER_FRAME, color_mUpdate);

                goto2ndAction();
            }
        }
        
        /*********************************************************************************************************************************
         2nd action : set sub_card -> round and up sub_cards
         **********************************************************************************************************************************/        
        // set sub_card
        private function setupSubCard():void{
            // sub card load;
            for (var i:uint=1; i <= SUB_CARD_NUM; i++){
                this["sub_card"+i].name = i.toString();

                this["sub_card"+i].contentLoaderInfo.addEventListener(Event.COMPLETE, onSetSubCardComplete);
                this["sub_card"+i].load(urlReqSubCard);
            }        
        }
        
        // init main_card property
        private function onSetSubCardComplete(e:Event):void{
            var cardInfo:LoaderInfo = e.currentTarget as LoaderInfo;
            var scard:Loader = cardInfo.loader;

            var idx:int = int( scard.name );
                        
            // サブカードの原点を移動
//            card.transform.matrix = sub_mat1;

            scard.width  = SUB_CARD_WIDTH;
            scard.height = SUB_CARD_HEIGHT;

            scard.x = BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(2 * Math.PI *(idx*36./360));
            scard.y = roundHeight;
            scard.z = MAGIC_HEIGHT/2 - roundHankei*Math.sin(2 * Math.PI *(36./360));
        }

        
        // set sup_card
        private function setupSupCard():void{
            // sub card load;
            for (var i:uint=1; i <= SUP_CARD_NUM; i++){
                this["sup_card"+i].name = i.toString();
                
                this["sup_card"+i].contentLoaderInfo.addEventListener(Event.COMPLETE, onSetSupCardComplete);
                this["sup_card"+i].load(urlReqMainCard);
            }        
        }
        
        // init main_card property
        private function onSetSupCardComplete(e:Event):void{
            var cardInfo:LoaderInfo = e.currentTarget as LoaderInfo;
            var scard:Loader = cardInfo.loader;
            
            // 補足カードの原点を移動
//            card.transform.matrix = sub_mat1;
            
            scard.width  = SUB_CARD_WIDTH;
            scard.height = SUB_CARD_HEIGHT;
            
            scard.x = -SUB_CARD_WIDTH;
            scard.y = -SUB_CARD_HEIGHT;
            scard.z = 0;

            scard.alpha = 1;
        }


        //2nd action            
        public function goto2ndAction():void{
            // sub cards start rounding
            sub_card1.addEventListener(Event.ENTER_FRAME, circle_update);
        }

        private function circle_update(e:Event):void{
            var scard:Loader = e.currentTarget as Loader
            var deg:Number;
            
            cards = new Array();
            cards.push( {z:kira.transform.getRelativeMatrix3D(root).position.z,      child:kira} );
            cards.push( {z:main_card.transform.getRelativeMatrix3D(root).position.z, child:main_card} );

            // 回転スピード
            if(roundSpeed < 12){
                roundSpeed += 0.25;
            }
            else{
                // 回転位置（y座標）
                if(roundHeight > main_card.y + (MAIN_CARD_HEIGHT-SUB_CARD_HEIGHT)/2){
                    roundHeight -= 4;                
                }
                else{
                    roundHeight = main_card.y + (MAIN_CARD_HEIGHT-SUB_CARD_HEIGHT)/2;
                }

                switch( circle_stage ){
                    case 0:        // first idle stage
                        circle_stageUp();

                        setTimeout(circle_stageUp, 800);
                        break;
                    case 1:        // waiting for 800ms
                        break;
                    case 2:        // start kira stage
                        circle_stageUp();
                        
                        start_kira();
                        setTimeout(circle_stageUp, 800);
                        break;
                    case 3:        // waiting for 800ms (kira-ing)
                        break;
                    case 4:        // uzumaki start stage
                        circle_stage = 5;
                        uzumaki_start();
                        break;
                    case 5:        // finished.
                        break;
                }
            }
            
            // 回転半径
            roundHankei = MAIN_CARD_WIDTH + Math.abs(roundHeight - (main_card.y + (MAIN_CARD_HEIGHT - SUB_CARD_HEIGHT)/2) );
            
            // 回転処理
            roundPos += roundSpeed;
            roundPos %= 360;
            for (var i:uint = 1; i <= SUB_CARD_NUM; i++){
                deg = 36.*i + roundPos;
                deg = deg % 360;
                
                scard = this["sub_card"+i];
                scard.x = BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(2 * Math.PI *(deg/360));
                scard.y = roundHeight;
                scard.z = MAGIC_HEIGHT/2 - roundHankei*Math.sin(2 * Math.PI *(deg/360));
                
                cards.push( {z:scard.transform.getRelativeMatrix3D(root).position.z, child:scard} );
            }
            
            ReorderByZ();
        }

        private function circle_stageUp():void{
            ++ circle_stage;
        }

        
        private function uzumaki_start():void{
            var scard:Loader;
            
            for (var i:uint=1; i <= SUP_CARD_NUM; i++){
                scard = this["sup_card"+i];
                cards.push( {z:scard.transform.getRelativeMatrix3D(root).position.z, child:scard} );
                
                setTimeout(uzumaki_update, 75*i +500, i);
            }
            
//            ReorderByZ();
        }
        
        private function uzumaki_update(idx:int):void
        {            
            var scard:Loader;
            var deg:Number, roundHankeiLocal:Number;
            
            cards = new Array();
            
            scard = this["sup_card"+idx];

            deg = 36.*(idx-1);
            roundHankeiLocal = BG02_WIDTH +100;

//            scard.x = BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(2 * Math.PI *(deg/360));
//            scard.y = MAGIC_HEIGHT/2 - roundHankei*Math.sin(2 * Math.PI *(deg/360));
            
            scard.x = BG02_WIDTH/2 -MAIN_CARD_HEIGHT/2 +10+ roundHankeiLocal*Math.cos(2 * Math.PI *(deg/360));
            scard.y = BG02_HEIGHT/2 -MAIN_CARD_HEIGHT/2 - roundHankeiLocal*Math.sin(2 * Math.PI *(deg/360));

//            scard.x = BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankeiLocal*Math.cos(2 * Math.PI *(deg/360));
//            scard.y = MAGIC_HEIGHT/2 - roundHankeiLocal*Math.sin(2 * Math.PI *(deg/360)),

            scard.z = MAGIC_HEIGHT/3;
            
            scard.scaleX = 1.5;
            scard.scaleY = 1.5;
            scard.alpha  = 1;
            
            Tweener.addTween(scard, {
                x: BG02_WIDTH/2,
                y: BG02_HEIGHT/2 +50,
                z: MAGIC_HEIGHT/2 +1,
                scaleX: 0.7,
                scaleY: 0.7,
                
                onComplete: uzumaki_end,
                onCompleteParams: [scard],                
                time: 0.3,
                transition: "linear" 
            }); 
        }
        
        private function uzumaki_end(scard:Loader):void
        {
            this.removeChild( scard );
            
            if(scard == sup_card10){
                goto3rdAction();
            }
        }


        /*********************************************************************************************************************************
         3rd action : sub card HARETSU & Zoom Main card
         **********************************************************************************************************************************/
    
        private function goto3rdAction():void{
            color = new ColorTransform(1.0, 1.0, 1.0, 1.0, cardW, cardW, cardW, 1);
            sub_card1.addEventListener(Event.ENTER_FRAME, color_update);
        }
        
        // sub_card color update
        private function color_update(e:Event):void{
            var scard:Loader;
            var deg:Number = 36.*i;
            var roundHankeiLocal:Number;
            var    i:uint;
            
            //getting brightness -> 0
            if(color.redOffset > 0){
                color.redOffset   -= 15;
                color.greenOffset -= 15;
                color.blueOffset  -= 15;
                for (i = 1; i <= SUB_CARD_NUM; i++){
                    this["sub_card"+i].transform.colorTransform = color;
                }
            }
            else{
                // stop color updating
                sub_card1.removeEventListener(Event.ENTER_FRAME, color_update);    

                // stop rounding.
                sub_card1.removeEventListener(Event.ENTER_FRAME, circle_update);                

                // stop kiraing.
                stop_kira();

                //adjust////////////////////////////////////////////////////////
                color.redOffset   =0;
                color.greenOffset =0;
                color.blueOffset  =0;
                ////////////////////////////////////////////////////////////////
    
                // Zoom Main Card 
                Tweener.addTween(main_card, {
                    x: (BG02_WIDTH - MAIN_CARD_WIDTH-50)/2,
                    y: (BG02_HEIGHT - MAIN_CARD_HEIGHT-50)/3*2,
                    z: MAGIC_HEIGHT/2,
                    
                    width: MAIN_CARD_WIDTH + 20,
                    height: MAIN_CARD_HEIGHT + 20,
                    time: 0.1,
                    transition: "linear" ,
                    onComplete: lvupAppear,
                    delay: 0.2
                }); 
                

                //sub card HARETSU
                roundHankeiLocal = BG02_WIDTH +100;
                for (i = 1; i <= SUB_CARD_NUM; i++){                    
                    scard = this["sub_card"+i];

                    scard.scaleX = 1;
                    scard.scaleY = 1;
                    scard.transform.colorTransform = color;
                    
                    deg = 36.*i;
                    
                    Tweener.addTween(scard, {
                        //set adjustment
                        x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankeiLocal*Math.cos(2 * Math.PI *(deg/360)),
                        y: MAGIC_HEIGHT/2 - roundHankeiLocal*Math.sin(2 * Math.PI *(deg/360)),
                        time: 1,
                        transition: "easeOutCubic"
                    });
                }
            }
        }

        private var kiraStarted:Boolean = false;
        private var kiraStopFlag:Boolean = false;
        
        private function start_kira():void{
            if(kiraStarted == false){
                kiraSetProperty_Action3();
                kiraStarted = true;
            }
        }
        private function stop_kira( flag:Boolean=true ):void{
            kiraStopFlag = flag;
            kiraStarted = false;
        }
                
        // set kirakira property : random
        private function kiraSetProperty_Action3():void{
            var kiraX:uint = Math.floor(BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(2 * Math.PI * Math.random()));
            var kiraY:uint = Math.floor(main_card.y + MAIN_CARD_HEIGHT*Math.random());        
            
            kiraAppear(kira, kiraX, kiraY, !kiraStopFlag, kiraSetProperty_Action3, 10);
            
            trace("X:"+kiraX + " Y:"+kiraY);
        }
        
        /*********************************************************************************************************************************
         4th action : Level up -> flash Screen & Main card & Level up & rain of cards.  
         **********************************************************************************************************************************/
        // goto4thAction
        // lvup appear
        private function lvupAppear():void{
            try{
                this.getChildIndex( lvup )
            }
            catch(err:ArgumentError){
                // ignore, nothing to do.            
                addChild(lvup);
                setChildIndex(lvup, numChildren - 4);
                
                color = new ColorTransform(1.0, 1.0, 1.0, 1.0, cardW, cardW, cardW, 0);
                
                Tweener.addTween(lvup, {
                    z: 0,
                    time: 1.0, 
                    rotationX: 720,
                    transition: "linear",
                    onComplete: setTimeout,
                    onCompleteParams: [flash_LvlupMcard, 400]
                });
            }            
        }
        
        private function flash_LvlupMcard():void{        
            start_flash_LvlupMcard();
            
            setTimeout(kiraSetProperty_Action4, 1500);
            setTimeout(start_rain_Scards, 1500, true);
            setTimeout(start_flash_Lvlup, 2200);
        }

        
        private function start_flash_LvlupMcard():void{
            color = new ColorTransform(1.0, 1.0, 1.0, 1.0, cardW, cardW, cardW, 0);

            flash_screen();    
            
            lvup.addEventListener(Event.ENTER_FRAME, color_update_LvlupMcard);            
        }

        private function color_update_LvlupMcard(e:Event):void{
            var scard:Loader = e.currentTarget as Loader
            
            //getting brightness -> 0
            if(color.redOffset > 0){
                color.redOffset   -= 15;
                color.greenOffset -= 15;
                color.blueOffset  -= 15;
                
                lvup.transform.colorTransform = color;
                main_card.transform.colorTransform = color;                
            }
            else{                
                //adjust////////////////////////////////////////////////////////
                color.redOffset=0;
                color.greenOffset=0;
                color.blueOffset=0;

                lvup.transform.colorTransform = color;
                main_card.transform.colorTransform = color;
                ////////////////////////////////////////////////////////////////

                lvup.removeEventListener(Event.ENTER_FRAME, color_update_LvlupMcard);
            }
        }
        
        private function flash_screen():void{
            Tweener.addTween(screenWhite, {
                alpha: 1, 
                time: 0.1, 
                transition: "linear"
            });
            
            Tweener.addTween(screenWhite, {
                alpha: 0, 
                time: 0.3, 
                transition: "linear",
                onComplete: lvupAppear,
                delay: 0.1
            });            
        }
        
        
        private function start_rain_Scards(init:Boolean = false):void{
            if( init ){
                cards = new Array();
            }

            if(cards.indexOf( sub_card1 ) == -1){
                rain_Scards( sub_card1 );                
            }
            else if(cards.indexOf( sub_card2 ) == -1){
                rain_Scards( sub_card2 );
            }
            else if(cards.indexOf( sub_card3 ) == -1){
                rain_Scards( sub_card3 );                
            }
            else if(cards.indexOf( sub_card4 ) == -1){
                rain_Scards( sub_card4 );                
            }
            else if(cards.indexOf( sub_card5 ) == -1){
                rain_Scards( sub_card5 );                
            }
            else if(cards.indexOf( sub_card6 ) == -1){
                rain_Scards( sub_card6 );                
            }
            else if(cards.indexOf( sub_card7 ) == -1){
                rain_Scards( sub_card7 );                
            }
            else if(cards.indexOf( sub_card8 ) == -1){
                rain_Scards( sub_card8 );                
            }
            else if(cards.indexOf( sub_card9 ) == -1){
                rain_Scards( sub_card9 );
            }
            else if(cards.indexOf( sub_card10 ) == -1){
                rain_Scards( sub_card10 );                
            }

            setTimeout(start_rain_Scards, 1200);
        }

        private function rain_Scards( scard:Loader ):void{
            scard.x = Math.floor(Math.random() * (BG02_WIDTH-180) + 100);
            scard.y = 0;
            scard.z = 50;
            scard.scaleX = 0.3;
            scard.scaleY = 0.3;
            scard.rotation = 15 * Math.floor(Math.random() * 12);
            scard.alpha = 1;
            
            cards.push( scard );
            scard.addEventListener(Event.ENTER_FRAME, rain_sUpdate);
            
            Tweener.addTween(scard, {
                x: scard.x,
                y: BG02_HEIGHT+50,
                z: 50,
                transition: "linear",
                time: 4, 
                onComplete: rain_ScardsEnd,
                onCompleteParams: [scard]
                
            });
        }

        private function rain_ScardsEnd(scard:Loader):void{
            var index:int ;
            
            scard.removeEventListener(Event.ENTER_FRAME, rain_sUpdate);

            index = cards.indexOf( scard );
            cards.splice(index, 1);
        }

        private function rain_sUpdate(e:Event):void{
            var scard:Loader = e.currentTarget as Loader
            
            scard.rotationY += 10;
        }
        
        private function kiraSetProperty_Action4():void{
            var kiraX:uint = Math.floor(main_card.x + MAIN_CARD_WIDTH/2  *Math.random());
            var kiraY:uint = Math.floor(main_card.y + MAIN_CARD_HEIGHT/2 *Math.random());        
            
            kiraAppear(kiraSmall, kiraX, kiraY, true, kiraSetProperty_Action4, 400*Math.random());
            
            trace("X:"+kiraX + " Y:"+kiraY);
        }

        private var    push_x:Number;
        private var    push_y:Number;
        
        private function start_flash_Lvlup():void{
            color = new ColorTransform(1.0, 1.0, 1.0, 1.0, cardW, cardW, cardW, 0);

            push_x = main_card.x;
            push_y = main_card.y;
            
            lvup.addEventListener(Event.ENTER_FRAME, color_update_Lvlup);            
        }

        private function color_update_Lvlup(e:Event):void{
            //getting brightness -> 0
            if(color.redOffset > 0){
                color.redOffset   -= 15;
                color.greenOffset -= 15;
                color.blueOffset  -= 15;
                
                lvup.transform.colorTransform = color;
                shake_McardUpdate( true );
            }
            else{                
                //adjust////////////////////////////////////////////////////////
                color.redOffset   =0;
                color.greenOffset =0;
                color.blueOffset  =0;
                
                lvup.transform.colorTransform = color;
                ////////////////////////////////////////////////////////////////
                
                lvup.removeEventListener(Event.ENTER_FRAME, color_update_Lvlup);
                shake_McardUpdate( false );
                
                setTimeout(start_flash_Lvlup, 4000*Math.random())
            }
        }

        private function shake_McardUpdate(action:Boolean):void
        {        
            if( action ){
                main_card.x = push_x + Math.random()*4 -2;
                main_card.y = push_y + Math.random()*4 -2;
            }
            else{
                main_card.x = push_x;
                main_card.y = push_y;
            }
        }

        /*********************************************************************************************************************************
         common function        
         **********************************************************************************************************************************/
        
        //cardAppear
        public function cardAppear(card:Loader):void{
            //main_card appear
            if(card == main_card){
                Tweener.addTween(card, {
                    //set adjustment
                    x: (BG02_WIDTH - MAIN_CARD_WIDTH)/2,
                    y: (BG02_HEIGHT - MAIN_CARD_HEIGHT)/3*2,
//                    width: MAIN_CARD_WIDTH,
//                    height: MAIN_CARD_HEIGHT,
                    time: 1.2,
                    transition: "easeOutBack",
                    onComplete: tweenMainCardCompleteHandler,
                    onCompleteParams: [main_card]
                });
            }
                //sub_card appear
            else if(card == sub_card1){
                Tweener.addTween(sub_card1, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(36./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(36./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card2, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(72./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(72./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card3, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(108./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(108./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card4, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(144./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(144./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card5, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(180./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(180./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card6, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(216./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(216./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card7, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(252./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(252./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card8, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(288/360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(288./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card9, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(324./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(324./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });
                Tweener.addTween(sub_card10, {
                    //set adjustment
                    x: BG02_WIDTH/2 -SUB_CARD_WIDTH/2 + roundHankei*Math.cos(0./360),
                    y: roundHeight,
                    z: MAGIC_HEIGHT/2 - roundHankei*Math.sin(0./360),
//                    width: SUB_CARD_WIDTH,
//                    height: SUB_CARD_HEIGHT,
                    time: 0.3,
                    transition: "easeInOutSine"
                });                
            }
        }        
        
        
        public function ReorderByZ():void
        {
            var i:uint;
            
            cards.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            for(i = 0 ; i < cards.length ; i++){
                try{
                    var    idx:int = this.getChildIndex( cards[ i ].child );
                    
                    this.removeChildAt( idx );
                }
                catch(err:ArgumentError){
                    // ignore, nothing to do.            
                }
                
                this.addChild( cards[i].child );
            }            
        }
        

        // kira appear
        private function kiraAppear(kirax:Loader, kiraX:uint, kiraY:uint, replay:Boolean, replayFunc:Function, replayDelay:Number = 20):void{
            addChild( kirax );
            
            kirax.x = kiraX;
            kirax.y = kiraY;
            kirax.z = 0;
            kirax.alpha = 1;
            
            Tweener.addTween(kirax, {
                x: kiraX,
                y: kiraY,
                alpha: 1, 
                time: 0.3, 
                transition: "linear"
            });
            Tweener.addTween(kirax, {
                x: kiraX,
                y: kiraY,
                alpha: 0, 
                time: 0.2, 
                transition: "linear",
                onComplete: kiraRemove,
                onCompleteParams: [ kirax, replay, replayFunc, replayDelay ]
            });
        }
        
        //kira remove
        private function kiraRemove(kirax:Loader, replay:Boolean, replayFunc:Function, replayDelay:Number):void{
            removeChild( kirax );
            
            if( replay ) setTimeout(replayFunc, replayDelay);
        }
        
        /*********************************************************************************************************************************
         during the adjustment        
         **********************************************************************************************************************************/
        
        
    }
}
