/**
 * Copyright takawo ( http://wonderfl.net/user/takawo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bvRx
 */

package {
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;

	public class MultiCurves3 extends Sprite
	{
		
		private var numPoints:uint = 1000;
		
		public function MultiCurves3()
		{
			init();
		}
		private function init():void
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var points:Array = new Array();
			for (var i:uint = 0; i < numPoints; i++)
			{
				points[i] = new Object();
				points[i].x = Math.random()* stage.stageWidth;
				points[i].y = Math.random()* stage.stageHeight;
			}
			
			var xc1:Number = (points[0].x + points[numPoints-1].x )/2;
			var yc1:Number = (points[0].y + points[numPoints-1].y )/2;
			graphics.lineStyle(1);
			graphics.moveTo(xc1,yc1);
			
			for(i = 0; i < numPoints-1; i++)
			{
				var xc:Number = (points[i].x + points[i+1].x)/2;
				var yc:Number = (points[i].y + points[i+1].y)/2;
				graphics.curveTo(points[i].x,points[i].y, xc,yc);
				
			}	
			
			graphics.curveTo(points[i].x,points[i].y,xc1,yc1);		
			
		}
	}
}
