/**
 * Copyright mimshwright ( http://wonderfl.net/user/mimshwright )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bvPE
 */

// forked from mimshwright's Bitmapt drawing speed comparison
package {
	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;
	import flash.text.*;
	import flash.utils.*;
	
	// added to stage, not using cacheAsBitmap
	// 11fps
		
	[SWF(width="500", height="500", frameRate="50")]
	public class BitmapDrawComparison extends Sprite {
		public var timeDisplay:TextField;
		public var lastTime:int = 0;
				
		public function BitmapDrawComparison() {
			addEventListener(Event.ENTER_FRAME, calculateTime);
			
			var circle:Circle;
			var i:int = 0;
			for (; i < 400; i+=1) {
				circle = new Circle();
				circle.x = 500 * Math.random();
				circle.y = 500 * Math.random();
				circle.cacheAsBitmap = false;
				addChild(circle);
			}
				
			timeDisplay = new TextField();
			addChild (timeDisplay);
		}
		
		public function calculateTime(event:Event):void {
			var now:int = getTimer();
			timeDisplay.text = int(1000/(now - lastTime)) + "fps"; // runs around 10-12 fps
			lastTime = now;
		}
	}
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

/** Colored circle useded in demo. */ 
internal class Circle extends Sprite {
	public var v:Point;
	
	public function Circle() {
		super();
		
		graphics.beginFill([0xFF00FF,0xFFFF00,0x00FFFF][int(Math.random() * 3)], 1);
		graphics.drawCircle(0, 0, 20);
		blendMode = BlendMode.MULTIPLY;
		
		scaleX = scaleY = .2 + (2 * Math.random());
		
		v = new Point(Math.random() * 2 - 1, Math.random() * 2 - 1);
		
		addEventListener(Event.ENTER_FRAME, update);
	}
	
	private function update(event:Event):void {
		x += v.x;
		y += v.y;
		
		if (x < 0 || x > 500) { v.x = v.x * -1; }
		if (y < 0 || y > 500) { v.y = v.y * -1; }
	}
}