/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bvES
 */

/**
 * BMD.getPixels() -> loadByte()で復元することは出来ず、
 * PNGEncoder.encode() -> loadByte()だとできる。
 * という検証
 */
package
{
	import flash.events.IOErrorEvent;
	import flash.display.Loader;
	import flash.utils.ByteArray;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.system.LoaderContext;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import jp.progression.data.Resource;
	import jp.progression.data.getResourceById;
	import flash.events.Event;
	import jp.progression.commands.Func;
	import flash.net.URLRequest;
	import jp.progression.commands.net.LoadBitmapData;
	import jp.progression.commands.lists.LoaderList;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import com.adobe.images.*;

	public class ByteArrayToBitmapData extends Sprite
	{
		//---------------------------------------------------------------------------------------------------------------------------------------------
		// Public Properties
		//---------------------------------------------------------------------------------------------------------------------------------------------
		

		//---------------------------------------------------------------------------------------------------------------------------------------------
		// Internal Properties
		//---------------------------------------------------------------------------------------------------------------------------------------------
		private static const IMG_ID:String="http://assets.wonderfl.net/images/related_images/f/fa/fab0/fab06ad785a4776c5d89da6e16233c2ac155ee84";
		private var bmp:Bitmap;
		
		//---------------------------------------------------------------------------------------------------------------------------------------------
		// Public Methods
		//---------------------------------------------------------------------------------------------------------------------------------------------
		public function ByteArrayToBitmapData()
		{
			stage.scaleMode=StageScaleMode.NO_SCALE;
			stage.align=StageAlign.TOP_LEFT;
			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		// getter setter

		//---------------------------------------------------------------------------------------------------------------------------------------------
		// Internal Methods
		//---------------------------------------------------------------------------------------------------------------------------------------------
		private function init(e:Event):void
		{
			
			removeEventListener(Event.ADDED_TO_STAGE, init);

			var lst:LoaderList = new LoaderList();
			lst.addCommand
			(
				new LoadBitmapData(new URLRequest(IMG_ID),{context:new LoaderContext(true)}), 
//				new Func(test1)
//				new Func(test2)
				new Func(test3)
			);
			lst.execute();
		}
		
		
		
		/**
		 * 
		 * 
		 */
		private function test1():void
		{
			var bmd:BitmapData = (getResourceById(IMG_ID)as Resource).toBitmapData();
			var _bmd:BitmapData = new BitmapData(70, 70);
			_bmd.copyPixels(bmd, new Rectangle(200,200,70,70), new Point(0,0));
			bmp = new Bitmap(_bmd);
			addChild(bmp);
			
		}
		
		
		
		private function test2():void
		{
			var bmd:BitmapData = (getResourceById(IMG_ID)as Resource).toBitmapData();
			var _bmd:BitmapData = new BitmapData(70, 70);
			_bmd.copyPixels(bmd, new Rectangle(200,200,70,70), new Point(0,0));
			var arr:ByteArray = _bmd.getPixels(new Rectangle(0,0,_bmd.width,_bmd.height));
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onBytesLoadError);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onBytesLoaded);
			loader.loadBytes(arr);
			
			
			bmp = new Bitmap(null);
			addChild(bmp);
			
		}
		
		
		private function test3():void
		{
			var bmd:BitmapData = (getResourceById(IMG_ID)as Resource).toBitmapData();
			var _bmd:BitmapData = new BitmapData(70, 70);
			_bmd.copyPixels(bmd, new Rectangle(200,200,70,70), new Point(0,0));
			var arr:ByteArray = PNGEncoder.encode(_bmd);
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onBytesLoadError);
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onBytesLoaded);
			loader.loadBytes(arr);
			
			
			bmp = new Bitmap(null);
			addChild(bmp);
			
		}

		private function onBytesLoaded(event:Event):void
		{
			var _bmd:BitmapData = event.target.content['bitmapData'];
			bmp.bitmapData = _bmd;
		}

		private function onBytesLoadError(event:IOErrorEvent):void
		{
			trace("Error loading bytes");
		}
	}
}
