/**
 * Copyright fancyblock ( http://wonderfl.net/user/fancyblock )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/buqN
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.geom.Rectangle;

    public class FlashTest extends Sprite 
    {
        static protected var VERTEX_COUNT:int = 12000;
        
        protected var m_canvas:Sprite = null;
        protected var m_bitmapData:BitmapData = null;
        protected var m_trangleVertex:Array = new Array();
        protected var m_spots:Array = new Array();
        
        public function FlashTest() 
        {
            // create canvas
            m_canvas = new Sprite();
            m_bitmapData = new BitmapData( 465, 465, false, 0x000000 );
            var bmp:Bitmap = new Bitmap( m_bitmapData );
            this.addChild( bmp );
            this.addChild( m_canvas );
            
            // initial the trangle
            var trangleInfo:Array = new Array();
            trangleInfo.push( new Point( 232, 20 ) );
            trangleInfo.push( new Point( 20, 445 ) );
            trangleInfo.push( new Point( 445, 445 ) );
            for( var i:int = 0; i < trangleInfo.length; i++ )
            {
                var spot:Spot = new Spot( this, trangleInfo[i].x, trangleInfo[i].y );
                spot.addEventListener( MouseEvent.MOUSE_DOWN, onStartDrag );
                spot.addEventListener( MouseEvent.MOUSE_UP, onStopDrag );
                
                m_trangleVertex.push( spot );
            }

            genSierpinski();
            renderSpots();
        }
        
        // gen
        protected function genSierpinski():void
        {
            m_spots = new Array();
            
            var p:Point = new Point( 216, 372 );
            
            for ( var i:int = 0; i < VERTEX_COUNT; i++ )
            {
                var randCorner:Spot = m_trangleVertex[int(Math.random()*m_trangleVertex.length)];
                
                var midPoint:Point = new Point( int(( p.x + randCorner.x ) * 0.5), int(( p.y + randCorner.y ) * 0.5) );
                m_spots.push( midPoint );
                
                p = midPoint;
            }
        }
        
        // render 
        protected function renderSpots():void
        {
            m_canvas.graphics.clear();
            m_canvas.graphics.lineStyle( 1, 0xaaa000 );
            m_canvas.graphics.moveTo( m_trangleVertex[m_trangleVertex.length-1].x, m_trangleVertex[m_trangleVertex.length-1].y );

            for( var j:int = 0; j < m_trangleVertex.length; j++ )
            {
                m_canvas.graphics.lineTo( m_trangleVertex[j].x, m_trangleVertex[j].y );
            }
            
            m_bitmapData.fillRect( new Rectangle( 0, 0, 465, 465 ), 0x000000 );
            for( var i:int = 0; i < m_spots.length; i++ )
            {
                m_bitmapData.setPixel( m_spots[i].x, m_spots[i].y, 0xaaa000 ); 
            }
        }

        // start drag
        protected function onStartDrag( evt:MouseEvent ):void
        {
            evt.currentTarget.startDrag();
        }

        // stop drag
        protected function onStopDrag( evt:MouseEvent ):void
        {
            evt.currentTarget.stopDrag();
            
            this.genSierpinski();
            this.renderSpots();
        }
    }
}



import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Point;
import flash.display.Sprite;


class Spot extends Sprite
{
    protected var m_parent:Sprite = null;
    protected var m_bitmap:Bitmap = null;

    public function Spot( parent:Sprite, x:Number, y:Number )
    {
        m_parent = parent;
        
        this.x = x;
        this.y = y;
        
        var bmpData:BitmapData = new BitmapData( 7, 7, true, 0x00000000 );

        // draw a point
        var spr:Sprite = new Sprite();
        spr.graphics.beginFill( 0xffff00 );
        spr.graphics.drawEllipse( 0, 0, 7, 7 );
        spr.graphics.endFill();

        // render to bitmap data
        bmpData.draw( spr, null, null );
        m_bitmap = new Bitmap( bmpData );
       
        m_bitmap.x = -3.5;
        m_bitmap.y = -3.5;

        this.addChild( m_bitmap );
        parent.addChild( this );
    }
}