/**
 * Copyright simon4761 ( http://wonderfl.net/user/simon4761 )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/btFm
 */

package {
    import org.libspark.flartoolkit.core.FLARCode;
    import org.libspark.flartoolkit.core.param.FLARParam;
    import org.libspark.flartoolkit.core.raster.rgb.FLARRgbRaster_BitmapData;
    import org.libspark.flartoolkit.core.transmat.FLARTransMatResult;
    import org.libspark.flartoolkit.detector.FLARSingleMarkerDetector;
    import org.libspark.flartoolkit.support.pv3d.FLARBaseNode;
    import org.libspark.flartoolkit.support.pv3d.FLARCamera3D;
    import org.papervision3d.core.math.Matrix3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.render.LazyRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;


    public class FlashTest extends Sprite {

        protected var canvasWidth : int;
        protected var canvasHeight : int;
        protected var captureWidth : int;
        protected var captureHeight : int;
        protected var codeWidth : int;
        protected var cameraParamFile : String;
        protected var markerPatternFile : String;
        private var urlLoader : URLLoader;
        protected var cameraParam : FLARParam;
        protected var markerPatternCode : FLARCode;
        protected var webCamera : Camera;
        protected var video : Video;
        private var capture : Bitmap;
        private var raster : FLARRgbRaster_BitmapData;
        private var detector : FLARSingleMarkerDetector;
        protected var scene : Scene3D;
        protected var viewport : Viewport3D;
        protected var camera3D : FLARCamera3D;
        protected var markerNode : FLARBaseNode;
        protected var renderer : LazyRenderEngine;
        protected var container : DisplayObject3D;
        private var _modelWRAP : DisplayObject3D;
        private var _dae : DAE;
        private var _lastRot : Number3D;
        private var _recognizer : TextField= new TextField( )

        public function FlashTest() {
            
            this.initialize( );
        }
        protected function initialize() : void {
            captureWidth = 320;
            captureHeight = 240;
            canvasWidth = 640
            canvasHeight = 480;
            codeWidth = 80;
            
            markerPatternFile = 'http://assets.wonderfl.net/static/flar/flarlogo.pat';
            
            this.cameraParam = new FLARParam( );
            this.cameraParam.changeScreenSize( captureWidth, captureHeight );
            this.urlLoader = new URLLoader( );
            this.urlLoader.dataFormat = URLLoaderDataFormat.TEXT;
            this.urlLoader.addEventListener( Event.COMPLETE, this.onLoadCode );
            this.urlLoader.addEventListener( IOErrorEvent.IO_ERROR, dispatchEvent );
            this.urlLoader.addEventListener( SecurityErrorEvent.SECURITY_ERROR, dispatchEvent );
            this.urlLoader.load( new URLRequest( markerPatternFile ) );
        }

        protected function onLoadCode(e : Event) : void {
            this.urlLoader.removeEventListener( Event.COMPLETE, this.onLoadCode );
            this.markerPatternCode = new FLARCode( 16, 16, 50, 50 );
            this.markerPatternCode.loadARPatt( this.urlLoader.data );
            this.urlLoader = null;
            dispatchEvent( new Event( Event.INIT ) );
            this.onInit( );
        }

        protected function onInit() : void {
            this.webCamera = Camera.getCamera( );
            if (!this.webCamera) {
                throw new Error( 'No webcamera!' );
            }
            this.webCamera.setMode( this.captureWidth, this.captureHeight, 30 );
            
            this.video = new Video( this.captureWidth, this.captureHeight );
            this.video.attachCamera( this.webCamera );
            this.capture = new Bitmap( new BitmapData( this.captureWidth, this.captureHeight, false, 0 ), PixelSnapping.AUTO, true );
            this.capture.width = this.canvasWidth;
            this.capture.height = this.canvasHeight;
            this.addChild( this.capture );
            
            this.raster = new FLARRgbRaster_BitmapData( this.capture.bitmapData );
            this.detector = new FLARSingleMarkerDetector( this.cameraParam, this.markerPatternCode, this.codeWidth );
            this.detector.setContinueMode( true );
            this.viewport = this.addChild( new Viewport3D( this.captureWidth, this.captureHeight ) ) as Viewport3D;
            this.viewport.scaleX = this.canvasWidth / this.captureWidth;
            this.viewport.scaleY = this.canvasHeight / this.captureHeight;
            this.viewport.x = -4; 
            this.scene = new Scene3D( );
            this.markerNode = this.scene.addChild( new FLARBaseNode( FLARBaseNode.AXIS_MODE_PV3D ) ) as FLARBaseNode;
            
            // 3Dモデル表示時の視点を設定
            this.camera3D = new FLARCamera3D( this.cameraParam );
            
            // setup renderer
            this.renderer = new LazyRenderEngine( this.scene, this.camera3D, this.viewport );
            
            // モデル格納用のコンテナ作成
            this.container = new DisplayObject3D( );
            // モデルデータ
            this.setModelData( );
            // モデルデータを登録
            this.markerNode.addChild( this.container );
            
            
            //認識非認識チェッカー
            _recognizer = new TextField( );
            _recognizer.autoSize = TextFieldAutoSize.LEFT;
            _recognizer.background = true;
            _recognizer.backgroundColor = 0xcc0000;
            
            addChild( _recognizer );
            
            // start
            this.start( );
//Wonderfl.capture_delay( 10 );
        }

        /**
         * モデルデータを書く場所
         */

        
        protected function setModelData() : void {
            _modelWRAP = new DisplayObject3D( );
            _dae = new DAE( );
            _dae.load( "http://www.romatica.com/work/amazon-san/AmazonCollada.dae" )
            _dae.scale = 13;
            _dae.rotationX = -90
            _dae.rotationZ = 90
            
            _modelWRAP.addChild( _dae );
            scene.addChild( _modelWRAP );
        }

        
        public function start() : void {

            this.addEventListener( MarkerEvent.MARKER_ADDED, this.onMarkerAdded );
            this.addEventListener( MarkerEvent.MARKER_UPDATED, this.onMarkerUpdated );
            this.addEventListener( MarkerEvent.MARKER_REMOVED, this.onMarkerRemoved );
            
            // 処理開始
            this.addEventListener( Event.ENTER_FRAME, this.run );
        }


        protected var resultMat : FLARTransMatResult= new FLARTransMatResult( );

        public function onMarkerAdded(e : Event= null) : void {
            //          trace("[add]");
            _recognizer.text = "認識中"
            _recognizer.backgroundColor = 0xffffff;
         
        }

        public function onMarkerUpdated(e : Event= null) : void {
        }

        public function onMarkerRemoved(e : Event= null) : void {
            _recognizer.text = "非認識"
            _recognizer.backgroundColor = 0xcc0000;
           
        }


        public function run(e : Event) : void {
            this.capture.bitmapData.draw( this.video );
            
            var detected : Boolean= false;
            try {
                detected = this.detector.detectMarkerLite( this.raster, 80 ) && this.detector.getConfidence( ) > 0.5;
            } catch (e : Error) {
            }
            
            if (detected) {
                
                detector.getTransformMatrix( this.resultMat );
                markerNode.setTransformMatrix( this.resultMat );
                var transform : Matrix3D= markerNode.transform;
                _lastRot = Matrix3D.matrix2euler( transform );
                
                this.dispatchEvent( new MarkerEvent( MarkerEvent.MARKER_ADDED ) );
            } else {
                this.dispatchEvent( new MarkerEvent( MarkerEvent.MARKER_REMOVED ) );
            }
            _modelWRAP.x += (markerNode.x - _modelWRAP.x) * 0.1;
            _modelWRAP.y += (markerNode.y - _modelWRAP.y) * 0.1;
            _modelWRAP.z += (markerNode.z - _modelWRAP.z) * 0.1;
            _modelWRAP.rotationX += (_lastRot.x - _modelWRAP.rotationX) * 0.1;
            _modelWRAP.rotationY += (_lastRot.y - _modelWRAP.rotationY) * 0.1;
            _modelWRAP.rotationZ += (_lastRot.z - _modelWRAP.rotationZ) * 0.1;
            this.renderer.render( );
        }
    }
}

import flash.events.Event;


class MarkerEvent extends Event {
    public static const MARKER_ADDED : String= "markerAdded";
    public static const MARKER_UPDATED : String= "markerUpdated";
    public static const MARKER_REMOVED : String= "markerRemoved";

    public function MarkerEvent(type : String, bubbles : Boolean= false, cancelable : Boolean= false) {
        super( type, bubbles, cancelable );
    }
}
