/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/btCY
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.PixelSnapping;
	import flash.display.Shape;
	import flash.events.Event;
	import org.papervision3d.core.geom.Particles;
	import org.papervision3d.core.geom.renderables.Particle;
	import org.papervision3d.materials.special.BitmapParticleMaterial;
	import org.papervision3d.view.BasicView;
	
	/**
	 * Papervsion Particles step 1
	 * @author Mario Gonzalez
	 */
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
	public class ParticleOrbit extends BasicView
	{
		
		private var _particles	:Particles = new Particles();
		private var _particle	:Particle;
		
		
		public function ParticleOrbit() 
		{
			var shape:Shape = new Shape();
			var g:Graphics = shape.graphics;
				g.beginFill(0xff, 0.5);
				g.drawCircle(16, 16, 16);
				g.beginFill(0xffffff);
				g.drawCircle(16, 16, 8);
				g.endFill();
			
			
			var data:BitmapData = new BitmapData(shape.width, shape.height, true, 0xFFFFFF);
				data.draw(shape);
			var bmp:Bitmap = new Bitmap(data, PixelSnapping.ALWAYS, false);
				
			var material:BitmapParticleMaterial = new BitmapParticleMaterial(data, 1);
			
			//Createa a few particles
			_particle = new Particle(material);
			_particles.addParticle(_particle);
			
			for(var i:int = 0; i < 40; i++)
			{
				var pathParticle:Particle = new Particle(material, 1);
				var theta:Number = (i / 40) * Math.PI * 2
				pathParticle.x = Math.cos(theta) * 465;
				pathParticle.y = Math.sin(theta) * 465;
				
				_particles.addParticle(pathParticle);
			}			
			
			scene.addChild(_particles);
			startRendering();
		}
		
		override protected function onRenderTick(e:Event = null):void
		{
			_particles.rotationX += 3
			super.onRenderTick(e);
		}
	}
}