/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bslo
 */

// forked from mash's Ukiuki sample
// copied from http://www.libspark.org/svn/as3/Ukiuki/v0.0/samples/ZigzagSample.as
package  {
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    import org.libspark.ukiuki.Ukiuki;
    import org.libspark.ukiuki.ease.*;
    
    
    public class ZigzagSample extends MovieClip{
        
        public var count:uint;
        public var graph:Graph;
        
        function ZigzagSample(){
            
            graph = new Graph( "default" )
            graph.y = 10;
            graph.x = 20;
            addChild( graph )
            
            Ukiuki.zigzag( graph.line, { y:25}, { time:30, repeat:-1, intervals:[0] } );


            for ( var i0:uint = 0; i0< 5; i0++ ) {// 縦に5個
                
                for ( var i2:uint = 0; i2 < 2; i2++){// 縦方向に2ブロック
                    
                    var ease:Class = [ Back, Bounce, Circ, Cubic, Elastic, Expo, Quad, Quart, Quint, Sine ][ i0*2 + i2 ]
                    var easeName:String = [ "Back", "Bounce", "Circ", "Cubic", "Elastic", "Expo", "Quad", "Quart", "Quint", "Sine" ][ i0*2 + i2 ]
                    
                    for ( var j0:uint = 0; j0 < 3; j0++ ) {//　3個で1組
                        var inOut:String = [ "IN", "OUT", "IN_OUT" ][j0]
                        graph = new Graph( easeName + "." + inOut )
                        graph.y = (i0 * 80) + 80;
                        graph.x = (j0 * 70) + (i2 * 232) + 20;
                        addChild( graph )
                        
                        Ukiuki.zigzag( graph.line, { y:25}, { time:30, tags:[easeName, inOut], ease:ease[inOut], repeat:-1, intervals:[0] } );
                        count++;
                        
                    }
                }
            }
            
        }
    }

}



import flash.display.*;
import flash.text.*;

class Graph extends MovieClip {
    
    public var line:Shape = new Shape();
    public var grObj:Graphics;
    
    function Graph(str:String) {
        
        grObj = this.graphics;
        grObj.lineStyle( 1, 0x666666, 1 );
        grObj.lineTo( 0, 50 );
        grObj.moveTo( 0, 25 );
        grObj.lineTo( 60, 25 );
        
        var text:TextField = new TextField(); 
        text.alpha = 0.8;
        text.scaleX = text.scaleY = 0.8;
        text.text = str;
        text.y = 50;
        addChild( text );
        
        line.y = -25;
        line.graphics.lineStyle( 2, 0x000066, 1 );
        line.graphics.moveTo( 0, 50 );
        line.graphics.lineTo( 60, 50 );
        addChild( line )
        
    }
    
}
