/**
 * Copyright crossisland ( http://wonderfl.net/user/crossisland )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bsdd
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class MultiSpring extends Sprite {
        private var ball:Ball;
        private var handles:Array;
        private var numHandles:Number = 10;
        private var spring:Number = .1;
        private var friction:Number = .8;
        
        public function MultiSpring() {
            init();
        }
        
        private function init():void {
            ball = new Ball(20);
            addChild(ball);
            
            handles = new Array();
            for (var i:Number = 0; i < numHandles; i++) {
                var handle:Ball = new Ball(10);
                handle.x = Math.random() * stage.stageWidth;
                handle.y = Math.random() * stage.stageHeight;
                handle.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
                addChild(handle);
                handles.push(handle);
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            addEventListener(MouseEvent.MOUSE_UP, onRelease);
        }
        
        private function onEnterFrame(event:Event):void {
            for (var i:uint = 0; i < numHandles; i++) {
                var handle:Ball = handles[i] as Ball;
                var dx:Number = handle.x - ball.x;
                var dy:Number = handle.y - ball.y;
                ball.vx += dx * spring;
                ball.vy += dy * spring;
            }
            
            ball.vx *= friction;
            ball.vy *= friction;
            ball.x += ball.vx;
            ball.y += ball.vy;
            
            graphics.clear();
            graphics.lineStyle(2);
            for (i = 0; i < numHandles; i++) {
                graphics.moveTo(ball.x, ball.y);
                graphics.lineTo(handles[i].x, handles[i].y);
            }
        }
        
        private function onPress(event:MouseEvent):void {
            event.target.startDrag();
        }

        private function onRelease(event:MouseEvent):void {
            stopDrag();
        }
    }
}

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Ball(radius:Number=40, color:uint=0x000000) {
        this.radius = radius;
        this.color = color;
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
}
