/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bsMQ
 */

package  
    {
        import flash.display.Sprite;
        import flash.events.Event;
        import flash.media.Sound;
        import flash.media.SoundChannel;
        import flash.media.SoundLoaderContext;
        import flash.media.SoundMixer;
        import flash.media.SoundTransform;
        import flash.net.URLRequest;
        import flash.utils.ByteArray;
        
        [SWF(width=465,height=465)]
        public class Main extends Sprite
        {
            private var snd:Sound;
            private var arr:Array = [];
            
            function Main() 
            {    
                var sp01:Sprite = new Sprite();
                sp01.graphics.beginFill(0);
                sp01.graphics.drawCircle( -25, -25, 50);
                sp01.graphics.endFill();
                sp01.x = stage.stageWidth / 3;
                sp01.y = stage.stageHeight / 2;
                sp01.blendMode = "invert";
                addChild(sp01);
                var sp02:Sprite = new Sprite();
                sp02.graphics.beginFill(0);
                sp02.graphics.drawCircle( 25, 25, 50);
                sp02.graphics.endFill();
                sp02.x = stage.stageWidth / 3 * 2;
                sp02.y = stage.stageHeight / 2;
                sp02.blendMode = "invert";
                addChild(sp02);
                
                arr.push(sp01);
                arr.push(sp02);
                
                playSound("http://www.takasumi-nagai.com/soundfiles/sound007.mp3");
            }
            
            
            private function playSound(sndUrl:String):void
            {
                snd = new Sound();
                var context:SoundLoaderContext = new SoundLoaderContext(10,true);
                var req:URLRequest = new URLRequest(sndUrl);
                snd.load(req, context);
                snd.addEventListener(Event.COMPLETE, soundLoaded);
            }
            
            private function soundLoaded(e:Event):void 
            {
                var sndChannel:SoundChannel=new SoundChannel();
                sndChannel = snd.play(0, 5, new SoundTransform(0.3));
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
            }
            
            
            private function onEnterFrame(event:Event):void {
                var bytes:ByteArray = new ByteArray();
                SoundMixer.computeSpectrum(bytes, false, 0)
                
                var i:uint, j:uint;
                
                for (i = 0; i < 2; i++) {
                    var sp:Sprite = arr[i] as Sprite;
                    var p:Number = 0;
                    for (j = 0; j < 256; j++) {
                        p += bytes.readFloat();
                    }
                    sp.scaleX = sp.scaleY = p;
                }
            }
        }
    }