/**
 * Copyright Nekyo ( http://wonderfl.net/user/Nekyo )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/bs2h
 */

package {
	/**
	 * アリスのピープショー(グレースケール)
	 * Copyright(c) since 2010 Nekyo.
	 * flartoolkit SimpleCube ベースのサンプル
	 * Flarマーカをかざすと、アリスのピープショーが表示されます。
	 * カラー版は N's Gallery (http://nsgalle.appspot.com) で公開中。
	 * @licence: GPL v3 http://www.gnu.org/licenses/gpl.html
	 * Flar マーカーをさくーしゃさんのサイトから http://saqoosha.net/lab/FLARToolKit/flarlogo-marker.pdf
	 */
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;

	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.primitives.Plane;

	import org.libspark.flartoolkit.example.PV3DARApp;

	// ビットマップ読み込み用インクルード
	import org.papervision3d.materials.BitmapMaterial;
	import flash.display.Bitmap;
	import flash.display.BitmapData;

	[SWF(width=640, height=480, backgroundColor=0xffffff, frameRate=30)]

	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.display.Loader;
	import flash.system.LoaderContext;

	import flash.net.navigateToURL;
	import flash.system.Security;
	import flash.system.SecurityPanel;
	import flash.media.Camera;
		
	public class Alice extends PV3DARApp {
		private var _plane:Plane;
		// 対象画像のURL
		private	const image_url:Array = [
			'http://lh5.ggpht.com/_XAjHEdaLqjE/S82nCSiKVFI/AAAAAAAAAGw/8zPesbWn8pg/alice1.png',
			'http://lh5.ggpht.com/_XAjHEdaLqjE/S82nCq7JBmI/AAAAAAAAAG0/ix7SCmzIu6c/alice2.png',
			'http://lh4.ggpht.com/_XAjHEdaLqjE/S82nCtOICLI/AAAAAAAAAG4/1UMP8a4FUmk/alice3.png',
			'http://lh5.ggpht.com/_XAjHEdaLqjE/S82nCv75drI/AAAAAAAAAG8/jKZzLmFsYkg/alice4.png',
			'http://lh4.ggpht.com/_XAjHEdaLqjE/S82nCz2DB1I/AAAAAAAAAHA/uVnZExM2djM/alice5.png',
			'http://lh4.ggpht.com/_XAjHEdaLqjE/S82nOyG_ppI/AAAAAAAAAHM/wS5fcF6I3Pk/alice6.png',
		];

		/**
		 * コンストラクタ
		 */
		public function Alice() {
			var camera:Camera = Camera.getCamera();
			if (!camera) {
				// これを実行すると wonderfl のキャプチャーがされない。
				Security.showSettings(SecurityPanel.CAMERA);
			} else {
				Wonderfl.capture_delay(5);
				// カメラ補正ファイルとパターン定義ファイルのファイル名を渡して初期化。
				addEventListener(Event.INIT, _onInit);
				init(
					'http://assets.wonderfl.net/static/flar/camera_para.dat',
					'http://assets.wonderfl.net/static/flar/flarlogo.pat'
				);
			}
		}

		/**
		 * 画像読み込み完了イベント処理
		 * @param e イベント
		 */
		private function initHandler(event:Event):void
		{
			var loader:Loader = event.target.content.parent;
			var depth:int = 0;
			for (var i:int = 0; i < image_url.length; i++) {
				if (image_url[i] == loader.contentLoaderInfo.url) {
					depth = i;
					break;
				}
			}

			var bitmap:Bitmap = event.target.content as Bitmap;
			//bitmap.smoothing = true;

			// 単純に読み込んだ画像分、z深度を変えてプレーンを作って
			// 貼るだけ。
			var wmat:BitmapMaterial;
			var dist:int = 30;					// ｚ方向の数
			wmat = new BitmapMaterial(bitmap.bitmapData, true);
			wmat.doubleSided = true;
			_plane = new Plane(wmat, 100, 100); // 100mm x 100mm。（マーカー１辺 80mmとしたとき。）
			_plane.rotationX = 180;
			_plane.rotationZ =  90;
			_plane.z = (7 - depth) * dist;		// Z方向のディスタンス
			_markerNode.addChild(_plane);		// _markerNode に addChild するとマーカーに追従する。
		}
 
		/**
		 * イニシャライザ
		 * @param e イベント
		 */
		private function _onInit(e:Event):void {
			// 画像をまとめて読み込む。
			// wonderfl に画像を置ければ [Embed が使えるのに...
			for (var i:int = 0; i < image_url.length; i++) {
				var loader:Loader = new Loader();
				loader.contentLoaderInfo.addEventListener(Event.COMPLETE, initHandler);
				loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOerror);
				loader.load(new URLRequest(image_url[i]), new LoaderContext(true));
			}
			stage.addEventListener(MouseEvent.CLICK, _onClick);
		}

		/**
		 * IOエラー
		 * @param	e
		 */
		private function onIOerror(e:IOErrorEvent):void {
			trace("IO Error." + e.toString());
		}

		/**
		 * クリック時の処理
		 * @param e イベント
		 */
		private function _onClick(e:MouseEvent):void {
			//	mirror = !mirror;	// 反転なんていらないっす。っていうか鏡の国のアリス？
			// 画面がクリックされたら新規ウィンドウでN'sギャラリーでも立ち上げますか。
			navigateToURL(new URLRequest("http://nsgalle.appspot.com/"), "_blank");

		}
	}
}
