/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/brfK
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.ui.Mouse;

   [SWF(width = "480", height = "480", backgroundColor = "0xffffff", fps = "30")] 
	public class Practice10 extends Sprite{
		private var list:Vector.<Ani>;
		private var step:Number = 15;
		private var radius:Number = 20;
		private var centerX:Number;
		private var centerY:Number;
		private var counter:int;
		
		public function Practice10() {
			list = new Vector.<Ani>();
			var angle:Number = 0;
			while (angle < 365) {
				var ani:Ani = new Ani();
				ani.deg = angle / 180 * Math.PI;
				list.push(ani);
				angle += step;
			}
			centerX = 240;
			centerY = 240;
			stage.addEventListener(Event.ENTER_FRAME, update);
			stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
		}
		
		private function update(e:Event):void {
			graphics.clear();
			for (var i:int = 0; i < list.length; i++) {
				var px:Number = radius * Math.cos(list[i].deg)+centerX;
				var py:Number = radius * Math.sin(list[i].deg)+centerY;
				var alpha:Number = (list.length - i) / list.length;
				graphics.beginFill(0xaaaaaa,alpha);
				graphics.drawCircle(px, py, radius/10);
				graphics.endFill();
			}
			graphics.lineStyle(8, 0xaaaaaa);
			graphics.moveTo(centerX, centerY);
			graphics.lineTo(radius * Math.cos(list[10].deg)+centerX, radius * Math.sin(list[10].deg)+centerY);
			list.push(list.shift());
		}
		
		private function onMouseMove(e:MouseEvent):void {
			radius = Math.sqrt(Math.pow(e.stageX - centerX, 2) + Math.pow(e.stageY - centerY, 2));
		}
	}
}

class Ani {
	public var deg:Number;
}