/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/brSc
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.utils.getTimer;
    
    [SWF(backgroundColor="0xFFFFFF", frameRate="30", width="465", height="465")]
    
    public class FlashTest extends Sprite {
        private var startX:int;
        private var startY:int;
        private var maWidth:int;
        private var maHeight:int;
        private var stWidth:int;
        private var stHeight:int;
        private var speed:Number = 1;
        private const MA_COLORS:Array = [0x000000, 0x000000, 0xFFFFFF, 0xFFFFFF];
        private const MA_ALPHAS:Array = [100, 100, 100, 100];
        private const MA_RATIOS:Array = [0x00, 0x7F, 0x80, 0xFF];
        private var maMatrix:Matrix = new Matrix();
        private var canvas:Shape;
        private var ground:BitmapData;
        private var ant:Ant;
        
        public function FlashTest() {
            Wonderfl.capture_delay(10);
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(e:Event = null):void{
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            maMatrix.createGradientBox(5, 5, 2.356195);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown);
            addChild(canvas = new Shape());
        }
        
        private function onDown(e:MouseEvent):void
        {
            startX = stage.mouseX;
            startY = stage.mouseY;
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, onDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
        }
        
        private function onMove(e:MouseEvent):void
        {
            var g:Graphics = canvas.graphics;
            g.clear();
            g.beginGradientFill(GradientType.LINEAR, MA_COLORS, MA_ALPHAS, MA_RATIOS, maMatrix, SpreadMethod.REPEAT);
            g.drawRect(startX, startY, (maWidth = stage.mouseX - startX), (maHeight = stage.mouseY - startY));
            g.drawRect(startX + 1, startY + 1, maWidth - 2, maHeight - 2);
            g.endFill();
        }
        
        private function onUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, onUp);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
            addEventListener(Event.ENTER_FRAME, loop1);
        }
        
        private function loop1(e:Event):void
        {
            var g:Graphics = canvas.graphics;
            g.clear();
            g.beginGradientFill(GradientType.LINEAR, MA_COLORS, MA_ALPHAS, MA_RATIOS, maMatrix, SpreadMethod.REPEAT);
            g.drawRect(startX, startY, maWidth, maHeight);
            g.drawRect(startX + 1, startY + 1, maWidth - 2, maHeight - 2);
            g.endFill();
            maMatrix.tx -= speed;
            speed -= 0.01;
            if(speed < 0)
            {
                removeEventListener(Event.ENTER_FRAME, loop1);
                makeAnt();
            }
        }
        private function makeAnt():void
        {
            var bmd:BitmapData = new BitmapData(stage.stageWidth || 465, stage.stageHeight || 465, false, 0xFFFFFF);
            bmd.draw(removeChild(canvas));
            addChild(new Bitmap(ground = new BitmapData(stWidth = bmd.width, stHeight = bmd.height, false, 0xFFFFFF), "auto", true));
            var rect:Vector.<uint> = bmd.getVector(new Rectangle(startX, startY, maWidth, maHeight));
            ground.lock();
            var n:int = rect.length, i:int, j:int, ix:int, iy:int, a:Ant, b:Ant, c:int,r:Rectangle = new Rectangle(), views:Object = {};
            for(i = 0; i < n; i++)
            {
                if((rect[i] & 1) == 0)
                {
                    ix = i % maWidth;
                    iy = i / maWidth;
                    a = new Ant(ix, iy, Math.random() * (++c) * 10 + 30);
                    rect[i] = 1;
                    if(iy == 0 || iy == maHeight - 1)
                    {
                        a.angle = 0;
                        while(((i + 1) % maWidth != 0) && ((rect[++i] & 1) == 0))
                        {
                            rect[i] = 1;
                            a.len++;
                        }
                    }
                    else
                    {
                        j = i;
                        a.angle = Math.PI / 2;
                        while(((j + maWidth) / maWidth < maHeight) && ((rect[(j += maWidth)] & 1) == 0))
                        {
                            rect[j] = 1;
                            a.len++;
                        }
                    }
                    r.x = (a.x += startX);
                    r.y = (a.y += startY);
                    if(views[a.len] == null) views[a.len] = new BitmapData(a.len, 1, false, 0x0);
                    a.view = views[a.len];
                    if(a.angle == 0)
                    {
                        r.width = a.len;
                        r.height = 1;
                        ground.fillRect(r, 0);
                    }
                    else {
                        a.x++;
                        r.width = 1;
                        r.height = a.len;
                        ground.fillRect(r, 0);
                    }
                    if(ant == null) b = ant = a;
                    else b = b.next = a;
                }
            }
            ground.unlock();
            bmd.dispose();
            addEventListener(Event.ENTER_FRAME, loop2);
        }
        
        private function loop2(e:Event):void
        {
            var a:Ant = ant;
            ground.lock();
            ground.fillRect(ground.rect, 0xFFFFFF);
            do
            {
                maMatrix.a = maMatrix.d = 1;
                maMatrix.b = maMatrix.c = maMatrix.tx = maMatrix.ty = 0;
                if(--a.time < 0)
                {
                    a.speed = Math.random() - 0.1;
                    a.rotation = (Math.random() - 0.5) * 0.1;
                    a.time = 30 + Math.random() * (40 - a.speed * 40);
                }
                maMatrix.rotate(a.angle += a.rotation);
                maMatrix.tx = (a.x += a.speed * Math.cos(a.angle));
                maMatrix.ty = (a.y += a.speed * Math.sin(a.angle));
                ground.draw(a.view, maMatrix, null, null, null, true);
            }
            while(a = a.next)
            ground.unlock();
        }
    }
}

import flash.display.BitmapData;
class Ant
{
    public var x:Number = 0, y:Number = 0, angle:Number = 0, rotation:Number = 0, speed:Number = 0;
    public var len:int = 1, time:int;
    public var next:Ant;
    public var view:BitmapData;
    function Ant(x:Number, y:Number, time:int)
    {
        this.x = x;
        this.y = y;
        this.time = time;
    }

}

