/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bqxp
 */

// forked from shapevent's Circle Cluster
package {

    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;


    [SWF(backgroundColor=0x444444, width=500, height=500)]

       public class Cluster extends MovieClip {
        private var hsw:Number;
        private var hsh:Number;
        private var pointNum:int;
        private var points3D:Vector.<Number>;
        private var points2D:Vector.<Number>;
        private var uvts:Vector.<Number>;
        private var sorted:Array;
        private var pnt:Point;
        private var m:Matrix3D;
        private var v:Vector3D;
        private var p:PerspectiveProjection;
        private var proj:Matrix3D;
        private var dx:Number;
        private var dy:Number;


               public function Cluster(){
                  // init
            hsw = stage.stageWidth / 2;
            hsh = stage.stageHeight / 2;
            
            pointNum = 200;
            points3D = new Vector.<Number>();
            points2D = new Vector.<Number>();
            uvts = new Vector.<Number>();
            sorted = [];
            
            pnt = new Point();
            m = new Matrix3D();
            v = new Vector3D();
            for (var i:int = 0; i<pointNum; i++){
                v.x = Math.random()*400-200;
                m.identity();
                m.appendRotation(Math.random()*360, Vector3D.X_AXIS);
                m.appendRotation(Math.random()*360, Vector3D.Y_AXIS);
                m.appendRotation(Math.random()*360, Vector3D.Z_AXIS);
                v = m.transformVector(v);
                points3D.push(v.x, v.y, v.z);
                points2D.push(0,0);
                uvts.push(0,0,0);
                sorted.push(new Vector3D());
            }
            points3D.fixed = true;
            points2D.fixed = true;
            uvts.fixed = true;
            
            p = new PerspectiveProjection();
            proj = p.toMatrix3D();
            
            dx = 0, dy = 0;
            addEventListener(Event.ENTER_FRAME, onLoop);
            
            
            
            
            

               }
               // private methods

        private function onLoop(evt:Event):void {
            var i:int, j:int;
            dx += (mouseX - dx) / 4;
            dy += (mouseY - dy) / 4;
            m.identity();
            m.appendRotation(dx, Vector3D.Y_AXIS);
            m.appendRotation(dy, Vector3D.X_AXIS);
            m.appendTranslation(0, 0, 1000);
            m.append(proj);
            
            Utils3D.projectVectors(m, points3D, points2D, uvts);
            
            for (i = 0, j = 0; i<points2D.length; i+=2, j++){
                sorted[j].x = points2D[i] + hsw;
                sorted[j].y = points2D[i + 1] + hsh;
                sorted[j].z = uvts[j * 3 + 2];
            }
            sorted.sortOn("z", Array.NUMERIC);
            
            graphics.clear();
            for(i = 0; i<sorted.length; i++){
                var zpos:Number = sorted[i].z * 12000;
                var c:int = zpos * 14;
                //c = (c > 255) ? 255 : c;
                graphics.beginFill(c << 16 | c << 8 | c);
                graphics.drawCircle(sorted[i].x, sorted[i].y,zpos);
                graphics.endFill();
            }
        }
        

       }

}