/**
 * Copyright antalg ( http://wonderfl.net/user/antalg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bqkA
 */

package {
    import flash.filters.BlurFilter;
    /*
    Creator: antalg a.k.a. antalg93 a.k.a. someone93 (deviantART, Kongregate, more...)
    
    The result of me playing with perlin noise making it interact with objects in motion.
    No interaction.
    
    Brighter: hills (balls scale up, and slows down)
    Darker: walleys (balls scale down, and speeds up)
    */
    
    
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    
    [SWF(width = 400, height = 300, frameRate = 30)]
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            bmSpr.addChild(new Bitmap(bmd));          
            addChild(bmSpr);
            
            render();
            
            Global.map = bmd;
            
            for(var i:int = 0; i<128; i++) {
                var spr:Sprite = new Particle();
                
                spr.x = Math.random()*stage.stageWidth;
                spr.y = Math.random()*stage.stageHeight;
                
                addChild(spr);
            }
            
            // addChild(new Stats());
        }
        
        public static var bmd:BitmapData = new BitmapData(400, 300);
        private var bmSpr:Sprite = new Sprite();
        
        private function render():void {
            var baseX              :Number = 100;
            var baseY              :Number = 100;    
            var nOctaves           :Number = 8; 
            var randomSeed         :Number = Math.random()*1000;
            var bStitch            :Boolean = true;
            var bFractalNoise      :Boolean = false;
            var nChannels          :Number = 1;
            var bGreyScale         :Boolean= true;
            
            
            bmd.perlinNoise(baseX, baseY, nOctaves, randomSeed, bStitch, bFractalNoise, nChannels, bGreyScale);
            
            /*for(var y:int = 0; y<300; y++) {
                for(var x:int = 0; x<400; x++) {
                    var c:int = 0.7*Math.sqrt((x-200)*(x-200)+(y-150)*(y-150));
                    var color:uint = c<<16|c<<8|c;
                    
                    
                    bmd.setPixel(x,y,color);
                }
            }
            
            bm.bitmapData = bmd;*/
        }
    }
    
}

import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;

internal class Particle extends Sprite {
    public function Particle() {
        this.graphics.beginFill(0x000011, 0.5);
        this.graphics.drawCircle(0,0,rad);
        this.graphics.endFill();
        this.cacheAsBitmap = true;
        
        var speed:Number = 5;
        var angle:Number = Math.random()*Math.PI*2;
        
        vx = Math.cos(angle)*speed;
        vy = Math.sin(angle)*speed;
        
        this.addEventListener(Event.ENTER_FRAME, move);
    }
    
    private var rad:int = 3;
    private var vx:Number;
    private var vy:Number;
    
    private function move(e:Event):void {
        var val:Number = (Global.map.getPixel(x,y)&255)/256;
        
        scaleX = scaleY = 2*val+0.2;
        
        x+=vx*(1-val);
        y+=vy*(1-val);
        
        wrap();
    }
    
    private function wrap():void {
        if(x<0+rad) x=400-rad;
        else if(x>400-rad) x=rad;
        
        if(y<0+rad) y=300-rad;
        else if(y>300-rad) y=rad;
    }
}

internal class Global {
    public static var map:BitmapData;
    public static var m:Vector.<Number>;
}