/**
 * Copyright kenmaz ( http://wonderfl.net/user/kenmaz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bqN4
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.ui.Mouse;
	import flash.utils.Timer;
	
	/**
	 * ...
	 * @author Kentaro Matsumae
	 */
	public class PuyoPuyo extends Sprite
	{
		private const FRAMERATE:int = 60;
		private var count:int = 0;
		
		private const PUYOS_WIDTH:int = 7;
		private const PUYOS_HEIGHT:int = 12;
		private const PUYO_UNIT_WIDTH:int = 30;
		private const PUYO_UNIT_HIGHT:int = 30;

		private const PUYO_RED:int = 0xFF0000;
		private const PUYO_BLUE:int = 0x0000FF;
		private const PUYO_GREEN:int = 0x00FF00;
		private const PUYO_PURPRE:int = 0xFF00FF;

		private const AREA_WIDTH:int = PUYOS_WIDTH * PUYO_UNIT_WIDTH;
		private const AREA_HEIGHT:int = PUYOS_HEIGHT * PUYO_UNIT_HIGHT;
		private const WALL_WIDTH:int = 1;

		private const KCODE_UP:int = 38;
		private const KCODE_DOWN:int = 40;
		private const KCODE_LEFT:int = 37;
		private const KCODE_RIGHT:int = 39;
		private const KCODE_SPACE_BAR:int = 32;

		private var field:Array = [];
		private var keyFuncs:Array = [];
		private var movingPuyos:Array = [];
		private var movingTimer:Timer = new Timer(500);

		public function PuyoPuyo() 
		{
			field = new Array(PUYOS_HEIGHT).map(function():* {
				return new Array(PUYOS_WIDTH).map(function():* {
					return null;
				})
			});
			
			initKeyFuncs();
			
			stage.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				draw();
			});
			stage.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent):void { 
				if (keyFuncs[e.keyCode]) {
					keyFuncs[e.keyCode]();
					draw();
				}
			});
			
			putNewPuyo();
			
			movingTimer.addEventListener(TimerEvent.TIMER, fallPuyos);
			movingTimer.start();
		}
		
		private function initKeyFuncs():void
		{
			keyFuncs[KCODE_UP] = function():void { rotate(1); };
			keyFuncs[KCODE_DOWN] = function():void { fallPuyos(null); };
			keyFuncs[KCODE_LEFT] = function():void { movePuyos(-1); };
			keyFuncs[KCODE_RIGHT] = function():void { movePuyos(1); };
			keyFuncs[KCODE_SPACE_BAR] = function():void { fallPuyos(null); };
		}
		
		private function rotate(dir:int):void
		{
			if (movingPuyos.length == 2) {
				var rx:int, ry:int;
				var p1:Puyo = movingPuyos[0];
				var p2:Puyo = movingPuyos[1];
				if (p1.x == p2.x) {
					if (p1.y < p2.y) {
						dir *= -1;
					}
					ry = p1.y;
					rx = p1.x + dir;
				}else if (p1.y == p2.y) {
					if (p1.x > p2.x) {
						dir *= -1;
					}
					rx = p1.x;
					ry = p1.y + dir;
				}
				if (0 <= rx && rx < PUYOS_WIDTH && 0 <= ry && ry < PUYOS_HEIGHT && field[ry][rx] == null) {
					p2.x = rx;
					p2.y = ry;
				}
			}
		}
		private function movePuyos(dirX:int):void
		{
			var x0:int = movingPuyos[0].x + dirX;
			var x1:int = movingPuyos[1].x + dirX;
			if (0 <= x0 && 0 <= x1 && x0 < PUYOS_WIDTH && x1 < PUYOS_WIDTH) {
				movingPuyos[0].x = x0;
				movingPuyos[1].x = x1;
			}
		}
		
		private function putNewPuyo():void 
		{
			movingPuyos = [
				new Puyo(3, 0, randomColor()), 
				new Puyo(3, 1, randomColor())
			];
		}
		
		private function randomColor():uint 
		{
			var c:Number = int((Math.random() * 10) % 4);
			switch (c) 
			{
				case 0: return PUYO_RED;
				case 1: return PUYO_GREEN;
				case 2: return PUYO_BLUE;
				case 3: return PUYO_PURPRE;
				default: return null;
			}
		}
		
		private function fallPuyos(e:TimerEvent):void 
		{
			var p0:Puyo = movingPuyos[0];
			var p1:Puyo = movingPuyos[1];
			var y0:int = p0.y + 1;
			var y1:int = p1.y + 1;
			
			if (y0 == PUYOS_HEIGHT || y1 == PUYOS_HEIGHT) {
				field[p0.y][p0.x] = p0;
				field[p1.y][p1.x] = p1;
				makeChain(p0);
				makeChain(p1);
				check();
				putNewPuyo();
				
			}else if (field[y1][p1.x] != null) {
				field[p1.y][p1.x] = p1;
				breakoff(p0);
				makeChain(p0);
				makeChain(p1);
				check();
				putNewPuyo();
				
			}else if (field[y0][p0.x] != null) {
				field[p0.y][p0.x] = p0;
				breakoff(p1);
				makeChain(p0);
				makeChain(p1);
				check();
				putNewPuyo();
				
			}else {
				p0.y = y0;
				p1.y = y1;
			}
		}
		private function breakoff(puyo:Puyo):void
		{
			var distY:int = 0;
			for (var y:int = 0; y < PUYOS_HEIGHT; y++) {
				
				if (field[y][puyo.x] == null) {
					distY = y;
				}else {
					break;
				}
			}
			puyo.y = distY;
			field[distY][puyo.x] = puyo;
		}
		
		private function makeChain(puyo:Puyo):void 
		{
			var others:Array = [];
			if (0 < puyo.x) {
				others.push(field[puyo.y][puyo.x - 1]);
			}
			if(puyo.x < PUYOS_WIDTH - 1) {
				others.push(field[puyo.y][puyo.x + 1]);
			}
			if (0 < puyo.y) {
				others.push(field[puyo.y - 1][puyo.x]);
			}
			if (puyo.y < PUYOS_HEIGHT - 1) {
				others.push(field[puyo.y + 1][puyo.x]);
			}
			
			for each(var other:Puyo in others) {
				if (other && other.color == puyo.color) {
					if (other.chain.indexOf(puyo) == -1) {
						other.chain.push(puyo);	
					}
					if (puyo.chain.indexOf(other) == -1) {
						puyo.chain.push(other);	
					}
				}
			}
		}
		
		private function check():void
		{
			for (var y:int = 0; y < PUYOS_HEIGHT; y++) {
				for (var x:int = 0; x < PUYOS_WIDTH; x++) {
					var puyo:Puyo = field[y][x];
					if (puyo) {
						var chains:Array = new Array();
						countChain(puyo, chains);
						trace(chains.length);
						if (chains.length >= 4) {
							field[y][x] = null;
						}
					}
				}
			}
		}
		
		private function countChain(puyo:Puyo, chains:Array):void
		{
			chains.push(puyo);
			for each(var child:Puyo in puyo.chain) {
				if (chains.indexOf(child) == -1) {
					countChain(child, chains);	
				}
			}
		}
		
		private function draw():void
		{
			graphics.clear();
			graphics.beginFill(0xCCCCCC);
			graphics.drawRect(0, 0, AREA_WIDTH, AREA_HEIGHT);
			graphics.endFill();
			
			graphics.lineStyle(1, 0xAAAAAA);
			for (var x:int = 0; x < PUYOS_WIDTH; x++) {
				graphics.moveTo(x * PUYO_UNIT_WIDTH, 0);
				graphics.lineTo(x * PUYO_UNIT_WIDTH, AREA_HEIGHT);
			}
			for (var y:int = 0; y < PUYOS_HEIGHT; y++) {
				graphics.moveTo(0, y * PUYO_UNIT_HIGHT);
				graphics.lineTo(AREA_WIDTH, y * PUYO_UNIT_HIGHT);
			}
			graphics.moveTo(0, 0);
			
			graphics.lineStyle(1, 0x000000);
			for each (var puyo:Puyo in movingPuyos) {
				drawPuyo(puyo);
			}
			for (y = 0; y < PUYOS_HEIGHT; y++) {
				for (x = 0; x < PUYOS_WIDTH; x++) {
					puyo = field[y][x];
					if (puyo) {
						drawPuyo(puyo);
					}
				}
			}
		}
		private function drawPuyo(puyo:Puyo):void {
			var posx:int = puyo.x;
			var posy:int = puyo.y;
			var col:uint = puyo.color;
			graphics.beginFill(col);
			graphics.drawCircle(
				posx * PUYO_UNIT_WIDTH + PUYO_UNIT_WIDTH / 2, 
				posy * PUYO_UNIT_HIGHT + PUYO_UNIT_HIGHT / 2, 
				PUYO_UNIT_WIDTH/2);
			graphics.endFill();
		}
	}
}
class Puyo
{
	public var x:int;
	public var y:int;
	public var color:uint;
	public var chain:Array;
	
	public function Puyo(_x:int, _y:int, _color:uint)
	{
		this.x = _x;
		this.y = _y;
		this.color = _color;
		this.chain = new Array();
	}
}
