/**
 * Copyright kid ( http://wonderfl.net/user/kid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bqJz
 */

// forked from kid's forked from: forked from: forked from: forked from: Saqoosha challenge for professionals [ Noisy Clock ]
// forked from kid's forked from: forked from: forked from: Saqoosha challenge for professionals [ Noisy Clock ]
// forked from kid's forked from: forked from: Saqoosha challenge for professionals [ Noisy Clock ]
// forked from sekiryou's forked from: Saqoosha challenge for professionals [ Noisy Clock ]
// forked from checkmate's Saqoosha challenge for professionals
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldType;
    import flash.text.FontType;
    import flash.text.TextFormatAlign;

    [SWF(width = "244", height = "244", backgroundColor = "0xffffff", frameRate = "30")]

    public class NoisyClock extends Sprite {
        private const STAGE_WIDTH:Number = stage.stageWidth;
        private const STAGE_HEIGHT:Number = stage.stageHeight;
        private const STAGE_CENTER_X:Number = stage.stageWidth / 2;
        private const STAGE_CENTER_Y:Number = stage.stageHeight / 2;
        private const RADIAN_TO_DEGREE:Number = 180 / Math.PI;
        private const DEGREE_TO_RADIAN:Number = Math.PI / 180;
        private var clockMC:MovieClip
        private var second_hand:Sprite;
        private var minute_hand:Sprite;
        private var hour_hand:Sprite;
        private var center_pin:Sprite;
        private var frame:Sprite;
        private var frame_shadow:Sprite;
        private var base_color:uint = 0x000000;
        private var second_hand_shadow:Sprite;
        private var minute_hand_shadow:Sprite;
        private var hour_hand_shadow:Sprite;
        private var center_pin_shadow:Sprite;
        private var rSeconds:Number;
        private var rMinutes:Number;
        private var rHours:Number;
        private var onmArray:Array = [];

        public function NoisyClock() {
            init();
        }
        private function init():void {
            clock();
            var now_date:Date = new Date();
            second_hand.rotation = now_date.seconds * 6;
            second_hand_shadow.rotation = now_date.seconds * 6;
            rSeconds = now_date.seconds;
            minute_hand.rotation = now_date.minutes * 6;
            minute_hand_shadow.rotation = now_date.minutes * 6;
            rMinutes = now_date.minutes;
            hour_hand.rotation = now_date.hours * 30 + now_date.minutes/2;
            hour_hand_shadow.rotation = now_date.hours * 30 + now_date.minutes / 2;
            rHours = now_date.hours;
            addEventListener(Event.ENTER_FRAME, main)
        }
        private function main(eventObject:Event):void {
            var now_date:Date = new Date();
            if ( rSeconds != now_date.seconds ) {
                second_hand.rotation = now_date.seconds * 6;
                second_hand_shadow.rotation = now_date.seconds * 6;
                rSeconds = now_date.seconds;
                SecondsCartoon();
            }
            if ( rSeconds == 1 && rMinutes == 0 && rHours != now_date.hours ) {
                clockMC.x = Math.cos( ( hour_hand.rotation + 90 ) * DEGREE_TO_RADIAN ) * 480 + STAGE_CENTER_X;
                clockMC.y = Math.sin( ( hour_hand.rotation + 90 ) * DEGREE_TO_RADIAN ) * 480 + STAGE_CENTER_Y;
                clockMC.scaleX = clockMC.scaleY = 2.8;
            } else if ( rSeconds == 2 && rMinutes == 0 && rHours != now_date.hours ) {
                rHours = now_date.hours;
                HoursCartoon();
            } else if ( rSeconds > 58 ) {
                clockMC.x = Math.cos( ( minute_hand.rotation + 90 ) * DEGREE_TO_RADIAN ) * 280 + STAGE_CENTER_X;
                clockMC.y = Math.sin( ( minute_hand.rotation + 90 ) * DEGREE_TO_RADIAN ) * 280 + STAGE_CENTER_Y;
                clockMC.scaleX = clockMC.scaleY = 2.0;
            } else if( rSeconds == 0 && rMinutes != now_date.minutes ) {
                minute_hand.rotation = now_date.minutes * 6;
                minute_hand_shadow.rotation = now_date.minutes * 6;
                hour_hand.rotation = now_date.hours * 30 + now_date.minutes/2;
                hour_hand_shadow.rotation = now_date.hours * 30 + now_date.minutes / 2;
                rMinutes = now_date.minutes;
                MinutesCartoon();
            } else if( rSeconds > 2) {
                clockMC.x = STAGE_CENTER_X;
                clockMC.y = STAGE_CENTER_Y;
                clockMC.scaleX = clockMC.scaleY = 1.0;
            }

            var i:int = onmArray.length
            while ( i--) {
                var t = onmArray[ i ]
                t.vy += 0.10;
                t.x += t.vx
                t.y += t.vy;
                t.rotation += t.rot;
                if ( t.y > STAGE_HEIGHT + 0 ) {
                    onmArray.splice(i, 1);
                    clockMC.removeChild( t );
                }
                if ( Math.sqrt(t.x * t.x + t.y * t.y ) > 185 && t.reactFlag == false ) {
                    t.scaleX = t.scaleY *= 1.4; 
                    t.reactFlag = true;
                    t.rot *= -1;
                    t.vy *= -0.4;
                }
            }
        }
        private function SecondsCartoon():void {
            var sO:SecOnomatopoeia = new SecOnomatopoeia();
            clockMC.addChild( sO );

            var radius:int = Math.random() * 20 + 120;
            var onmPos:Number = ( rSeconds * 6 + 180 ) * DEGREE_TO_RADIAN;
            sO.x = -Math.sin( onmPos ) * radius;
            sO.y = Math.cos( onmPos ) * radius;

            sO.vx = Math.random() * 3 - 1.5;
            sO.vy = Math.random() * 1 - 2;
            sO.rot = Math.random() * 3 - 1.5;
            sO.rotation = Math.random() * 40 - 20;
            sO.scaleX = sO.scaleY = Math.random() * 0.2 + 0.4;
            onmArray.push( sO );
        }
        private function MinutesCartoon():void {
            var mO:MinOnomatopoeia = new MinOnomatopoeia();
            clockMC.addChild( mO );

            var radius:int = Math.random() * 20 + 120;
            var onmPos:Number = ( rMinutes * 6 + 180 ) * DEGREE_TO_RADIAN;
            mO.x = -Math.sin( onmPos ) * radius;
            mO.y = Math.cos( onmPos ) * radius;

            mO.vx = Math.random() * 3 - 1.5;
            mO.vy = Math.random() * 1 - 2;
            mO.rot = Math.random() * 3 - 1.5;
            mO.rotation = Math.random() * 40 - 20;
            mO.scaleX = mO.scaleY = Math.random() * 0.2 + 0.7;
            onmArray.push( mO );
        }
        private function HoursCartoon():void {
            var hO:HourOnomatopoeia = new HourOnomatopoeia();
            clockMC.addChild( hO );

            var radius:int = Math.random() * 10 + 140;
            var onmPos:Number = ( rHours * 30  + rMinutes / 2 + 180 ) * DEGREE_TO_RADIAN;
            hO.x = -Math.sin( onmPos ) * radius;
            hO.y = Math.cos( onmPos ) * radius;

            hO.vx = Math.random() * 2 - 1;
            hO.vy = Math.random() * 2 - 3 ;
            hO.rot = Math.random() * 2 - 1;
            hO.rotation = Math.random() * 40 - 20;
            hO.scaleX = hO.scaleY = Math.random() * 0.2 + 1.1;
            onmArray.push( hO );
        }
        private function clock():void {
            var st:ScreenTone = new ScreenTone()

            clockMC = new MovieClip();
            addChild( clockMC );
            clockMC.x = STAGE_CENTER_X;
            clockMC.y = STAGE_CENTER_Y;

            frame_shadow = new Sprite();
            frame_shadow.graphics.beginBitmapFill( st.st1 );
            frame_shadow.graphics.lineStyle( 1, 0xffffff );
            frame_shadow.graphics.drawCircle( 0, 0, 220);
            frame_shadow.graphics.drawCircle( 0, 0, 190);
            frame_shadow.graphics.endFill();
            frame_shadow.x = 8;
            frame_shadow.y = 8;
            clockMC.addChild( frame_shadow );

            frame = new Sprite();
            frame.graphics.beginFill( 0xffffff );
            frame.graphics.lineStyle( 1, base_color );
            frame.graphics.drawCircle( 0, 0, 220);
            frame.graphics.drawCircle( 0, 0, 190);
            frame.graphics.endFill();
            frame.x = 0;
            frame.y = 0;
            clockMC.addChild( frame );

            var tf:TextFormat = new TextFormat();
            tf.size = 38;
            tf.align = TextFormatAlign.CENTER;
            tf.bold = true

            var txtArray:Array = []

            for ( var i:uint = 1; i < 13; i++ ) {
                var txt = new TextField();
                txt.width = 20;
                txt.height = 20;

                var radius:int = 160;
                var txtPos:Number = ( i * 30 + 180 ) * DEGREE_TO_RADIAN;
                txt.x = Math.cos( txtPos ) * 0 - Math.sin( txtPos ) * radius - txt.width / 2;
                txt.y = Math.cos( txtPos ) * radius + Math.sin( txtPos ) * 0 - txt.height / 2;

                txt.type = TextFieldType.DYNAMIC;
                txt.border = false;
                txt.background = false;

                txt.textColor = 0x666666;
                txt.defaultTextFormat = tf;

                txt.text = i;
                clockMC.addChild( txt );
                txtArray.push( txt );
            }

            hour_hand_shadow = new Sprite();
            hour_hand_shadow.graphics.beginBitmapFill( st.st1 );
            hour_hand_shadow.graphics.lineStyle( 1, 0xffffff );
            hour_hand_shadow.graphics.drawRect( -4, 0, 8, -100 );
            hour_hand_shadow.graphics.endFill();
            hour_hand_shadow.x = 4;
            hour_hand_shadow.y = 4;
            clockMC.addChild( hour_hand_shadow );

            minute_hand_shadow = new Sprite();
            minute_hand_shadow.graphics.beginBitmapFill( st.st1 );
            minute_hand_shadow.graphics.lineStyle( 1, 0xffffff );
            minute_hand_shadow.graphics.drawRect( -2.5, 0, 5, -150 );
            minute_hand_shadow.graphics.endFill();
            minute_hand_shadow.x = 4;
            minute_hand_shadow.y = 4;
            clockMC.addChild( minute_hand_shadow );

            hour_hand = new Sprite();
            hour_hand.graphics.beginFill( 0xffffff );
            hour_hand.graphics.lineStyle( 1, base_color );
            hour_hand.graphics.drawRect( -4, 0, 8, -100 );
            hour_hand.graphics.endFill();
            hour_hand.x = 0;
            hour_hand.y = 0;
            clockMC.addChild( hour_hand );

            minute_hand = new Sprite();
            minute_hand.graphics.beginFill( 0x00ffffff );
            minute_hand.graphics.lineStyle( 1, base_color );
            minute_hand.graphics.drawRect( -2.5, 0, 5, -150 );
            minute_hand.graphics.endFill();
            minute_hand.x = 0;
            minute_hand.y = 0;
            clockMC.addChild( minute_hand );

            second_hand_shadow = new Sprite();
            second_hand_shadow.graphics.lineStyle( 4, base_color, 0.3 );
            second_hand_shadow.graphics.moveTo( 0, 30 );
            second_hand_shadow.graphics.lineTo( 0, -156 );
            second_hand_shadow.x = 4;
            second_hand_shadow.y = 4;
            clockMC.addChild( second_hand_shadow );

            second_hand = new Sprite();
            second_hand.graphics.lineStyle( 2, base_color );
            second_hand.graphics.moveTo( 0, 30 );
            second_hand.graphics.lineTo( 0, -156 );
            second_hand.x = 0;
            second_hand.y = 0;
            clockMC.addChild( second_hand );

            center_pin_shadow = new Sprite();
            center_pin_shadow.graphics.beginFill( 0x000000 );
            center_pin_shadow.graphics.lineStyle( 1, 0xffffff );
            center_pin_shadow.graphics.drawCircle( 0, 0, 8 );
            center_pin_shadow.graphics.endFill();
            center_pin_shadow.x = 4;
            center_pin_shadow.y = 4;
            center_pin_shadow.alpha = 0.3;
            clockMC.addChild( center_pin_shadow );

            center_pin = new Sprite();
            center_pin.graphics.beginFill( 0x000000 );
            center_pin.graphics.lineStyle( 1, base_color );
            center_pin.graphics.drawCircle( 0, 0, 8 );
            center_pin.graphics.endFill();
            center_pin.x = 0;
            center_pin.y = 0;
            clockMC.addChild( center_pin );
        }
    }
}

import flash.display.Sprite;
import flash.display.BitmapData;
class ScreenTone extends Sprite
{
    public var st0:BitmapData;
    public var st1:BitmapData;
    public var st2:BitmapData;
    public function ScreenTone():void {
        var base_color:uint = 0x000000;
        st0 = new BitmapData( 4, 4, false, 0x00ffffff);
        var ptn =
            [[1, 0, 0, 0],
            [0, 0, 0, 0],
            [0, 0, 1, 0],
            [0, 0, 0, 0]]
        var bitmapW:int = ptn[0].length;
        var bitmapH:int = ptn.length;
        for (var yy:int = 0; yy < bitmapH; yy++) {
            for (var xx:int = 0; xx < bitmapW; xx++) {
                if ( ptn[yy][xx] == 1 ) {
                    st0.setPixel32( xx, yy, base_color );
                }
            }
        }
        st1 = new BitmapData( 2, 2, false, 0x00ffffff);
        ptn =
            [[1, 0],
            [0, 1]]
        bitmapW = ptn[0].length;
        bitmapH = ptn.length;
        for (yy = 0; yy < bitmapH; yy++) {
            for (xx = 0; xx < bitmapW; xx++) {
                if ( ptn[yy][xx] == 1 ) {
                    st1.setPixel32( xx, yy, base_color );
                }
            }
        }
        st2 = new BitmapData( 6, 6, false, 0x00ffffff);
        ptn =
            [[1, 0, 1, 0, 0, 0],
            [0, 1, 0, 0, 0, 0],
            [1, 0, 1, 0, 0, 0],
            [0, 0, 0, 1, 0, 1],
            [0, 0, 0, 0, 1, 0],
            [0, 0, 0, 1, 0, 1]]
        bitmapW = ptn[0].length;
        bitmapH = ptn.length;
        for (yy = 0; yy < bitmapH; yy++) {
            for (xx = 0; xx < bitmapW; xx++) {
                if ( ptn[yy][xx] == 1 ) {
                    st2.setPixel32( xx, yy, base_color );
                }
            }
        }
    }
}

import flash.display.Sprite;
class SecOnomatopoeia extends Sprite
{
    private var color:uint;
    public var scale:Number;
    public var px:Number;
    public var py:Number;
    public var rot:Number;
    public var vx:Number;
    public var vy:Number;
    public var reactFlag:Boolean = false;    

    public function SecOnomatopoeia( color:uint = 0x000000 )
    {
        this.color = color;
        init();
    }
    public function init():void
    {
        var xx:int = -28;
        var yy:int = -13;
        graphics.beginFill(color);
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx, yy );
        graphics.lineTo( xx+10, yy );
        graphics.lineTo( xx+12, yy-10 );
        graphics.lineTo( xx+17, yy-10 );
        graphics.lineTo( xx+15, yy );
        graphics.lineTo( xx+29, yy );
        graphics.lineTo( xx+24, yy+25 );
        graphics.lineTo( xx+20, yy+25 );
        graphics.lineTo( xx+25, yy+5 );
        graphics.lineTo( xx+15, yy+5 );
        graphics.lineTo( xx+10, yy+23);
        graphics.lineTo( xx+5, yy+25 );
        graphics.lineTo( xx+10, yy+5 );
        graphics.lineTo( xx+0, yy+5 );
        graphics.lineTo( xx, yy );
        graphics.endFill();

        graphics.beginFill(color);
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+35, yy+12 );
        graphics.lineTo( xx+38, yy+9 );
        graphics.lineTo( xx+42, yy+17 );
        graphics.lineTo( xx+40, yy+20 );
        graphics.lineTo( xx+35, yy+12 );
        graphics.endFill();

        graphics.beginFill(color);
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+41, yy+8 );
        graphics.lineTo( xx+44, yy+5 );
        graphics.lineTo( xx+48, yy+13 );
        graphics.lineTo( xx+46, yy+16 );
        graphics.lineTo( xx+41, yy+8 );
        graphics.endFill();

        graphics.beginFill(color);
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+53, yy+11 );
        graphics.lineTo( xx+58, yy+15 );
        graphics.lineTo( xx+48, yy+27 );
        graphics.lineTo( xx+45, yy+26 );
        graphics.lineTo( xx+53, yy+11 );
        graphics.endFill();
    }
}

import flash.display.Sprite;
class MinOnomatopoeia extends Sprite
{
    private var color:uint;
    public var scale:Number;
    public var px:Number;
    public var py:Number;
    public var rot:Number;
    public var vx:Number;
    public var vy:Number;
    public var reactFlag:Boolean = false;    

    public function MinOnomatopoeia( color:uint = 0x000000 )
    {
        this.color = color;
        init();
    }
    public function init():void
    {
        var st:ScreenTone = new ScreenTone()
        var xx:int = -45;
        var yy:int = -20;

        graphics.beginBitmapFill( st.st0 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx, yy );
        graphics.lineTo( xx+10, yy );
        graphics.lineTo( xx+12, yy-10 );
        graphics.lineTo( xx+15, yy-10 );
        graphics.lineTo( xx+14, yy );
        graphics.lineTo( xx+32, yy );
        graphics.lineTo( xx+24, yy+25 );
        graphics.lineTo( xx+20, yy+25 );
        graphics.lineTo( xx+25, yy+5 );
        graphics.lineTo( xx+13, yy+5 );
        graphics.lineTo( xx+9, yy+25);
        graphics.lineTo( xx+6, yy+27 );
        graphics.lineTo( xx+9, yy+5 );
        graphics.lineTo( xx+0, yy+5 );
        graphics.lineTo( xx, yy );
        graphics.endFill();


        graphics.beginBitmapFill( st.st0 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx + 58, yy - 6 );
        graphics.lineTo( xx + 35, yy + 9 );
        graphics.lineTo( xx + 37, yy + 10 );
        graphics.lineTo( xx + 48, yy + 5 );
        graphics.lineTo( xx + 47, yy + 12 );
        graphics.lineTo( xx + 36, yy + 13 );
        graphics.lineTo( xx + 37, yy + 16 );
        graphics.lineTo( xx + 47, yy + 15 );
        graphics.lineTo( xx + 44, yy + 32 );
        graphics.lineTo( xx + 46, yy + 31 );
        graphics.lineTo( xx + 50, yy + 15 );
        graphics.lineTo( xx + 64, yy + 13 );
        graphics.lineTo( xx + 63, yy + 10 );
        graphics.lineTo( xx + 50, yy + 12 );
        graphics.lineTo( xx + 52, yy + 3 );
        graphics.lineTo( xx + 61, yy - 2 );
        graphics.lineTo( xx + 58, yy - 6 );
        graphics.endFill();


        graphics.beginBitmapFill( st.st0 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+66, yy+20 );
        graphics.lineTo( xx+69, yy+17 );
        graphics.lineTo( xx+71, yy+23 );
        graphics.lineTo( xx+69, yy+26 );
        graphics.lineTo( xx+66, yy+20 );
        graphics.endFill();

        graphics.beginBitmapFill( st.st0 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+72, yy+16 );
        graphics.lineTo( xx+75, yy+15 );
        graphics.lineTo( xx+78, yy+20 );
        graphics.lineTo( xx+75, yy+22 );
        graphics.lineTo( xx+72, yy+16 );
        graphics.endFill();

        graphics.beginBitmapFill( st.st0 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+84, yy+20 );
        graphics.lineTo( xx+90, yy+22 );
        graphics.lineTo( xx+76, yy+37 );
        graphics.lineTo( xx+73, yy+37 );
        graphics.lineTo( xx+84, yy+20 );
        graphics.endFill();
    }
}

import flash.display.Sprite;
class HourOnomatopoeia extends Sprite
{
    private var color:uint;
    public var scale:Number;
    public var px:Number;
    public var py:Number;
    public var rot:Number;
    public var vx:Number;
    public var vy:Number;
    public var reactFlag:Boolean = false;    

    public function HourOnomatopoeia( color:uint = 0x000000 )
    {
        this.color = color;
        init();
    }
    public function init():void
    {
        var st:ScreenTone = new ScreenTone()
        var xx:int = -48;
        var yy:int = -10;

        graphics.beginBitmapFill( st.st2 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+2, yy+17 );
        graphics.lineTo( xx+6, yy+20 );
        graphics.lineTo( xx+20, yy+6 );
        graphics.lineTo( xx+18, yy+1 );
        graphics.lineTo( xx+2, yy+17 );
        graphics.endFill();

        graphics.beginBitmapFill( st.st2 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+23, yy+4 );
        graphics.lineTo( xx+26, yy+1 );
        graphics.lineTo( xx+38, yy+18 );
        graphics.lineTo( xx+35, yy+25 );
        graphics.lineTo( xx+23, yy+4 );
        graphics.endFill();

        graphics.beginBitmapFill( st.st2 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+32, yy+0 );
        graphics.lineTo( xx+36, yy-2 );
        graphics.lineTo( xx+39, yy+5 );
        graphics.lineTo( xx+37, yy+7 );
        graphics.lineTo( xx+32, yy+0 );
        graphics.endFill();

        graphics.beginBitmapFill( st.st2 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+38, yy-2 );
        graphics.lineTo( xx+42, yy-4 );
        graphics.lineTo( xx+45, yy+3 );
        graphics.lineTo( xx+43, yy+5 );
        graphics.lineTo( xx+38, yy-2 );
        graphics.endFill();


        graphics.beginBitmapFill( st.st2 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+67, yy+11 );
        graphics.lineTo( xx+42, yy+11 );
        graphics.lineTo( xx+43, yy+15 );
        graphics.lineTo( xx+68, yy+16 );
        graphics.lineTo( xx+67, yy+11 );
        graphics.endFill();


        graphics.beginBitmapFill( st.st2 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+69, yy+5 );
        graphics.lineTo( xx+73, yy+1 );
        graphics.lineTo( xx+76, yy+6 );
        graphics.lineTo( xx+74, yy+12 );
        graphics.lineTo( xx+69, yy+5 );
        graphics.endFill();

        graphics.beginBitmapFill( st.st2 );
        graphics.lineStyle( 1, color, 1.0 );
        graphics.moveTo( xx+89, yy+12 );
        graphics.lineTo( xx+95, yy+15 );
        graphics.lineTo( xx+73, yy+28 );
        graphics.lineTo( xx+70, yy+26 );
        graphics.lineTo( xx+89, yy+12 );
        graphics.endFill();
    }
}