/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bqFp
 */

package {
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
          
            var pic:Bitmap;
            var bdat:BitmapData;
            
            bdat = new BitmapData(128,128,false,0);
            canvas = bdat;
            
            var i:int;
            var k:int;
            var num:int;
            var c:uint;
            num = bdat.width * bdat.height;
            c = 0xFF;
            for (i = 0; i < num; i++)
            {
                c = ((qx*255) <<16)|((qy*255) <<8)|((qz*255));
                rotAng(0.002);
                rotAng(0.003,1);
                rotAng(0.001,2);
                
                bdat.setPixel(i%bdat.width, i/bdat.width, c);
            }//nexti
            
            
            pic = new Bitmap(bdat);            
            addChild(pic);
            pic.filters = [new BlurFilter()];
            pic.scaleX = 2;
            pic.scaleY = 2;
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var canvas:BitmapData;
        
        public var ang:Number = 0;
        
        public function onEnter(e:Event):void
        {
            canvas.lock();
            
            qx = 0; qy = 0; qz = 0; qw = 1;
            ang += 0.3;
            
            var u:Number;
            
            rotAng(ang, 0);
           // rotAng(ang, 1);
            //rotAng(ang, 2);
            
            u = 0.1; // Math.cos(ang)*Math.sin(ang)*0.5;
      
            var i:int;
            var k:int;
            var num:int;
            var c:uint;
            var cr:int; var cg:int; var cb:int;
            var cx:Number;
            var cy:Number;
            num = canvas.width * canvas.height;
            c = 0xFF;
            cr = 0; cg = 0; cb = 0;
            for (i = 0; i < num; i++)
            {
                cx = i%canvas.width;
                cy = i/canvas.height;
                
                cr = (((Math.sin(cx*0.1)*Math.sin(cy*0.1)*(1-qw)*255))&0xFF);
                //cg = (((Math.cos(cx*0.1)*Math.cos(cy*0.1)*(2-qx*qw)*255))&0xFf)*0.5;
                //cg = (((Math.cos(cy)*qy*255))&0xFF);                
                cb = (((Math.cos(Math.sqrt(cx*cx+cy*cy)*0.1)*qw*255))&0xFF);
                
                c = (cr<<16) | (cg<<8) | (cb);
                
                rotAng(u, 0);
               // rotAng(u, 1);
                //rotAng(u, 2);
                
                
                canvas.setPixel(cx, cy, c);
            }//nexti
            
            
            canvas.unlock();
        }//onenter
        
        
        public var qx:Number = 0;
        public var qy:Number = 0;
        public var qz:Number = 0;
        public var qw:Number = 1;
        
        public function rotAng(a:Number, t:int=0):void
        {
          var tx:Number;         var ty:Number;
          var tz:Number;         var tw:Number;
          var bx:Number;         var by:Number;
          var bz:Number;         var bw:Number;
                     
            a *= 0.5;
            bx = 0; by =0; bz  =0;
            bw = Math.cos(a);
            if (t == 0)    {    bx = Math.sin(a);    }
            else if (t == 1)   {  by = Math.sin(a);    }
            else  {  bz = Math.sin(a);  }    
   
           tx = (qw*bx + qx*bw + qy*bz - qz*by); 
           ty = (qw*by + qy*bw + qz*bx - qx*bz);
           tz = (qw*bz + qz*bw + qx*by - qy*bx);     
           tw = (qw*bw - qx*bx - qy*by - qz*bz);
                     
            qx = tx;            qy = ty;
            qz = tz;            qw = tw;
        }//rotyaw
        
        public function normalise():void
        {
          var mag:Number;
          mag = qx*qx + qy*qy+ qz*qz+ qw*qw;
          if (mag == 1) { return; }         
          mag = 1 / mag;
          qx *= mag; qy *= mag; qz *= mag; qw *= mag; 
        }//normalise
        
        
    }//classend
}