/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bq6w
 */






package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import flash.media.Microphone;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
 
    //[SWF(width = 300, height = 300, frameRate = 60)]
 

    public class MicExam extends BasicView {
        private var mic:Microphone;
        private var sphere:Sphere;

        public function MicExam() 
        {
            viewport.opaqueBackground = 0x000000;
            
            mic = Microphone.getMicrophone();
            if (mic != null) {
            mic.setLoopBack(true);
            mic.gain = 50;
            mic.rate = 11;
            mic.setSilenceLevel(5);

            SoundMixer.soundTransform = new SoundTransform(0);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            var material:WireframeMaterial = new WireframeMaterial(0x0099FF);
            sphere = new Sphere(material, 800, 20, 20);
            scene.addChild(sphere);
            }
            
            startRendering();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame(e:Event):void {

            // 球体のスケールを制御
            sphere.scale -= 0.10;//0.01;
            sphere.scale = Math.max(mic.activityLevel*0.01,sphere.scale);
            
            // 球体の回転を制御
            sphere.rotationX += Math.max(mic.activityLevel) *2;
            sphere.rotationY += Math.max(mic.activityLevel) *4;
        }

    }
}