/**
 * Copyright dhaya ( http://wonderfl.net/user/dhaya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bq0l
 */

// forked from a24's メタボールの練習
package
{
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.geom.ColorTransform;
	import flash.filters.BlurFilter;
	import net.hires.debug.Stats;

	public class MetaBall extends Sprite
	{
		private var _size:int = 150;
		private var _num:int = 3;
		private var _canvas:BitmapData = new BitmapData( 600,  600 , true , 0x00000000 );
		private var _bmpData:BitmapData = new BitmapData( 600,  600 , true , 0x00000000 );
		private var _rect:Rectangle = new Rectangle( 0 , 0 , 600 , 600 );
		private var _objAry:Array = new Array();
		private var _alphaArray:Array = new Array();
		private var _container:Sprite = new Sprite();
		private var _moving:Boolean = false;
		
		public function MetaBall()
		{
			addChild( new Stats() );
    
			//_container.visible = false;
			_container.alpha = 0;
			addChild( _container );
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onContainerMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onContainerMouseUp);
			
			var adjust:Number = _size / 1000; 
			
			var matrix:Matrix = new Matrix();
			matrix.identity();
			matrix.scale( adjust , adjust );
			
			for ( var i:uint = 0; i < _num; i ++ )
			{
				var sp:Sprite = new Sprite();
				drawGradationCircle( sp.graphics , matrix );
				sp.x = 135 + 150 * int( i % 2 );
				sp.y = 135 + 150 * int( i / 2 );
				
				sp.addEventListener(MouseEvent.MOUSE_DOWN, onSpMouseDown);
				sp.addEventListener(MouseEvent.MOUSE_UP, onSpMouseUp);
				
				_container.addChild( sp );
				_objAry.push( sp );
			}
			addChild( new Bitmap( _canvas ) );
			
			for ( var j:int = 0; j < 256; j ++ )
			{
				if ( j < 200 ) _alphaArray.push( 0 );
				else _alphaArray.push( 0xFF000000 );
			}
			
			addEventListener( Event.ENTER_FRAME , enterFrameHandler );
		}
		
		private function onSpMouseDown(e:MouseEvent):void
		{
			(e.currentTarget as Sprite).startDrag();
		}
		
		private function onSpMouseUp(e:MouseEvent):void
		{
			(e.currentTarget as Sprite).stopDrag();
		}
		
		private function onContainerMouseDown(e:MouseEvent):void
		{
			_moving = true;
		}
		
		private function onContainerMouseUp(e:MouseEvent):void
		{
			_moving = false;
		}
		
		private function enterFrameHandler( e:Event ):void
		{
			/*_objAry[ _num - 1 ].x = mouseX;
			_objAry[ _num - 1 ].y = mouseY;*/
			_bmpData.fillRect( _rect , 0x000000 );
			_bmpData.draw( _container );
			_bmpData.paletteMap( _bmpData , _rect , _rect.topLeft , null , null , null , _alphaArray );
			
			_canvas.fillRect( _canvas.rect, 0xffffff);
			//_canvas.colorTransform( _rect , new ColorTransform( 1 , 1 , 1 , 0.95 ) );
			//_canvas.applyFilter( _canvas , _canvas.rect , new Point( 0 , 0 ) , new BlurFilter( 16 , 16 ) );
			_canvas.draw( _bmpData );
			//_canvas.applyFilter( _canvas , _canvas.rect , new Point( 0 , 0 ) , new BlurFilter( 16 , 16 ) );
			//removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			moveBalls();
		}
		
		private function moveBalls():void
		{
			if (_moving) {
				for each ( var s:Sprite in _objAry ) {
					s.x += (int(Math.random() * 2) % 2) ? Math.random() * 5 : Math.random() * -5;
					s.y += (int(Math.random() * 2) % 2) ? Math.random() * 5 : Math.random() * -5;
				}
			}
		}
		
		private function drawGradationCircle( g:Graphics , m:Matrix ):void
		{
			g.beginGradientFill( "radial", [ 0 , 0], [ 1 , 0 ] ,  [ 110 , 255 ] , m );
			g.drawCircle( 0 , 0 , _size );
			g.endFill();
		}
	}
}