/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bpwR
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	
	[SWF(width = 400, height = 400, backgroundColor = 0x808080, frameRate = 60)]
    public class LissajousCurve extends Sprite {
		private var _output:TextField;
		private var _bmpdata:BitmapData;
		private var _filter:BlurFilter;
		private var _cTransform:ColorTransform;
		
        public function LissajousCurve() {
			_output = new TextField();
			_output.width = 100;
			_output.height = 32;
			_output.background = true;
			
			_bmpdata = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            addChild(new Bitmap(_bmpdata));
			_filter = new BlurFilter(4, 4);
			_cTransform = new ColorTransform(0.95, 0.95, 0.96);
			
			stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			addChild(_output);
        }
		
		private var _count:Number = 0;
		private function enterFrameHandler(e:Event):void
		{
			_bmpdata.applyFilter(_bmpdata, _bmpdata.rect, _bmpdata.rect.topLeft, _filter);
			_bmpdata.colorTransform(_bmpdata.rect, _cTransform);
			drawLissajousCurve(_bmpdata, 3 + Math.sin(_count), 3, 360 * 4);
			_output.text = "a : " + (3 + Math.sin(_count)) + "\nb : " + 3;
			_count += Math.PI / 180 / 3;
		}
		
		// リサージュ曲線を描画する
		// bmpdata:描画するBitmapData, a,b:関数の係数, count:角度の最大値（単位:度）
		private function drawLissajousCurve(bmpdata:BitmapData, a:Number, b:Number, count:int = 10000):void
		{
			const scale:int = stage.stageWidth / 3;
			bmpdata.lock();
			if (a > b) {
				a = a / b;
				b = 1;
			}else {
				b = b / a;
				a = 1;
			}
			var x:int, y:int;
			var sx:int = Math.floor(Math.cos(0) * scale);
			var sy:int = Math.floor(Math.sin(0) * scale);
			var i:Number = 0, times:int = 0;
			while (!(x == sx && y == sy) && times < count) {
				x = Math.floor(Math.cos(a * i) * scale) + stage.stageWidth / 2;
				y = Math.floor(Math.sin(b * i) * scale) + stage.stageHeight / 2;
				bmpdata.setPixel(x, y, 0xFFFFFF);
				i += Math.PI / 180;
				times++;
			}
			bmpdata.unlock();
		}
    }
}