/**
 * Copyright kt3k ( http://wonderfl.net/user/kt3k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bpQ0
 */

// forked from kt3k's forked from: Blur Circle
// forked from ll_koba_ll's Blur Circle

package
{
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.net.URLStream;
    import flash.media.Sound;
    import flash.media.Video;
    import flash.net.NetStream;
    import flash.net.NetConnection;    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;

    [SWF(frameRate="60", backgroundColor="#000000")]

    public class Main extends Sprite
    {
        private var time:Number;
        private var song_ph0:Number = 800;
        private var song_ph1:Number = 1800;
        private var song_mid:Number = 3000;
        private var song_end:Number = 5000;
        private var song_ph2:Number = 6000;
        
        private var blur:BlurFilter;
        private var bigBlur:BlurFilter;
        private var bg:Sprite;
        private var container:Sprite;
        private var source:Sprite;
        private var bmpd:BitmapData;
        
        private var nc:NetConnection;
        private var ns:NetStream;
        private var video:Video;
        
        private var snd:Sound;
        private var soundChannel:SoundChannel = new SoundChannel;

        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP;
            stage.quality = StageQuality.LOW;        
            init();
            initSound();
            addEventListener(Event.ENTER_FRAME, update);
        }

        private function init():void
        {
            time = 1;
            blur = new BlurFilter(3,3);
            bigBlur = new BlurFilter(40, 40);           
            bmpd = new BitmapData(500, 500, true, 0x00FFFFFF);
            container = new Sprite();
            source = new Sprite();
            source.scaleX = 0;
            source.scaleY = 0;
            addChild(new Bitmap(bmpd));
            container.addChild(source);
            with(source.graphics)
            {
                beginFill(0x00bbff);
                drawCircle(0,0,20);
                endFill();
            }
        }
        
        private function initSound():void
        {
            snd = new Sound;
            snd.load(new URLRequest("http://penv.org/mikumiku.mp3"));
            soundChannel = snd.play(0,1);
        }


        private function update(e:Event = null):void
        {
            bmpd.draw(container, null, null, BlendMode.ADD);
            bmpd.applyFilter(bmpd, bmpd.rect, new Point(), blur);
            if (Math.random() < 0.05){
                bmpd.applyFilter(bmpd, bmpd.rect, new Point(), bigBlur);
            }
            
            
            if (song_mid < time && time < song_mid + 0x100)
            {
                if (this.opaqueBackground < 0xffffff)
                {
                    this.opaqueBackground += 0x010101;
                }
            }
            
            if (song_end < time)
            {
                if (this.opaqueBackground > 0x00ffff)
                {
                    this.opaqueBackground += 0xff0000;
                }
                else if (this.opaqueBackground != 0x00bbff)
                {
                    this.opaqueBackground += 0x00ff00;
                }
            }

            time += 1;

            var x:Number = 500;
            var y:Number = 500;
            x = Math.round(x/50);
            y = Math.round(y/50);

            var scale:Number = 0.6 + Math.random() * 0.3;
            source.scaleX = scale;
            source.scaleY = scale;
       
            var ofs:Number = 0;
            if (time < song_ph0)
            {
                x = x/2;
                y = y/2;
                ofs = x/4 * 50 + 35;

                if(Math.random() > 0.1)
                {
                    source.scaleX = 0;
                    source.scaleY = 0 ;
                }
             }
            
            if (song_ph0 < time && time < song_ph1)
            {
                if(Math.random() > 0.4)
                {
                    source.scaleX = 0;
                    source.scaleY = 0 ;
                }
            }
            if (song_ph2 < time)
            {
                source.scaleX = 0;
                source.scaleY = 0;
            }
            
            source.x = ofs + dice(x) * 50 + 15;
            source.y = ofs + dice(y) * 50 + 15;
        }
        
        public function uniform(x:Number, y:Number):Number
        {
            if(x - y > 0)
            {
                var w:Number = y;
                y = x;
                x = w;
            }
            return x + Math.random()*(y-x)
        }

        public function dice(n:Number = 6):Number
        {
            return Math.round(Math.random() * n);
        }
    }
}