/**
 * Copyright yo0_0oy ( http://wonderfl.net/user/yo0_0oy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bpJ0
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
        
        private static const NUM_ITEMS:uint = 30;
        private static const ITEM_RADIUS:uint = 40;
        private static const Z_DIST_BETWEEN_ITEMS:uint = 150;
        private static const ITEM_DIST_FROM_CENTER:uint = 300;
        private static const ANGLE_BETWEEN_ITEMS:Number = 30*(Math.PI/180);
        
        private var _menu:Sprite;
        private var _menuItems:Vector.<Sprite>;
        
        public function FlashTest() {
            // write as3 code here..
            _menu = new Sprite();
            _menuItems = new Vector.<Sprite>();
            for(var i:uint=0;i<NUM_ITEMS; i++){
                createMenuItem(i);
            }
            addChild(_menu);
            navigateToItem(_menuItems[0]);
            stage.addEventListener(MouseEvent.CLICK, onStageClick);
        }
        
        private function createMenuItem(index:uint):void{
            var menuItem:Sprite = new Sprite();
            menuItem.graphics.beginFill(Math.random()*0xffffff);
            menuItem.graphics.drawCircle(0,0,ITEM_RADIUS);
            menuItem.graphics.endFill();
            menuItem.x = Math.cos(ANGLE_BETWEEN_ITEMS*index)*ITEM_DIST_FROM_CENTER;
            menuItem.y = Math.sin(ANGLE_BETWEEN_ITEMS*index)*ITEM_DIST_FROM_CENTER;
            menuItem.z = index*Z_DIST_BETWEEN_ITEMS;
            menuItem.addEventListener(MouseEvent.CLICK, onMenuItemClick);
            _menuItems.push(menuItem);
            _menu.addChildAt(menuItem,0);            
        }
        
        private function navigateToItem(menuItem:Sprite):void{
            _menu.x = stage.stageWidth/2-menuItem.x;
            _menu.y = stage.stageHeight/2-menuItem.y;
            _menu.z = -menuItem.z;
        }
        private function onMenuItemClick(event:MouseEvent):void{
            navigateToItem(event.target as Sprite);
            event.stopPropagation();
        }
        private function onStageClick(event:MouseEvent):void{
            navigateToItem(_menuItems[0]);
        }
        
    }
}