/**
 * Copyright daniwell ( http://wonderfl.net/user/daniwell )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bogE
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	[SWF(backgroundColor = "0x333333", frameRate = "30", width = "465", height = "465")]
	public class Samegame extends Sprite
	{
		private const NUM_W:uint = 40;	// ヨコ 個数
		private const NUM_H:uint = 40;	// タテ 個数
		
		// ブロックの色
		private const COLOR :Vector.<uint> = Vector.<uint>([0xff5500, 0xffcc00, 0x0099ff]);
		private var colorNums :uint = COLOR.length;
		
		private var map:Vector.<Vector.<Block>>;
		
		private var bmd:BitmapData;
		private var bmp:Bitmap;
		
		private var que:Vector.<Block> = new Vector.<Block>();
		private var tmpH:Vector.<int> = new Vector.<int>(NUM_W);
		
		private var mapSp :Sprite;
		private var status:Status;
		
		public function Samegame() 
		{
			graphics.beginFill(0x333333); graphics.drawRect(0,0,465,465);
			
			bmd = new BitmapData(NUM_W, NUM_H, false, 0);
			bmp = new Bitmap(bmd);
			bmp.scaleX = bmp.scaleY = 10;
			
			bmd.lock();
			
			map = new Vector.<Vector.<Block>>(NUM_H);
			for (var i :int = 0; i < NUM_H; i ++)
			{
				map[i] = new Vector.<Block>(NUM_W);
				
				for (var j :int = 0; j < NUM_W; j ++)
				{
					var block :Block = new Block();
					block.id = int(Math.random() * colorNums);
					block.x  = j;
					block.y  = i;
					map[i][j] = block;
					
					bmd.setPixel(j, i, COLOR[block.id]);
				}
			}
			bmd.unlock();
			
			mapSp = new Sprite();
			mapSp.addChild(bmp);
			mapSp.x = int((465 - NUM_W * 10) / 2);
			mapSp.y = 15;
			mapSp.buttonMode = true;
			mapSp.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			
			addChild(mapSp);
			
			status = new Status();
			status.addScore(0);
			status.addPanel(0);
			status.x = mapSp.x;
			status.y = mapSp.y + mapSp.height + 10;
			
			addChild(status);
		}
		
		private function mouseDownHandler(e:Event):void
		{
			if ( search(int(mapSp.mouseX / 10), int(mapSp.mouseY / 10)) )
			{
				fall(tmpH);
				slide();
				render();
			}
		}
		
		private function render() :void
		{
			bmd.lock();
			bmd.fillRect(bmd.rect, 0x333333);
			for (var i :int = 0; i < NUM_W; i ++)
			{
				for (var j :int = NUM_H - 1; 0 <= j; j --)
				{
					if (map[j][i].id == -1) break;
					bmd.setPixel(i, j, COLOR[map[j][i].id]);
				}
			}
			bmd.unlock();
		}
		
		private function fall (tmpH:Vector.<int>) :void
		{
			for (var i :int = 0; i < NUM_W; i ++)
			{
				if (tmpH[i] == -1) continue;
				
				for (var j :int = tmpH[i] - 1; 0 <= j; j --)
				{
					if (map[j][i].id == -1) continue;
					
					map[tmpH[i]][i].id = map[j][i].id;
					map[j][i].id = -1;
					tmpH[i]--;
				}
			}
		}
		private function slide ():void
		{
			for (var k:int = NUM_W - 2; 0 <= k; k --)
			{
				if (!(map[NUM_H - 1][k].id == -1 && map[NUM_H - 1][k + 1].id != -1)) continue;
				
				for (var i :int = k; i < NUM_W - 1; i ++)
				{
					for (var j :int = 0; j < NUM_H; j ++)
					{
						map[j][i].id = map[j][i + 1].id;
						map[j][i + 1].id = -1;
					}
				}
			}
		}
		
		private function search (nx:int, ny:int):Boolean
		{
			if (map[ny][nx].id == -1) return false;
			
			searchLoop(map[ny][nx].id, nx, ny);
			
			if (2 <= que.length)
			{
				status.addScore(Math.pow(que.length-1,2) * 10);
				status.addPanel(que.length);
				
				for (var i:int = 0; i < NUM_W; i ++) tmpH[i] = -1;
				
				while (que.length != 0)
				{
					var b:Block = que.pop();
					b.flag = false;
					b.id = -1;
					
					tmpH[b.x] = Math.max(tmpH[b.x], b.y);
				}
				return true;
			}
			que.pop().flag = false;
			return false;
		}
		
		private function searchLoop (n:int, nx:int, ny:int):void
		{
			if (map[ny][nx].flag || n != map[ny][nx].id) return;
			
			map[ny][nx].flag = true;
			que.push(map[ny][nx]);
			
			if (0 <= nx - 1)	searchLoop(n, nx - 1, ny);
			if (nx + 1 < NUM_W)	searchLoop(n, nx + 1, ny);
			if (0 <= ny - 1)	searchLoop(n, nx, ny - 1);
			if (ny + 1 < NUM_H)	searchLoop(n, nx, ny + 1);
		}
	}
}
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

class Status extends Sprite
{
	private var _score      :uint = 0;
	private var _panel      :uint = 0;
	private var _tfMaxPanel :TextField;
	private var _tfScore    :TextField;
	
	public function Status()
	{
		_tfMaxPanel = createTextField();
		_tfScore    = createTextField();
		_tfMaxPanel.y = 13;
		
		addChild(_tfMaxPanel);
		addChild(_tfScore);
	}
	public function addScore(n:uint):void
	{
		_score += n;
		_tfScore.text = "score: " + _score;
	}
	public function addPanel(n:uint):void
	{
		_panel += n;
		_tfMaxPanel.text = "panel: " + _panel;
	}
	private function createTextField():TextField
	{
		var format :TextFormat = new TextFormat("_等幅", 10, 0xffffff);
		format.letterSpacing = 1;
		
		var tf :TextField = new TextField();
		tf.autoSize = "left";
		tf.defaultTextFormat = format;
		
		return tf;
	}
}
class Block
{
	public var id  :int = -1;
	public var flag:Boolean = false;
	public var x   :int;
	public var y   :int;
}