/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bmFE
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;

	public class SpringDocument1 extends Sprite {
		private var _ball:Ball;
		private var _spring:Number = .1;
		private var _friction:Number = .9;
		
		private var _targetX:Number;
		private var _targetY:Number;
		
		private var _velocityX:Number = 0;
		private var _velocityY:Number = 0;
		
		public function SpringDocument1() {
			init();
		}

		private function init():void {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.x = tex.y = 10;
			tex.multiline = true;
			
			tex.text = 'ステージをクリックすると、ボールがバネ運動を開始します。\nその後はマウスにあわせてバネ運動を繰り返します。';
			
			// ステージ上にスプライトを配置します。
			addChild(_ball = new Ball);
			_ball.x = stage.stageWidth / 2;
			_ball.y = stage.stageHeight / 2;
			stage.addEventListener(MouseEvent.CLICK, clickHandler);
		}
		
		private function clickHandler($event:MouseEvent):void{
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function enterFrameHandler($event:Event):void{
			if(Math.abs(mouseX - _ball.x) < .5 && Math.abs(mouseY - _ball.y) < .5){
				// 運動停止と看做してよい閾値に達している場合は何もせずに終了
				return;
			}

			_targetX = mouseX;
			_targetY = mouseY;
			
			_velocityX += (_targetX - _ball.x) * _spring;
			_velocityX *= _friction;
			
			_velocityY += (_targetY - _ball.y) * _spring;
			_velocityY *= _friction;
			
			_ball.x += _velocityX;
			_ball.y += _velocityY;
			
			graphics.clear();
			graphics.lineStyle(0);
			graphics.moveTo(mouseX, mouseY);
			graphics.lineTo(_ball.x, _ball.y);
		}
	}
}

import flash.display.Sprite;
class Ball extends Sprite {
	private var _radius:Number = 10;
	function Ball(){
		init();
	}
	
	private function init():void{
		graphics.beginFill(0x000000);
		graphics.lineStyle(0, 0x999999);
		graphics.drawCircle(0, 0, _radius);
	}
	
	public function get radius():Number{
		return _radius;
	}
}