/**
 * Copyright komatsu ( http://wonderfl.net/user/komatsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/blXM
 */

package {
	import flash.filters.BlurFilter;
	import flash.filters.DisplacementMapFilter;
	import flash.text.TextFormat;
	import flash.text.TextField;
    import flash.display.*;
    import flash.geom.*;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
    import flash.filters.BitmapFilterQuality;
    
    [SWF(backgroundColor="#000000", frameRate=30)]
    public class DispMapTest extends Sprite {
    		private const STW:uint = stage.stageWidth;
    		private const STH:uint = stage.stageHeight;
    		private var map:BitmapData;
    		private var bm:Bitmap;
    		private var offset:Array = new Array();
    		private var noiseSeed:Number = 0;
    		private var channels:uint = BitmapDataChannel.RED | BitmapDataChannel.BLUE | BitmapDataChannel.GREEN;
		private var blur:BlurFilter;
		private var point1:Point = new Point(0, 0);
		private var point2:Point = new Point(0, 0);
		private var perlinOffset:Array = [point1, point2];
		
        public function DispMapTest() {
             map= new BitmapData(STW, 100, false, 0x00CCCCCC);
			bm = new Bitmap(map);
			addChild(bm);
			
			
			//テキスト用スプライト
			var tf:TextField = new TextField();
            tf.text = "Wonderfl!!";
            tf.width = STW;
            tf.y = (STH - tf.height)/2;
            tf.selectable = false;
            
            var fmt:TextFormat = new TextFormat();
            fmt.size = 80;
            fmt.align = "center";
            fmt.color = 0xFF3333;
            
            tf.setTextFormat(fmt)
            addChild(tf);
            
            var pnt:Point = new Point(0,0);

            
			var ch:uint = BitmapDataChannel.RED;
			var filter:DisplacementMapFilter = new DisplacementMapFilter(map,pnt,ch,ch);
			tf.filters = new Array(filter);
			filter.scaleX =10;
			filter.scaleY =10;
			blur = new BlurFilter();
			blur.blurX = 0;
			blur.blurY = 20;
			blur.quality = BitmapFilterQuality.MEDIUM;

			var filterTimer:Timer = new Timer(40);
			filterTimer.addEventListener(TimerEvent.TIMER , filterTimerFunc);
			function filterTimerFunc(evtObj:TimerEvent):void{
				perlinOffset[0].x -= 20;
				perlinOffset[1].x += 20;
				perlinOffset[0].y += 20;
				perlinOffset[1].y += 20;
				map.perlinNoise(100,100, 6, 1, true, true, channels, true, perlinOffset);
				tf.filters = new Array(filter,blur);
				
			}
			filterTimer.start();
        }
    }
}