/**
 * Copyright _perfect ( http://wonderfl.net/user/_perfect )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/blMv
 */

// forked from aaharu's Away3D Material
/*
マテリアルいろいろ。
Sphereをクリックするとマテリアルが変わります。
画像のロードが面倒なのでBitmapMaterialなどはなし。

ColorMaterial
↓
ShadingColorMaterial
↓
PhongColorMaterial
↓
WireColorMaterial
↓
WireframeMaterial
の順で変わります。
*/

package {
    import away3d.cameras.HoverCamera3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.events.MouseEvent3D;
    import away3d.lights.DirectionalLight3D;
    import away3d.materials.ColorMaterial;
    import away3d.materials.PhongColorMaterial;
    import away3d.materials.ShadingColorMaterial;
    import away3d.materials.WireColorMaterial;
    import away3d.materials.WireframeMaterial;
    import away3d.primitives.Sphere;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite {
        private var scene:Scene3D;
        private var camera:HoverCamera3D;
        private var view:View3D;
        // ライト
        private var light:DirectionalLight3D;
        private var isMouseDown:Boolean = false;
        // カメラ移動用変数
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        
        private var sphere:Sphere;
        
        /**
         * constructor
         */
        public function Main() {
            if(stage) {
                initEngine();
            } else {
                addEventListener(Event.ADDED_TO_STAGE, onAdded);
            }
        }
        
        private function onAdded(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, onAdded);
            initEngine();
        }
        
        private function initEngine():void {
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(Event.RESIZE, onResize);
            
            scene = new Scene3D();
            // カメラ初期設定
            camera = new HoverCamera3D();
            camera.zoom = 2;
            camera.focus = 200;
            camera.distance = 150;
            camera.mintiltangle = -90;
            camera.targetpanangle = camera.panangle = -10;
            camera.targettiltangle = camera.tiltangle = 20;
            
            view = new View3D({camera: camera, scene: scene, stats: true, x: stage.stageWidth / 2, y: stage.stageHeight / 2});
            addChild(view);
            LoadModel();
            initLights();
        }
        
        private function LoadModel():void {
            sphere = new Sphere();
            var color:uint = 0xAAAAAA;
            material.push(new ColorMaterial(color));
            material.push(new ShadingColorMaterial(color));
            material.push(new PhongColorMaterial(color));
            material.push(new WireColorMaterial(color));
            material.push(new WireframeMaterial(color));
            sphere.material = material[i];
            sphere.addOnMouseDown(onModelMouseDown);
            scene.addChild(sphere);
        }
        
        private var material:Array = [];
        private var i:uint = 0;
        private function onModelMouseDown(e:MouseEvent3D):void {
            i++;
            if(i >= material.length) {
                i = 0;
            }
            sphere.material = material[i];
        }
        
        private function initLights():void {
            light = new DirectionalLight3D({color:0xFFFFFF, ambient:0.25, diffuse:0.75, specular:0.9, x:0, y:1000, z:1000});
            scene.addChild(light);
        }
        
        private function onEnterFrame(e:Event):void {
            if(isMouseDown) {
                camera.targetpanangle = 0.35 * (stage.mouseX - lastMouseX) + lastPanAngle;
                camera.targettiltangle = 0.35 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            camera.hover();
            view.render();
        }
        
        private function onResize(event:Event = null):void {
            view.x = stage.stageWidth / 2;
            view.y = stage.stageHeight / 2;
        }
        
        private function onMouseDown(e:MouseEvent):void {
            lastPanAngle = camera.targetpanangle;
            lastTiltAngle = camera.targettiltangle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            isMouseDown = true;
        }
        
        private function onMouseUp(e:MouseEvent):void {
            isMouseDown = false;
        }
    }
}