/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bl7e
 */

// forked from osamX's Loaderをドラッグ＆ドロップ
package 
{
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.net.URLRequest;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Bounce;
	import org.libspark.betweenas3.easing.Cubic;
	
	public class Main extends Sprite 
	{
		private const homePoint:Point = new Point(465 / 2 - 64, 465 - 128);	//loaderの初期位置（アニメーション用）
		
		private var loader:Loader;					//主役
		private var sprite:Sprite;
		private var stageMouseDownPos:Point;		//stage上のマウスがダウンされた位置（アニメーション用）
		
		public function Main():void {
			loadImage();
		}
		
		//Loaderで画像ロード・表示
		private function loadImage():void {
			sprite = new Sprite();
			addChild(sprite);
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void {
				loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, arguments.callee);
				sprite.addChild(loader);
				addEventListeners();
			}); 
			loader.load(new URLRequest("http://a3.twimg.com/profile_images/1199283975/twicon11w_reasonably_small.png"));//twitterのアイコン (128*128)
			sprite.x = homePoint.x;
			sprite.y = homePoint.y;
		}
		
		//イベントリスナー追加
		private function addEventListeners():void {
			sprite.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);	//　loaderにMOUSE_DOWNのイベントを拾わせる
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);			//　stageにMOUSE_UPのイベントを拾わせる
		}
		
		//MOUSE_DOWN
		private function onMouseDown(e:MouseEvent):void {
			sprite.startDrag();
			stageMouseDownPos = new Point(stage.mouseX, stage.mouseY);	//アニメーション用
		}
		
		//MOUSE_UP
		private function onMouseUp(e:MouseEvent):void {
			sprite.stopDrag();
			backToHome();
		}
		
		//アニメーション
		private function backToHome():void {
			if (stageMouseDownPos.y > stage.mouseY) {
				BetweenAS3.parallel(
					BetweenAS3.tween(sprite, { x:homePoint.x }, null, 0.5 , Cubic.easeOut),
					BetweenAS3.tween(sprite, { y:homePoint.y }, null, 0.5, Bounce.easeOut)
				).play();
			}
			else {
				BetweenAS3.tween(sprite, { x:homePoint.x, y:homePoint.y }, null, 0.5 , Cubic.easeOut).play();
			}
		}
	}
	
}