/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bl5J
 */

// forked from tepe's forked from: forked from: forked from: forked from: forked from: forked from: getToken
// forked from tepe's forked from: forked from: forked from: forked from: forked from: getToken
// forked from tepe's forked from: forked from: forked from: forked from: getToken
package {
    import flash.media.Video;
    //import flash.utils.Dictionary;
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.net.*;
    import flash.utils.*;
    import net.hires.debug.Stats;
    


    public class FlashTest extends Sprite {
        private var t1:TextField = new TextField();//原文
        private var t2:TextField = new TextField();
        private var so : SharedObject;
        public function FlashTest() {
            
            // write as3 code here..
            init();
            //FPS計測    
            addChild( new Stats() );
            //Wonderfl.capture(stage);
            onChange(null);
            
        }
        
 
        private function init():void{
            //原文テキスト入力ボックス
            t1.border = true;
            t1.width = 230;
            t1.height = 360;
            t1.y=100;
            t1.type = "input";
            t1.multiline = true;
            so = SharedObject.getLocal("data");
            if(so){ 
                if(so.data.text != null){
                    t1.text = so.data.text;
                }
                else{    
                    t1.text "";
                    so.data.text = t1.text;
                }
            }
            addChild(t1);
            t1.addEventListener(Event.CHANGE,onChange);
            t2.type ="input";
            t2.x = 230;
            t2.width=230;
            t2.height=460;
            t2.wordWrap =true;
            t2.multiline=true;
            t2.border = true;
            addChild(t2);            
            
        }
        
        

        private var tk:Tokenizer;
        private function onChange(e:Event=null):void{
            
            
            tk = new Tokenizer();
            tk.addEventListener(Event.COMPLETE,onComplete);
            //進捗率の表示
            tk.addEventListener(ProgressEvent.PROGRESS,function(e:ProgressEvent):void{
                t2.text = Math.round(100*e.bytesLoaded/e.bytesTotal).toString()+"%";
            });

            tk.createToken(t1.text);
            //var cnt:int=0;
            t2.text = "";
        }
        
        //ステップリストとスコープリストの生成
        private function onComplete(e:Event):void{
            t2.text = "onComplete"; 

            var bStack:Vector.<Block> = new Vector.<Block>;
            //var parent:Block;
            //var bList:Vector.<Block> = new Vector.<Block>;
            //グローバルスコープ
            var root:Block = new Block();
            root.setStart(tk.getToken());
            root.setEnd(tk.getEof());
            var bufStr:String = new String();
            var scopeStack:Vector.<Token> = new Vector.<Token>;
            var i:int;
            var cToken:Token = tk.getToken();
            var st:Token;
            while(cToken!=null){//無限ループ注意
                //ブロック単位にグループ化
                if(cToken.type == Token.MARK){
                    var s:String = cToken.text;
                    if(s == ";"){  
                        bufStr+=";"
                    }
                    else if(s=="{"){ //スコープ開始 
                        for(i=0;i<scopeStack.length;i++)bufStr+=" ";
                        scopeStack.push(cToken);
                        bufStr+="\n";
                        for(i=0;i<scopeStack.length;i++)bufStr+=" ";
                        bufStr+="{";
                    }
                    else if(s=="}"){//スコープ終了
                        st = scopeStack.pop();
                        if(st.text!="{")bufStr+="\nErr\n"//break;
                        for(i=0;i<scopeStack.length;i++)bufStr+=" ";
                        bufStr+="}\n";
                        for(i=0;i<scopeStack.length;i++)bufStr+=" ";
                    }
                    else if(s=="("){
                        scopeStack.push(cToken);
                        bufStr+="("
                    }
                    else if(s== ")"){ 
                        st = scopeStack.pop();
                        if(st.text!="(")bufStr+="\nErr\n"//break;
                        bufStr+=")";
                    }
                    else if(s=="["){
                        scopeStack.push(cToken);
                        bufStr+="[";
                    }
                    else if(s=="]"){
                        st = scopeStack.pop();
                        if(st.text!="[")bufStr+="\nErr\n"//break;
                        bufStr+="]";
                    }                  
                }
                cToken = cToken.next;
                //cnt++;
            }
            
            if(0<scopeStack.length){ 
                
                bufStr+="\nError "+scopeStack.length+"\n";
                for(i=0;i<scopeStack.length;i++){
                    bufStr+=scopeStack[i].text+"\n";
                }
            }
            //var i:int;
            
            //bufStr += str;
            //t2.text = str;
            //return;



            t2.text = bufStr;
            //so.data.text = t1.text;
            
        }//function
    }//class
}//package
import flash.events.ProgressEvent;



//トークンオブジェクト
class Token{
    private static var idCnt:int;
    private var tokenId:int;
    private var _text:String;//文字列
    public var type:int;//タイプ
    public var line:int;//行番号
    //public var lineNum:int;//属するプロセスライン
    
    //トークンの並びを保持する
    public var next:Token;
    public var prev:Token;
    public static const ERROR:int = -1;//エラー
    public static const SPACE:int = 0;//スペース
    public static const COMMENT:int = 1;//コメント 
    public static const NUMBER:int = 2;//数値
    public static const WORD:int = 3;//識別子
    public static const TEXT:int = 4;//文字列
    public static const MARK:int = 5;//記号
    public static const OTHER:int = 6;//その他（マルチバイトの文字列)
    public static const SCOPE:int = 7;//スコープの置き換え
    public static const EOF:int = 8;//EOF
    public static const REGEXP:int = 9;//正規表現
    
    public function Token(){
        idCnt++;
        tokenId = idCnt;
    }
    public function get id():int{
        return tokenId;
    }
    public function set text(str:String):void{
        _text = new String();
        _text += str;
        
    }
    public function get text():String{
        return _text;
    }
 
}

//トークンの移動操作をする
class TokenPoint{
    private var _current:Token;
    private var _start:Token;
    private var _end:Token;
    public function TokenPoint(t:Token,start:Token,end:Token){
        _current = t;
        _start = start;
        _end = end;
        
    }
    public function get getPos():Token{
        return _current;
    }


    public function movNext():int{//移動量を返す
        if(_current.next==null)return 0;
        _current = _current.next;
        return 1;
    }
    public function movPrev():int{
        if(_current.prev==null)return 0;
        _current = _current.prev;
        return -1;
    }
    //指定されたタイプの位置まで移動
    public function movNextType(type:int):int{ 
        var cnt:int=0;
        var t:Token = _current;
        while(t.type!=type){ 
            if(t==null)return 0;
            if(t==_end)return 0;
            t=t.next;
            cnt++;
        }
        _current = t;
        return cnt;
    }
    
    public function movPrevType(type:int):int{
        var cnt:int=0;
        var t:Token = _current;
        while(t.type!=type){
            if(t==null)return 0;
            if(t==_start)return 0;
            t=t.prev;
            cnt--;
        }
        _current = t;
        return cnt;

    }
    //指定された文字列の位置まで移動
    public function movNextText(text:String):int{
        var cnt:int=0;
        var t:Token = _current;
        while(t.text != text){
            if(t==null)return 0;
            if(t==_end)return 0;
            t=t.next;
            cnt++;
        }
        _current = t;
        return cnt;

    }
    
    public function movPrevText(text:String):int{
        var cnt:int=0;
        var t:Token = _current;
        while(t.text != text){
            if(t==null)return 0;
            if(t==_start)return 0;
            t=t.prev;
            cnt--;
        }
        _current = t;
        return cnt;
    }
}


class Block{ 
    private static var idCnt:int;
    private var _id:int;
    private var _name:String;
    private var _text:String;
    public var list:Vector.<Block>;
    
    private var _next:Block;
    private var _prev:Block;
    private var _parent:Block;
    private var _child:Block;
    
    private var _startToken:Token;
    private var _endToken:Token;
    public function Block(){
        idCnt++;
        _id=idCnt;
    }
    //ID
    public function get id():int{
        return _id;
    }
    //要素数
    public function get length():int{
        if(list==null)return 0;
        return list.length;
    }
    public function add(block:Block):void{
        if(list == null)list = new Vector.<Block>;
        list.push(block);
        var len:int = list.length;
        if(1<len){ 
            list[len-1].prev = list[len-2];
            list[len-2].next = list[len-1];
        }
        _child = list[0];
        
    }
    
    public function get start():Token{
        return _startToken;
    }
    public function get end():Token{
        return _endToken;
    }


    public function get next():Block{//次の要素
        return _next;
    }
    public function get prev():Block{//前の要素
        return _prev;
    }
    public function get parent():Block{//上の階層
        return _parent;
    }
    public function get child():Block{//下の階層の先頭
        return _child;
    }
    
    public function set next(b:Block):void{ 
        if(_next == b)return;
        _next=b;
        if(_next==null)return;
        if(_next.prev.id!=this.id)_next.prev = this;
    }
    public function set prev(b:Block):void{ 
        _prev=b;
    }
    public function set parent(b:Block):void{
        _parent=b;
    }
    public function set child(b:Block):void{
        _child=b;
    }
    
    public function setStart(start:Token):int{
        _startToken = start;
        if(_startToken!=null && _endToken!=null){ 
            //setArea(_startToken,_endToken);
            return 0;
        }
        return -1;
    }
    public function setEnd(end:Token):int{
        _endToken = end;
        if(_startToken!=null && _endToken!=null){ 
            //setArea(_startToken,_endToken);
            return 0;
        }
        return -1;
    }

    
//-------------------------------------------------------------
    //テキスト取得
    public function get text():String{ 
        if(_text!=null)return _text;
        _text = new String();
        var t:Token = _startToken;
        while(t.next != null){
            _text += t.text;
            if(t.id == _endToken.id)break;
            t = t.next;
        }
        return _text;
    }
  

}




//Thread==========================================================================
import flash.utils.*;
import flash.events.*;
    
class Thread extends Timer{ 
    static public var SPAN:Number = 1000/30; 
    static public var RATE:Number = 0.5;
    public var end:Boolean = false, currentLoop:Loop = null;
    
    static private var NUM:int = 0;
    private var _limit:Number = 5, _time:int = 0, _added:Boolean, currentLoops:Vector.<Loop>, loops:Vector.<Loop> = new Vector.<Loop>();
    
    function Thread(){
        super(SPAN); start(); NUM++;
        addEventListener( "timer", onFrame  );
    }    
    public function loop( func:Function, onComplete:Function = null):void{
        var loop:Loop = new Loop( func, currentLoop );     
        if( currentLoop == null ){ loops.push( loop );
        }else{ currentLoop.loops.push( loop ); _added = true }
        if( onComplete != null ){
            loop = new Loop( onComplete, currentLoop );   
            if( currentLoop == null ){ loops.push( loop );
            }else{ currentLoop.loops.push( loop ); }
        }
    }    
    public function remove():void{
        NUM--; stop(); end = true;
        removeEventListener( "timer", onFrame  );
    }    
    private function onFrame(e:Event):void{
        _time = getTimer(); _limit = (SPAN * RATE) / NUM;
        all: while(true){
            if( currentLoop == null ){
                currentLoops = loops;
                if( loops.length == 0 ){ remove(); break; }
                while( currentLoops[0].loops.length != 0 ){ currentLoops = currentLoops[0].loops;  }
                currentLoop = currentLoops[0];
            }
            do{
                if( _limit < (getTimer() - _time)){ break all; }
                if( _added ){ _added = false; currentLoop = null; continue all;  }
            }while( currentLoop.func() )
            currentLoop = null;
            currentLoops.reverse(); currentLoops.pop(); currentLoops.reverse();
        }
    }
}
class Loop extends Object{
    public var func:Function, name:String, parent:Loop, loops:Vector.<Loop> = new Vector.<Loop>();
    function Loop( func:Function, parent:Loop = null, name:String = "" ){  
        this.func = func; this.parent = parent;
    }
}
//=======================================================================================



//////////////////////////////////////////////////////////////////////////
//  トークン列取得
//////////////////////////////////////////////////////////////////////////



//テキストからトークンを抽出する
class Tokenizer extends Thread{
    private var tokenList:Vector.<Token>;
    private var _length:int;
    private var source:String;
    private var cansel:Boolean;  
    public function Tokenizer(){
        
    }
    


    //指定インデクスからmax個までトークン抽出
    //抽出したトークンはlistに追加
    //抽出したところまでのインデクスを返す
    public function createToken(str:String):void{
        
        source = str;
        tokenList = new Vector.<Token>;
        index01 = 0;
         
        var i:int = 0;
        var cnt:int = 0;
        loop( 
            function _while():Boolean{ 
                i= func01();
                
                if(cnt==0){
                    var e:ProgressEvent = new ProgressEvent(ProgressEvent.PROGRESS,false,true,i,str.length);
                    dispatchEvent(e);
                }
                cnt++;
                cnt%=500;

                return i<str.length;
            }, 
            function onComplete():void { 
                addToken("",Token.EOF);//EOF追加
                _length = tokenList.length;
                var event:Event = new Event(Event.COMPLETE);
                dispatchEvent(event);
                
            } 
        );
    }
    public function get length():int{
        return _length;
    }
    //先頭からの順を指定してトークンを取得
    public function getToken(index:int=0):Token{
        if(index<0 && tokenList.length<=index)return null;
        return tokenList[index];
    }
    //Eofトークン
    public function getEof():Token{
        return getToken(length-1);
    }
    //トークン列に追加
    private function addToken(str:String,type:int):int{
        var obj:Token = new Token();
        obj.text = str;
        obj.type = type;
        obj.next = null;
        tokenList.push(obj);
        if(1<tokenList.length){ 
            tokenList[tokenList.length-1].prev = tokenList[tokenList.length-2];
            tokenList[tokenList.length-2].next = tokenList[tokenList.length-1];
        }
        else tokenList[tokenList.length-1].prev = null;
        return tokenList.length;
    }
    



//-------------------------------------------------------------
    //開始インデクスを受け取りトークンのタイプを返す
    private var index01:int=0;
    private function func01():int{//
        if(index01 >= source.length)return source.length;
        var index:int = index01;
        var type:int;//トークンタイプ
        var str:String;//トークン文字列
        var reg:RegExp = new RegExp();                
        var result:Object;
        //トークンタイプ：空白か？
        if(    source.charAt(index)== " " ||
               source.charAt(index)=="\t" ||
               source.charAt(index)=="\n" ||
               source.charAt(index)=="\r" ){
                   type = Token.SPACE;
                   reg = /[^\s]/mg;
                   reg.lastIndex = index;
                   result = reg.exec(source);
                   //トークン作成
                   if(result == null){//
                       str = source.substring(index,source.length);
                       index01 = source.length;//次の開始位置
                   }
                   else{//
                       str = source.substring(index,result.index);
                       index01 = result.index;                       
                   }
                   addToken(str,type);
                   return index01;
                                       
               }

        
        //トークンタイプ:文字列定数１
        if(source.charAt(index)== "'"){
            type = Token.TEXT;
            var indexA:int = index;
            reg = /['\n\r]/mg;//改行か次の[']が現れる位置
            do{//エスケープ処理
                reg.lastIndex = indexA+1;
                result = reg.exec(source);
                if(result==null)break;
                else indexA = result.index;
            }while(source.charAt(indexA-1)=="\\");//["]が現れてもその前がエスケープなら再検索
            
            //トークン作成
            if(result == null){//エラー
                str = "'";
                type = Token.ERROR;
                index01 = index+1;//次の開始位置
            }
            else{//
                str = source.substring(index,result.index+1);
                index01 = result.index+1;//次の開始位置
            }
            addToken(str,type);
            return index01;
                
        }
 
        //トークンタイプ:文字列定数2
        if(source.charAt(index)== '"'){
            type = Token.TEXT;
            var indexB:int = index;
            reg = /["\n\r]/mg;//改行か次の["]が現れる位置
            do{//エスケープ処理
                reg.lastIndex = indexB+1;
                result = reg.exec(source);
                if(result==null)break;
                else indexB = result.index;
            }while(source.charAt(indexB-1)=="\\");//["]が現れてもその前がエスケープなら再検索
            
            //トークン作成
            if(result == null){//エラー
                str = '"';
                type = Token.ERROR;
                index01 = index+1;//次の開始位置
                
            }
            else{//
                str = source.substring(index,result.index+1);
                index01 = result.index+1;//次の開始位置
                
            }
            addToken(str,type);
            return index01;
        }
        
        if(source.charAt(index)== "/"){
               //一行コメント
               if(source.charAt(index+1)== "/"){//
                   reg = /[\n\r]/mg;
                   reg.lastIndex = index+2;
                   result = reg.exec(source);
                   //トークン作成
                   type = Token.COMMENT;
                   if(result == null){
                       str = source.substring(index,source.length);
                       index01 = source.length;//次の開始位置                       
                   }
                   else{// 
                       str = source.substring(index,result.index);
                       index01 = result.index;//次の開始位置
                   }
                   addToken(str,type);
                   return index01;
               }
               //複数行コメント
               if(source.charAt(index+1)== "*"){
                   reg = /\*\//mg;
                   reg.lastIndex = index+2;
                   result = reg.exec(source);
                   
                   //トークン作成
                   type = Token.COMMENT;
                   if(result == null){//エラー
                       type = Token.ERROR;
                       str = '/*';
                       index01 = index+2;//次の開始位置
                   }
                   else{//
                       str = source.substring(index,result.index+2);
                       index01 = result.index+2;//次の開始位置                       
                   }
                   addToken(str,type);
                   return index01;
               }
        }

        //英数字
        if((source.charCodeAt(index) > 64 && source.charCodeAt(index) < 91) ||// A-Z
           (source.charCodeAt(index) > 96 && source.charCodeAt(index) < 123)||// a-z
            source.charCodeAt(index) == 95 ){// _
                reg = /[^a-zA-Z0-9_]/mg;//英数字以外が現れる位置
                reg.lastIndex = index+1;
                result = reg.exec(source);
                type = Token.WORD;
                if(result == null){//eof
                    str = source.substring(index,source.length);
                    index01 = source.length;
                }
                else{//
                    str = source.substring(index,result.index);
                    index01 = result.index;//次の開始位置
                }
                addToken(str,type);
                return index01;
                
        }
        
        
        //数値
        if(source.charCodeAt(index) > 47 && source.charCodeAt(index) < 58){
            reg = /[^a-zA-Z0-9_.]/mg;
            reg.lastIndex = index+1;
            result = reg.exec(source);
            type = Token.NUMBER;
            if(result == null){//eof
                str = source.substring(index,source.length);
                index01 = source.length;
            }
            else{// 
                str = source.substring(index,result.index);
                index01 = result.index;//次の開始位置
            }
            //num();//種類判別
            addToken(str,type);
            return index01;

        }
        
        //半角記号
        if(source.charCodeAt(index)<127 && source.charCodeAt(index)>32){
            type = Token.MARK;
            str = source.charAt(index);
            index01 = index+1;
            
            addToken(str,type);
            return index01;
        }
    
        //その他文字列　マルチバイト文字等はここに入る
        type = Token.OTHER;
        reg = /[\x01-\x7f]/mg;
        reg.lastIndex = index+1;
        result = reg.exec(source);
        if(result == null){//eof
            str = source.substring(index,source.length);
            index01 = source.length;
        }
        else{// 
            str = source.substring(index,result.index);
            index01 = result.index;//次の開始位置
        }
        
        addToken(str,type);
        return index01;
    }
     
}//class





