/**
 * Copyright soh1106c ( http://wonderfl.net/user/soh1106c )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bkgb
 */

package
{
    import flash.ui.Keyboard;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;

    import jiglib.geometry.*;
    import jiglib.math.*;
    import jiglib.cof.JConfig;
    import jiglib.physics.*;
    import jiglib.physics.constraint.*;
    import jiglib.plugin.papervision3d.*;

    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.math.Plane3D;
    import org.papervision3d.core.utils.Mouse3D;
    import org.papervision3d.events.*;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.ViewportLayer;
    import org.papervision3d.view.layer.util.ViewportLayerSortMode;
    import org.papervision3d.objects.parsers.*;

    
    [SWF(width="600", height="800", backgroundColor="#ffffff", frameRate="60")]
    public class Constraints extends BasicView
    {
        private var mylight:PointLight3D;
        private var mouse3D:Mouse3D;
        private var colorMateria:ColorMaterial;
        private var wireframeMateria:WireframeMaterial;
        private var vplObjects:ViewportLayer;
        
        private var ground:RigidBody;
        private var chainBody1:Vector.<RigidBody>;
        private var chain1:Vector.<JConstraintPoint>;
        
        private var onDraging:Boolean = false;
        
        private var currDragBody:RigidBody;
        private var dragConstraint:JConstraintWorldPoint;
        private var startMousePos:Vector3D;
        private var planeToDragOn:Plane3D;
        
        private var physics:Papervision3DPhysics;
        
        private var CarSkin1:DAE;
        private var CarSkin2:DAE;
        private var CarSkin3:DAE;
        private var CarSkin4:DAE;
        private var CarSkin5:DAE;
        private var CarSkin6:DAE;
        private var CarSkin7:DAE;
        private var CarSkin8:DAE;
         
        public function Constraints()
        {
            super(800, 600, true, true, CameraType.TARGET);
            
            stage.addEventListener(MouseEvent.MOUSE_UP, handleMouseRelease);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
            
            Mouse3D.enabled = true;
            mouse3D = viewport.interactiveSceneManager.mouse3D;
            viewport.containerSprite.sortMode = ViewportLayerSortMode.INDEX_SORT;
            
            mylight = new PointLight3D(true, true);
            mylight.y = 300;
            mylight.z = -400;
            
            camera.y = mylight.y;
            camera.z = mylight.z;
             
            startRendering();
            
            initObject();
        }

        private function initObject():void
        {
            physics = new Papervision3DPhysics(scene, 8);
            
            wireframeMateria = new WireframeMaterial(0,0);
            var materiaList :MaterialsList = new MaterialsList();
            materiaList.addMaterial(wireframeMateria, "all");
            
            ground = physics.createCube(materiaList, 500, 500, 10,10,1,10);
            ground.y = -500;
            ground.rotationZ=30;
            ground.movable = false;
            viewport.getChildLayer(physics.getMesh(ground)).layerIndex = 1;
             
            vplObjects = new ViewportLayer(viewport,null);
            vplObjects.layerIndex = 2;
            vplObjects.sortMode = ViewportLayerSortMode.Z_SORT;
            viewport.containerSprite.addLayer(vplObjects);
            
            colorMateria = new ColorMaterial(0x0000ff,0.1);
            colorMateria.interactive = true;
        
            CarSkin1=new DAE;
            CarSkin1.load("http://soh1106.lolipop.jp/res/car/c1.DAE");
            CarSkin1.scale=1;
            scene.addChild(CarSkin1);
            var CarBox1=new JBox(new Pv3dMesh(CarSkin1),200,50,50);
            physics.addBody(CarBox1);
            
            CarSkin2=new DAE;
            CarSkin2.load("http://soh1106.lolipop.jp/res/car/c2.DAE");
            CarSkin2.scale=1;
            scene.addChild(CarSkin2);
            var CarBox2=new JBox(new Pv3dMesh(CarSkin2),200,50,50);
            physics.addBody(CarBox2);
            
            CarSkin3=new DAE;
            CarSkin3.load("http://soh1106.lolipop.jp/res/car/c3.DAE");
            CarSkin3.scale=1;
            scene.addChild(CarSkin3);
            var CarBox3=new JBox(new Pv3dMesh(CarSkin3),200,50,50);
            physics.addBody(CarBox3);
            
            CarSkin4=new DAE;
            CarSkin4.load("http://soh1106.lolipop.jp/res/car/c4.DAE");
            CarSkin4.scale=1;
            scene.addChild(CarSkin4);
            var CarBox4=new JBox(new Pv3dMesh(CarSkin4),200,50,50);
            physics.addBody(CarBox4);
            
            CarSkin5=new DAE;
            CarSkin5.load("http://soh1106.lolipop.jp/res/car/c5.DAE");
            CarSkin5.scale=1;
            scene.addChild(CarSkin5);
            var CarBox5=new JBox(new Pv3dMesh(CarSkin5),200,50,50);
            physics.addBody(CarBox5);
            
            CarSkin6=new DAE;
            CarSkin6.load("http://soh1106.lolipop.jp/res/car/c6.DAE");
            CarSkin6.scale=1;
            scene.addChild(CarSkin6);
            var CarBox6=new JBox(new Pv3dMesh(CarSkin6),200,50,50);
            physics.addBody(CarBox6);
            
            CarSkin7=new DAE;
            CarSkin7.load("http://soh1106.lolipop.jp/res/car/c7.DAE");
            CarSkin7.scale=1;
            scene.addChild(CarSkin7);
            var CarBox7=new JBox(new Pv3dMesh(CarSkin7),200,50,50);
            physics.addBody(CarBox7);
            
            CarSkin8=new DAE;
            CarSkin8.load("http://soh1106.lolipop.jp/res/car/c8.DAE");
            CarSkin8.scale=1;
            scene.addChild(CarSkin8);
            var CarBox8=new JBox(new Pv3dMesh(CarSkin8),200,50,50);
            physics.addBody(CarBox8);
            
            var CarBall=physics.createSphere(colorMateria, 50,6,3);
            
            chain1 = new Vector.<JConstraintPoint>();
            chainBody1 = new Vector.<RigidBody>();
            chainBody1.push(CarBall);
            chainBody1.push(CarBox1);
            chainBody1.push(CarBox2);
            chainBody1.push(CarBox3);
            chainBody1.push(CarBox4);
            chainBody1.push(CarBox5);
            //chainBody1.push(CarBox6);
            //chainBody1.push(CarBox7);
            chainBody1.push(CarBox8);
            
            for (var i:int = 0; i <chainBody1.length; i++)
            {                    
                chainBody1[i].maxLinVelocities = 200;
                chainBody1[i].maxRotVelocities = 10;
                physics.getMesh(chainBody1[i]).addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, handleMousePress);
                chainBody1[i].moveTo(new Vector3D( 0, 100 + (20 * i+20), 0));
                vplObjects.addDisplayObject3D(physics.getMesh(chainBody1[i]));
            }
             
            var pos1:Vector3D;
            var pos2:Vector3D;
            for (i = 1; i < chainBody1.length; i++ ){
                pos1 = JNumber3D.getScaleVector(Vector3D.Y_AXIS, chainBody1[i - 1].boundingSphere);
                pos2 = JNumber3D.getScaleVector(Vector3D.Y_AXIS, -chainBody1[i].boundingSphere);
                chain1[i - 1] = new JConstraintPoint(chainBody1[i - 1], pos1, chainBody1[i], pos2, 1, 0.01);
            }
        }
         
        private function findSkinBody(skin:DisplayObject3D):int
        {
            for (var i:String in PhysicsSystem.getInstance().bodies)
            {
                if (skin == physics.getMesh(PhysicsSystem.getInstance().bodies[i]))
                {
                    return int(i);
                }
            }
            return -1;
        }
        
        private function handleMousePress(event:InteractiveScene3DEvent):void
        {
            onDraging = true;
            trace(1);
            startMousePos = new Vector3D(mouse3D.x, mouse3D.y, mouse3D.z);
            currDragBody = PhysicsSystem.getInstance().bodies[findSkinBody(event.displayObject3D)];
            planeToDragOn = new Plane3D(new Number3D(0, 0, -1), new Number3D(0, 0, -startMousePos.z));
            
            var bodyPoint:Vector3D = startMousePos.subtract(currDragBody.currentState.position);
            dragConstraint = new JConstraintWorldPoint(currDragBody, bodyPoint, startMousePos);
        }
        
        private function handleMouseMove(event:MouseEvent):void
        {
            if (onDraging)
            {
                var ray:Number3D = camera.unproject(viewport.containerSprite.mouseX, viewport.containerSprite.mouseY);
                ray = Number3D.add(ray, new Number3D(camera.x, camera.y, camera.z));
                
                var cameraVertex3D:Vertex3D = new Vertex3D(camera.x, camera.y, camera.z);
                var rayVertex3D:Vertex3D = new Vertex3D(ray.x, ray.y, ray.z);
                var intersectPoint:Vertex3D = planeToDragOn.getIntersectionLine(cameraVertex3D, rayVertex3D);
                
                dragConstraint.worldPosition = new Vector3D(intersectPoint.x, intersectPoint.y, intersectPoint.z);
            }
        }

        private function handleMouseRelease(event:MouseEvent):void
        {
            if (onDraging)
            {
                onDraging = false;
                dragConstraint.disableConstraint();
                currDragBody.setActive();
            }
        }
        
        private function resetBody():void
        {
            if (chainBody1[0].currentState.position.y < -1000)
            {
                for (var i:String in chainBody1)
                {
                    chainBody1[i].moveTo(new Vector3D( 0, 800 + (20 * int(i) + 20), 0));
                }
            }
        }
        
        protected override function onRenderTick(event:Event = null):void {
            
            //physics.step();//dynamic timeStep
            physics.engine.integrate(0.2);//static timeStep
            resetBody();
            super.onRenderTick(event);
        }
    }
}