/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bk1d
 */

// forked from siouxcitizen's Away3D Gold Practice10 Wonderflサーバに置いた画像をPlaneのテクスチャとして使用
// forked from siouxcitizen's Away3D Gold Practice09 Torus表示
// forked from siouxcitizen's Away3D Gold Practice08 Cylinder表示実験
// forked from siouxcitizen's Away3D Gold Practice06 Cube 5つ表示
// forked from siouxcitizen's Away3D Gold Practice05 光のあて方よくわからない。。。
// forked from siouxcitizen's Away3D Gold Practice04 SphereとWireframeSphere表示
// forked from siouxcitizen's Away3D Gold Practice03 WireframePlane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice02 Plane 5枚表示
// forked from siouxcitizen's Away3D Gold Practice01 Plane 1枚表示
//
//Away3D 4.0 Gold でPlaneにBase64形式の画像をテクスチャとして貼り付けてみました
//画像形式が異なるからなのか？ドット数が異なるからなのか？　一部画像がとりこめませんでした
//
//自分作成の昔のコードを参考にしました
//Away3D練習10　Base64形式画像をPlaneのテクスチャとして使用
//http://wonderfl.net/c/pOvw
//
package {
    import away3d.containers.View3D;
    import away3d.containers.Scene3D;
    import away3d.cameras.Camera3D;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.materials.TextureMaterial;
    import away3d.primitives.PlaneGeometry;
    import away3d.primitives.PrimitiveBase;
    import away3d.utils.Cast;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.display.Bitmap;
    import flash.display.BitmapData;

    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="465", height="465")]
    public class PlaneTextureSample extends Sprite {

        private static const ZERO : Vector3D = new Vector3D(0, 0, 0);
        private var _view : View3D;
        private var _scene : Scene3D;
        private var _camera : Camera3D;
        private var _zakuPlaneOmote : Mesh;
        private var _zakuPlaneUra : Mesh;
        private var _slaPlaneOmote : Mesh;
        private var _slaPlaneUra : Mesh;   
        private var _wizPlaneOmote : Mesh;
        private var _wizPlaneUra : Mesh;     

        //Base64表現によるテクスチャ用画像データ zaku画像
        private var _textureZakuImgData : String = "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"

        //Base64表現によるテクスチャ用画像データ sla画像
        private var _textureSlaImgData : String = "/9j/4AAQSkZJRgABAQAAAQABAAD/2wCEAAQDAwQDAwQEAwQFBQQFBwwHBwYGBw4KCwgMEQ8SEhEPEBATFRsXExQaFBAQGCAYGhwdHh8eEhchJCEeJBseHh0BBQUFBwYHDgcHDh0TEBMdHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHR0dHf/AABEIAIAAgAMBIgACEQEDEQH/xAGiAAABBQEBAQEBAQAAAAAAAAAAAQIDBAUGBwgJCgsQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+gEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoLEQACAQIEBAMEBwUEBAABAncAAQIDEQQFITEGEkFRB2FxEyIygQgUQpGhscEJIzNS8BVictEKFiQ04SXxFxgZGiYnKCkqNTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqCg4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2dri4+Tl5ufo6ery8/T19vf4+fr/2gAMAwEAAhEDEQA/APv6iiigAooooAKKKKACiivNvjh4nTw/4Fu7aObZfar/AKLEo2klT/rCQf4dmVyAcF16ZzXRhMNLFV40Ibydv+D8jmxmKhhKE8RPaKv/AMD57HpNFcv8O/E6eLvB+l6l53m3RiEV0TtDCZRh8heBk/MBxwwOBmuoqK1KVGpKlPdOxpQrQr041YbSV18wooorI1CiiigAooooAKKKKACiiigAooooAK+Tvjr4v/4SPxg+n2zZsdG3W68felyPMPIB6gLjkfJkda9Y+MXxUg8K2NxomjyeZrt1EVZkcj7GrD7xIOQ+DlR24Y8YDfK1fd8KZTKL+u1Vb+X57v8ARfM/PuMM4jJfUKLvr73y2X6v0Xme4/s6eL/seqXfhm7b9zfZuLbjpKq/OOB3Rc5JwPL9Wr6Rr4BgnltZ4p7WV4p4mDxyRsVZGByCCOhB719hfDL4m2XxA04o4S31q3UG5tQeCOnmJnqpP4qTg9iefirKZRqfXaS91/F5Pv8AP8/U6OEM4jOl9QrP3l8Pmu3qvy9DvKKKK+MPuQooooAKKKKACiiigAooooAK8q+LXxai8GQPpWhukviCVeTgMtopHDMO7EchfxPGA2f8UPjdF4bnutF8LqlxqqKUluyQY7V89AMfOwGcjoDjOeVHzNPPLdTyz3UryzysXkkkYszsTkkk9ST3r7HIeHZVmsTi17u6Xfzfl+fpv8RxDxNGgnhcG7z2b7eS8/Pp67E88t1PLPdSvLPKxeSSRizOxOSST1JPeo6KK/QkraI/Nm76sKuaVqt7oeo2+o6TcPb3tu2+OVOoP9QRkEHggkHiqdFKUVJOMldMcZOLUouzR9jfDL4m2XxA04o4S31q3UG5tQeCOnmJnqpP4qTg9ie8r4J0rVb3Q9Rt9R0m4e3vbdt8cqdQf6gjIIPBBIPFfVPwy+MFl46c6dqEKWOtIoKxB8pcgD5imehBydhyQOcnBx+cZ7w9LCt4jDK9Pqv5f+B+XXufp/D/ABLDFpYbFO1TZPpL/J/n07HptFFFfKH2AUUUUAFFFeRfEf442XhWe40rw7El9rMLBZHkGYITk7lJBBZhjGBgAnk5BWurB4KvjKnsqEbv8vU48bj6GBpe1xErL8/JHpOt+JNI8NwedrupWtkhVnUTSANIFGTtXqx5HABPI9a+fviF8fL3U3m07wUXsrJWZGv/APlrOuMfKCP3YySQfvfdPynIryLWdd1LxFfPe65ezXd02fnlbO0ZJ2qOirknAGAM8Cs+v0HLOF8PhmqmI9+X4L5dfn9x+cZrxbicWnSw/uR/8mfz6fL7woqpqOq2GjwLPq17bWcDNsElzKsalsE4ySOcA/lT7K+tdStkutOuYbm2kzsmgcOjYODgjg8gj8K+n5o35b6nynJLl57adyxRRRTJCiiigAqSCeW1nintZXiniYPHJGxVkYHIII6EHvVDUdVsNHgWfVr22s4GbYJLmVY1LYJxkkc4B/Kn2V9a6lbJdadcw3NtJnZNA4dGwcHBHB5BH4VPNFvl6l8k0ue2nc+ifh/+0F9yw8ff7RGpxp+IV40X6jcv+zkdWr3XTdW0/WYGn0e+tb2BW2GS2lWRQ2AcZUnnBHHvXwTW54W8X6v4O1FL3Qrt4iGDSQkkxTgZ4dc/MME+4zkEHmvlMz4Vo171ML7ku32f+B+XkfX5VxfXw9qWLXPHv9pf5/PXzPuaivIvhx8cbLxVPb6V4iiSx1mZisbxjEExyNqgkkqxzjByCRwckLXrtfB4zBV8HU9lXjZ/n6H6FgsfQx1L2uHldfl5M8W+NnxUn8OZ8O+HZPL1KaINcXaON1urdFXByHI5ycYBBHJBX5mrU8Sa3L4k1/UtWuN4e9naUI8hcxqT8qbj1CjAHTgDpWXX6tlOXQwGHVOK95/E+7/4HQ/IM5zOpmOJlUk/dXwrsv8Ag9QqpquoxaPpd7qNyrtBZwPO6xgFiqqWOM45wKt1XvrKDUrK5sr1PMtrmNoZUyRuVhgjI5HB7V6Ur8r5dzzIcvMufbqfFXiXxLqPizV5tT1mbzLiThVXhIl7Io7KM/zJySTWn4A8bXngfXYbu3kc2MrKl5ABuEseecDI+YAkqcjn2JBPG3gDVvA+oSQ38Ly2JYCG+RD5coOcDP8AC2AcqTng9RgnX+Gfwzv/ABjqltc3ls8WgxMJJp5VZVnUNgxoRjJJBBIPy898A/nlOnivrSST9pf+m/I/Yq9fAfUHKTXsbfK3ZefZb3PrOiiqGpa5pei+V/bGpWdl5ufL+0zrHvxjONxGcZH51+hykoq8nY/HYwlN8sVdl+qmq6jFo+l3uo3Ku0FnA87rGAWKqpY4zjnAo07VbDWIGn0m9tryBW2GS2lWRQ2AcZBPOCPzp99ZQalZXNlep5ltcxtDKmSNysMEZHI4Pak3zRvB+hSioTSqLTr3PirxL4l1HxZq82p6zN5lxJwqrwkS9kUdlGf5k5JJrT8AeNrzwPrsN3byObGVlS8gA3CWPPOBkfMASVORz7EgnjbwBq3gfUJIb+F5bEsBDfIh8uUHOBn+FsA5UnPB6jBOv8M/hnf+MdUtrm8tni0GJhJNPKrKs6hsGNCMZJIIJB+XnvgH89p08V9aSSftL/035H7BXr4D6g5Sa9jb5W7Lz7Le59Z0UUV+iH42FfTPwT+Kk/iPHh3xFJ5mpQxFre7dxuuFXqrZOS4HORnIBJ5BLfM1anhvW5fDev6bq1vvL2U6ylEkKGRQfmTcOgYZB68E9a8zNsuhj8O6cl7y+F9n/wAHqerk2Z1MuxMakX7r+Jd1/wADoWPGXh9vC3inVdIZXCWs7LF5jKzNGeUJI4yUKnt16DpWHX1j8X/hZ/wnNqmpaQ23XbSLYiM2EuIwSdhzwrZJIPTnB4wV+Up4JbWeWC6ieKeJikkcilWRgcEEHoQe1Z5NmkMfh1JP318S8+/ozXPMpqZdiXFr3G24vy7eqI6KKK9c8UKKKoa5qX9i6JqWpeV5v2K2kuPL3bd+xS2M4OM464pSkopyfQqEXOSjHdnjnxd+Lt1pd7P4f8KzwhhGUuryMkyROTyiHoGAHJ5ILYG0rXgM88t1PJPcyPLPKxd5JGLM7E5JJPUk0Tzy3U8k9zI8s8rF3kkYszsTkkk9STUdfnONxtTF1HOb06Lsfs2WZZRy+iqdNa9X1bLFlfXWm3KXWnXM1tcx52TQOUdcjBwRyOCR+NfSnwk+K0vi95tK8RPbR6rGqmB0yhulA+bjpuGMnGMgnCgKa+Y60/Dusy+Hdd07VbfeXs51lKJIULqD8y5HQMMg+xNaZfjp4Sqmn7vVGWcZVSzChKLXvpe6+qf+T6n3DRRRX6GfjgUUUUAFbng3w+3inxTpWkKrlLqdVl8tlVljHLkE8ZCBj36dD0rHgglup4oLWJ5Z5WCRxxqWZ2JwAAOpJ7V9W/CD4Wf8INavqWrtu127i2OitlLeMkHYMcM2QCT04wOMlvIznNIYDDuTfvv4V59/RHtZHlNTMcSope4mnJ+Xb1Z6jXn/AMQPhHo3jrfdf8eGsttH26NS24Lxh0yA3HGeDwvOBivQKK/KsNiquFqKrRlytf18/Q/XsVhKOLpulXipRff+tH5o+LfF/wAMfEngrdJqtl5tiP8Al9tSZIv4epwCvLAfMBk5xmuPr9Aq4fxP8I/CniqSa4vNP+zX033rqzbynJ3bixH3WY5OSyk89eBj7TA8YKyji4fNf5f8H5Hw2P4Kd3PBT+Uv81+q+Z8a1HPBFdQSQXMaSwSqUeORQyupGCCD1BFfQuufs0/6+Tw3rn93yre+i+md0i/iRhPQe9cXqXwE8a2M6x2tna36FdxltrlAoOTx+82nPGemOetfQ0c9y+utKqXrp+Z81X4fzLDvWk36a/lc/NnxZ4YvPCOu3el6gjgxMTFKy7RNHk7XHJ4IHqcHIPINYlfd/wARf2ctW8UmW21fwvqaarBH5cN9aW7TeXnDD5kyrr7ZOMsAVJJr5g1n4C+K9PnxpiW2pwMzBXhmWNlUHgsHIwSOwLYweemfmcVlk1Jywvvw6Wd9/Q+/y/PqU6ahjP3dTZ8y5U2t7N6fI8vrtfhZ4Rn8WeLbFfs/madZyLPdu8YeMKDkIwPB3kbcc8EnBANdHoPwA8Sai6trUttpcG4qwZhNJjGQQqnaQTxywPXjpn6m8D/AXVvDiDTPDXhLU4JLjBknuoWjMpVeryPhR0PGQMk4HNaYLLJKaq4v3ILXV2vb1/EwzXPqfspUcD+8qPT3VdK/muva19SrRXpum/ATxrfTtHdWdrYIF3CW5uUKk5HH7vcc856Y4612mh/s0/6iTxJrn97zbexi+uNsjfgTlPUe9fRV8+y+iveqp+mv5XPhsPw9mVd2jSa9dPzsfP1dh4Q+GPiTxrtk0qy8qxP/AC+3RMcX8XQ4JblSPlBwcZxX014Y+EfhTwrJDcWen/ab6H7t1eN5rg7twYD7qsMDBVQeOvJz3FfPY7jBWccJD5v/AC/4PyPpsBwU7qeNn8o/5v8ARfM8/wDh/wDCPRvAuy6/4/8AWV3D7dIpXaG4wiZIXjjPJ5bnBxXoFFFfF4nFVcVUdWtLmb/r5eh9zhcJRwlNUqEVGK7f1q/NhRRRWB0BRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB//Z"

        //Base64表現によるテクスチャ用画像データ wizard画像
        private var _textureWizImgData : String = "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"

        private const UV_DATA:Array =
        [
            _textureZakuImgData,
            _textureSlaImgData,
            _textureWizImgData
        ];

        private var _count : int = 0;    // 読み込んだ画像数
        private var _images : Array;    // 読み込んだUV画像保持用配列

        private var _capture : BitmapData = new BitmapData(465, 465, false, 0x000000);

        public function PlaneTextureSample() {

           // wonderfl capture
           Wonderfl.disable_capture();
           //addChild(new Bitmap(_capture)) ;

            _images = new Array(UV_DATA.length);

            for (var i:int = 0; i < UV_DATA.length; i++)
            {
                Base64ImageLoader( UV_DATA[i], i, onComplete );
            }

        }

        private function onComplete( event:Event ):void {
            var uv:Bitmap = event.target.content as Bitmap;
            
            _images[event.currentTarget.loader.name] = uv;
            if (++_count == UV_DATA.length) display();

        }

        private function display():void {

            _view = new View3D();
            _scene = _view.scene;
            _camera = _view.camera;
            addChild(_view);

            _view.antiAlias = 0;
            _view.backgroundColor = 0x555555;

            _camera.y = 0;
            _camera.z = -700;

            _zakuPlaneOmote = new Mesh(new PlaneGeometry(200, 200), new TextureMaterial(Cast.bitmapTexture(_images[0])));
            _zakuPlaneOmote.x = 0;
            _zakuPlaneOmote.y = 250;
            _scene.addChild(_zakuPlaneOmote);

            //doubleSidedプロパティがうまく設定できないのでごまかし気味に。。。
            _zakuPlaneUra = new Mesh(new PlaneGeometry(200, 200), new TextureMaterial(Cast.bitmapTexture(_images[0])));
            _zakuPlaneUra.rotationX = 180;
            _zakuPlaneUra.rotationY = 180;
            _zakuPlaneOmote.addChild(_zakuPlaneUra);


            _slaPlaneOmote = new Mesh(new PlaneGeometry(200, 200), new TextureMaterial(Cast.bitmapTexture(_images[1])));
            _slaPlaneOmote.x = -250;
            _slaPlaneOmote.y = 0;
            _scene.addChild(_slaPlaneOmote);

            //doubleSidedプロパティがうまく設定できないのでごまかし気味に。。。
            _slaPlaneUra = new Mesh(new PlaneGeometry(200, 200), new TextureMaterial(Cast.bitmapTexture(_images[1])));
            _slaPlaneUra.rotationX = 180;
            _slaPlaneUra.rotationY = 180;
            _slaPlaneOmote.addChild(_slaPlaneUra);


            //3つめの画像うまく取り込めないみたいなので、テキトーに。。。
            //ファイル形式が違うから？？？　ドット数が違うから？？？
            _wizPlaneOmote = new Mesh(new PlaneGeometry(200, 200), new TextureMaterial(Cast.bitmapTexture(_images[0])));
            _wizPlaneOmote.x = 250;
            _wizPlaneOmote.y = 0;
            _scene.addChild(_wizPlaneOmote);

            //doubleSidedプロパティがうまく設定できないのでごまかし気味に。。。
            _wizPlaneUra = new Mesh(new PlaneGeometry(200, 200), new TextureMaterial(Cast.bitmapTexture(_images[1])));
            _wizPlaneUra.rotationX = 180;
            _wizPlaneUra.rotationY = 180;
            _wizPlaneOmote.addChild(_wizPlaneUra);


            addEventListener(Event.ENTER_FRAME, update);
            
            addChild(new AwayStats());
        }

        private function update(event : Event) : void {

            _zakuPlaneOmote.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _zakuPlaneOmote.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _slaPlaneOmote.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _slaPlaneOmote.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _wizPlaneOmote.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
            _wizPlaneOmote.rotationY = stage.mouseX - (stage.stageWidth >> 1);

            _camera.lookAt(ZERO);
            _view.render();
            //_view.renderer.queueSnapshot(_capture);
        }
    }
}

//Base64化された画像データを表示可能な形式に変換するクラス
import flash.display.Loader;
import flash.events.Event;
function Base64ImageLoader( data:String, i:int, complete:Function = null ):Loader
{
    
    var loader:Loader
    
    loader = new Loader();
    
    if( complete != null )
        loader.contentLoaderInfo.addEventListener( Event.COMPLETE, complete );
    
    loader.loadBytes( Base64toByteArray( data ) );
                    loader.name = i.toString();
    return loader;
}

import flash.utils.ByteArray;
import mx.utils.Base64Decoder;
function Base64toByteArray( data:String ):ByteArray
{
    var byteArray:ByteArray;
    var base64Decoder:Base64Decoder;;
    
    base64Decoder = new Base64Decoder();
    base64Decoder.decode(data);
    
    try {
        byteArray = base64Decoder.toByteArray();
        byteArray.position = 0;
    } catch (e:Error) {
        return null;
    }
    
    return byteArray;
}
