/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bjvq
 */

// forked from hacker_yk666qry's flash on 2010-1-11
package {
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import flash.geom.ColorTransform;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.BlendMode;
	
	/**
	 * ...
	 * @author ...
	 */
	 [ SWF(width=465,　height=465,　backgroundColor=0x000000, frameRate=30) ]
    public class BitmapDataSample extends Sprite {
    	
		private var _bmd:BitmapData;
		private var _sprite:Sprite;
		private var _matrix:Matrix;
		private var _colortrans:ColorTransform;
		
		//コンストラクタ
		public function BitmapDataSample() {
			_bmd = new BitmapData( 465, 465, false, 0x0 );
			addChild( new Bitmap( _bmd ) );
			
			//グラフィックの作成
			// 中心x, 中心y, 幅高さ, 色
			_sprite = newFig( 0, 0, 40, 0xffffff );
			
			
			
			//Matrixの初期化
			_matrix = new Matrix();
			//色変換
			_colortrans = new ColorTransform();
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler ); 
			stage.addEventListener( MouseEvent.CLICK, reset );			
		}
		
        private function enterFrameHandler(e:Event):void {
            var s:Number = Math.random()*2;
            
            //変形初期化
            _matrix.identity();
            //scale, rotate, translate　の順で
            _matrix.scale( s, s );
            _matrix.rotate( Math.PI * Math.random() );
            _matrix.translate( mouseX, mouseY);
            
            _colortrans.redMultiplier = mouseX / 465;
            _colortrans.blueMultiplier = mouseY / 465;
            _colortrans.alphaMultiplier = Math.random();
			//BitmapDataへ描画
			//_bmd.draw( _sprite, _matrix );
			//変形、回転等をしない場合は copyPixels(描画オブジェクト, 領域, 位置) を使うほうが高速に描画できる
			_bmd.draw( _sprite, _matrix, _colortrans, BlendMode.ADD );
        }
		
		private function reset( e:MouseEvent ):void {
			_bmd.fillRect( _bmd.rect, 0xff000000 );
		}
    
        private function newFig( cx:Number, cy:Number, size:Number, col:uint ):Sprite {
            //中心(cx,cy), 幅高さsize, 色col　のグラフィックを生成
            var shape:Sprite = new Sprite();
            shape.graphics.lineStyle( 0, 0x000000, 0.3 ); 
            shape.graphics.beginFill( col );
            shape.graphics.drawCircle( cx, cy, size*0.5 );
            shape.graphics.drawCircle( cx, cy, size*0.4 );
            var w:Number = size * 0.6;
            var h:Number = size * 0.15;
            shape.graphics.drawRect( cx - w/2, cy - h/2, w, h );
            shape.graphics.endFill();
            return shape;
        }
    }
	
}