/**
 * Copyright amdmamdma ( http://wonderfl.net/user/amdmamdma )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bjhe
 */

package {
    import flash.display.MovieClip;
    import flash.text.TextField;
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.display.Graphics;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // 玉の直径
            const BALL_SIZE:uint = 50;
            //玉の数
            const BALL_CNT:uint =12;
            //背景生成
            var sp02:Sprite = new Sprite();
            var gr02:Graphics = sp02.graphics;
            gr02.beginFill(0x000000);
            gr02.drawRect(0, 0, 500, 500);
            gr02.endFill();
            addChild(sp02);
            //玉元画像生成
            var sp01:Sprite = new Sprite();
            var gr01:Graphics = sp01.graphics;
            var colors:Array = [0xffffff, 0x0000ff];
            var alphas:Array = [1, 0];
            var ratios:Array = [100, 255];
            var mtr01:Matrix = new Matrix();
            mtr01.createGradientBox(BALL_SIZE, BALL_SIZE);
            gr01.beginGradientFill("radial", colors, alphas, ratios, mtr01);
            gr01.drawCircle(BALL_SIZE * 0.5, BALL_SIZE * 0.5, BALL_SIZE * 0.5);
            gr01.endFill();
            sp01.x = - sp01.width * 0.5;
            sp01.y = - sp01.height * 0.5;
            //玉sprite格納用
            var ar02:Array = [];
            //玉生成
            function xCreateBall(nCnt:uint = 1):void{

                //
                for(var i:uint = 0; i < BALL_CNT; i ++){
                    //基本描画
                    var bd03:BitmapData = new BitmapData(sp01.width, sp01.height, true, 0x00000000);
                    bd03.draw(sp01);
                    var bm03:Bitmap = new Bitmap(bd03);
                    bm03.x = - bm03.width * 0.5
                    bm03.y = - bm03.height * 0.5;
                    //エフェクト描画  
                    var bd04:BitmapData = bd03.clone();
                    bd04.colorTransform(bd04.rect, new ColorTransform(1.5, 0, 0.5) );
                    var bm04:Bitmap = new Bitmap(bd04);
                    bm04.x = - bm04.width * 0.5
                    bm04.y = - bm04.height * 0.5;
                    bm04.filters = [new BlurFilter(10, 10)];
                    bm04.blendMode = "add";
                    //bitmap格納用
                    var sp05:Sprite = new Sprite();
                    sp05.addChild(bm03);
                    sp05.addChild(bm04);
                    //初期位置
                    sp05.x = Math.cos(360 / nCnt * i * Math.PI / 180) * 100;
                    sp05.y = 0;
                    sp05.z = Math.sin(360 / nCnt * i * Math.PI / 180) * 100;
                    //配列に格納
                    ar02.push(sp05);
                }
            }
             
            //全体格納用
            var sp06:Sprite = new Sprite();
            addChild(sp06);
            var ar01:Array = xCreateBall(BALL_CNT);
            for(var k:uint = 0; k < BALL_CNT; k ++){
                sp06.addChild(ar02[k]);
            }
            //
            var nX:Number = stage.stageWidth * 0.5;
            var nY:Number = stage.stageHeight * 0.5;
            sp06.x = nX;// - sp06.width * 0.5;
            sp06.y = nY;// - sp06.height * 0.5;
            //フレーム監視開始
            addEventListener(Event.ENTER_FRAME, xFrame);
            //test
            var g:Graphics = sp06.graphics;
            g.beginFill(0xffffff);
            g.drawRect(0, 0, 100, 100);
            g.endFill();
            sp06.addChild(sp01);
            //sp06.rotationX = 30;
            //test
            var tex01:TextField = new TextField();
            tex01.textColor = 0xffffff;
            tex01.text = "a";
            addChild(tex01);
            //円運動
            var nDeg:Number = 5;
            function xFrame(e:Event):void{
            //全体
                var ry:Number = (mouseX - nX) / (nX * 2) * 10;
                var rz:Number = (mouseY - nY) / (nY * 2) * 10;
                //sp06.rotationX += ry;
                //sp06.rotationY += ry;
                //sp06.rotationZ += rz;
            //玉個別
                //座標変換
                var mtr01:Matrix3D = new Matrix3D();
                //x軸で回転
                mtr01.prependRotation(ry, Vector3D.X_AXIS);
                //y軸で回転
                mtr01.prependRotation(nDeg, Vector3D.Y_AXIS);
                //z軸で回転
                mtr01.prependRotation(rz, Vector3D.Z_AXIS);
                
                for(var j:uint = 0; j < BALL_CNT; j ++){
                    //座標取得
                    var vec01:Vector3D = new Vector3D(ar02[j].x, ar02[j].y, ar02[j].z);
                    //変換の適用
                    vec01 = mtr01.transformVector(vec01);
                    //座標更新
                    ar02[j].x = vec01.x;
                    ar02[j].y = vec01.y;
                    ar02[j].z = vec01.z;
                }
                //重ね順
                ar02.sort(xComp);
                for(var k:uint = 0; k < BALL_CNT; k ++){
                    sp06.setChildIndex(ar02[k], k);
                }
            }
            //z深度比較
            function xComp(a:Sprite, b:Sprite):Number{
                var nA:Number = a.z;
                var nB:Number = b.z;
                if(nA < nB){
                    return 1;
                }else if(nA > nB){
                    return -1;
                }else{
                    return 0;
                }
            }
        }
    }
}
