/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bjW5
 */

/*
マインスイーパー作ろうとしたら，
ドット絵描くアプリができた．
これでピクロス作れそう．
*/

package {
	import flash.display.Sprite;
	public class FlashTest extends Sprite {
		public function FlashTest() {
			Wonderfl.disable_capture();

			var cell:MineCell;
			for(var i:uint=0;i<20;i++){
				for(var j:uint=0;j<20;j++){
					cell = new MineCell(j,i,false);
					addChild(cell);
					cell.x = j*18+40
					cell.y = i*18+40;
				}
			}
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

class MineCell extends Sprite{
	public var mine:Boolean;
	public var sweep:Boolean = false;
	public var colmn:uint;
	public var row:uint;
	
	public function MineCell(colmn:uint,row:uint,mine:Boolean):void{
		this.colmn = colmn;
		this.row = row;
		this.mine = mine;
		cellIcon("rollOut");
		this.addEventListener(MouseEvent.ROLL_OVER,mouseFunction);
		this.addEventListener(MouseEvent.ROLL_OUT,mouseFunction);
		this.addEventListener(MouseEvent.MOUSE_DOWN,mouseFunction);
		this.addEventListener(MouseEvent.MOUSE_UP,mouseFunction);
	}
	public function mouseFunction(event:MouseEvent):void{
		if(event.type == "mouseUp") sweep = (sweep ? false : true);
		parent.addChild(this);
		cellIcon(event.type);
	}
	private function cellIcon(type:String):void{
		var colorA:uint = 0x666666;
		var colorB:uint = (sweep ? 0xaaaaaa : 0xffffff);
		this.graphics.clear();
		switch(type){
			case MouseEvent.MOUSE_DOWN:
				colorB = 0x99ffff;
			case MouseEvent.MOUSE_UP:
			case MouseEvent.ROLL_OVER: 
				colorA = 0x44dddd;
			break;
			//case MouseEvent.ROLL_OUT: break;
		}
		this.graphics.lineStyle(1.3, colorA);
		this.graphics.beginFill(colorB);
		this.graphics.drawRect(0,0,18,18);
		this.graphics.endFill();
	}
}