/**
 * Copyright mameshiba ( http://wonderfl.net/user/mameshiba )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bjW0
 */

// forked from tommysalo's Ghost4Koin
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.geom.Rectangle;
    import flash.media.*;
    import flash.text.TextField;
    
    
    /**
     * This is our (Team Isotop Team) entry in the 4k-
         * competition held at gamepoetry
     * @author Tommislav
     */
        [SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="60")] 
    public class Main extends Sprite 
    {
        public var frame:uint;
        public var run:*;    // Game is running
        public var score:int;
        
        public var part:Array = [];
        
        public var t:int;
        
        // cameraX, cameraY (Numbers)
        public var camX:* = 0;
        public var camY:* = 0;
        
        // mapX, mapY
        public var mx:int;
        public var my:int;
        
        public var s:*;
        
        // keyDown
        public var ku:Boolean;
        public var kl:Boolean;
        public var kr:Boolean;
        
        // Player variables
        public var plX:* = 138;
        public var plY:* = 52;
        public var spdX:* = 0;
        public var spdY:* = 0;
        public var pow:*;
        public var dir:int = 1;
        
        public var txt:*;
        
        public var map:BitmapData;
        public var bd:BitmapData;
        
        
        // Sounds
        public var snd:*;
        public var sndType:*;
        
        
        public final function Main():*
        {
            init();
        }
        
        public final function init():*
        {
            stage.scaleMode = "noScale";
            
            run = false;
            map = new BitmapData( 160, 100, true, 0xaa999999 );
            bd = new BitmapData( 240, 176, true, 0xff00cc00 );
            
            
            var b:* = new Bitmap( bd );
            b.scaleX = b.scaleY = 2;
            addChild( b );
            
            b = new Bitmap( map );
            addChild( b );
            b.x = 306;
            
            s = new Sprite();
            s.graphics.lineStyle( 1, 0 );
            s.graphics.drawRect( 0, 0, 15, 11 );
            addChild( s );
            
            txt = new TextField();
            txt.width = 250;
            txt.height = 100;
            addChild(txt);
            
            addEventListener( "enterFrame", ef );
            stage.addEventListener( "keyDown", key );
            stage.addEventListener( "keyUp", key );
            
            snd = new Sound();
            snd.addEventListener('sampleData', gds);
        }
        
        public function start():* {
            var i:int, j:int, k:int, l:int, m:int;
            
            txt.x = 0;
            txt.y = 0;
            frame = 0;
            s.x = 482;
            s.y = 0;
            camX = 0;
            camY = 0;
            plX = 48;
            plY = 64;
            pow = 60;
            spdX = 0;
            spdY = 0;
            dir = 1;
            score = 0;
            part = [];
            
            map.fillRect( new Rectangle( 0, 0, 160, 100 ), 0x99999999 );
            
            // Build level
            for ( i = 0; i < 400; i++ ) {            // Number of platforms
                j = int( Math.random() * 160 );        // x
                k = int( Math.random() * 95 ) + 5;    // y (start at 5 as lowest)
                l = int( Math.random() * 12 );    // platform length
                
                if ( i == 0 )    // build start platform
                {
                    j = 2;
                    k = 5;
                    l = 5;
                }
                
                for ( m = 0; m < l; m++ )
                {
                    map.setPixel( j + m, k, 0 );
                    if ( Math.random() < 0.6 )
                        map.setPixel( j + m, k + 1, 0 );
                }
                j = int( Math.random() * 160 );    // x
                k = int( Math.random() * 100 );    // y
                if ( i % 3 == 0 && map.getPixel(j,k) == 0x999999 )    // dont place gold on top of solid ground
                    map.setPixel( j, k, 0xffff00 );    // Draw coin
            }
            run = true;
            
            sndType = 1;
            snd.play();
        }
        
        public final function key(e:*):*
        {
            // keyDown, keyUp
            if (e.keyCode == 38) {
                ku = ( e.type == "keyDown" );
            }
            
            if (e.keyCode == 37) {
                kl = ( e.type == "keyDown" );
            }
            if (e.keyCode == 39) {
                kr = ( e.type == "keyDown" );
            }
            
            if ( e.keyCode == 13 )
            {
                if ( !run )
                    start();
            }
        }
        
        public final function ef( e:* ):*
        {
            var i:int, j:int, k:int, l:int, m:int, p0:int, p1:int, p2:int, p3:int, t:int, colA:int;
            
            frame++;
            var a:* = ("0000000055555555aaaaaaaaffffffffffffffffaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa9aa19aa14a604a60051005100004000410051005,ff700000f3055555f49aaaaa39ffffff3dffffff1efaaaaa0eaaaaaa0aaaaaaa0aaaaaaa0aaaaaaa0aaaaaaa06aa9aa106824a6001010510040000043c101005,064506458515851585108510851a851a15851585158515855065506550655065064506458515851585108510851a851a15851585158515855065506550655065,f100004f1455551449aaaa614effffb14ffffff14fbaaef14baaaae14aaaaaa14aaaaaa14aaaaaa14aaaaaa146aaaa91468aa29141055041040000103c10043c,5500045551eff24558ffff255cffff355cffffb41fff33b41fff33f41fff33f41ffffff41efff3f41ecf38f410effff41efffff41fffeff41ef28ff450041005,55500455550ef24551efff2551ffff3558ffffc45cffffc45cfcffc45cf3fff45cf3fff458f8ff34580ef3845cfffff41efffff48fffeff4cfb0efb400050005,5555555555100455518ff25558ffff451effff451fffb335cfff3334cfffb332cfefff338fcff3331ecf383210ffff2551fffb4551fff35551eff25555000455,55100555518fb05558fffb4510ffff048fffcc23cfffcc33cfffcc338fffff321efffc345cff0e355cffffb45cfffff41efffff48fffeff4cfb0efb400050005,555555555555555555500555551aa455558ff25551effb4551e3eb4551e3eb4551e3eb4551e3cb4551effb45558ff255551aa455555005555555555555555555,555555555555555555100555550aa455550ff455518ff2555183e2555183e2555183e2555183c255518ff255550ff455550aa455551005555555555555555555,5555555555555555555005555510a4555510f4555508f255550882555508825555088255550802555508f2555510f4555510a455555005555555555555555555,45100451118ae34450f00b051c00002413055084834551c38044110380441102c0055002c0000002820550c3120410c41c00002450f00a05118af34445100451,208151520002818006a2818002020080060200800802818020028181598589895528189859081818520818069028108528181006200028285528182855281818,08908000602069066028590660a069066062890660a0890608206906a69a5526555555559a656994108180a0060280800602800006028020060280a010898162").split(",");
            var dmg:int = 0;    // check if hit by mine
            
            pow-= 0.1;
            
            // Check keys and update speed and player position
            if ( ku )
            {
                spdY -= 1.2;
                pow-= 0.6;
            }
            
            if ( pow <= 0 && run )
            {
                run = false;
                sndType = 4;
                snd.play();
            }
            
            if ( kl )    spdX -= 1.2;
            if ( kr )    spdX += 1.2;
            
            if ( spdX < -9 )    spdX = -9;
            if ( spdX > 9 )        spdX = 9;
            if ( spdY < -9 )    spdY = -9;
            if ( spdY > 9 )        spdY = 9;
            
            if (!ku)        spdY += 1;
            if (!kl && !kr)    spdX *= 0.5;
            
            if ( Math.abs(spdY) < 0.5 )    spdY = 0;
            if ( Math.abs(spdX) < 1 )    spdX = 0;
            
            if ( !run )
            {
                spdX = 0;
                spdY = 0;
            }
            
            
            // Update player position and perform collision detection
            if ( spdX > 0 )
                dir = 1;
            else if ( spdX < 0 )
                dir = -1;
            
            plX += spdX;
            plY += spdY;
            
            // i = x front, j = x back, k = push back
            i = ( dir == 1 ) ? 15 : 0;
            j = ( dir == 1 ) ? 3 : 12;
            k = ( dir == 1 ) ? -15 : 15;
            
            
            
            // Check if collision with coin
            p0 = Math.floor( (plX + 8) / 16 );
            p1 = Math.floor( (plY+8) / 16 );
            if ( map.getPixel( p0, p1 ) == 0xffff00 )
            {
                // Found a coin
                sndType = 3;
                snd.play();
                map.setPixel( p0, p1, 0x999999 );
                pow += 15;
                score++;
                for ( l = 0; l < 10; l++ )
                {
                    part.push( { x:p0 * 16 , y:p1 * 16, sx:Math.random() * 30 - 15, sy:Math.random() * 10 - 5, col:0xbab800, cnt:8 } );
                }

            }
            
            if ( map.getPixel( p0, p1 ) == 0xff0000 )
            {
                map.setPixel( p0, p1, 0x999999 );
                pow -= 15;
                dmg = 1;
                // Explosion
                for ( l = 0; l < 30; l++ )
                {
                    part.push( { x:p0 * 16 , y:p1 * 16, sx:Math.random() * 30 - 15, sy:Math.random() * 30 - 15, col:0, cnt:16 } );
                }
                
                sndType = 4;
                snd.play();
            }
            
            
            
            // Check every corner of the sprite, if 0 then we are inside something solid
            p0 = map.getPixel( Math.floor( (plX+i) / 16 ), Math.floor( plY / 16 ) );        // front head
            p1 = map.getPixel( Math.floor( (plX+i) / 16 ), Math.floor( (plY+15) / 16 ) );    // front foot
            p2 = map.getPixel( Math.floor( (plX+j) / 16 ), Math.floor( plY / 16 ) );        // back head
            p3 = map.getPixel( Math.floor( (plX+j) / 16 ), Math.floor( (plY+15) / 16 ) );    // back foot
            
            
            if ( spdY < 0 )
            {
                // Jumping, check head
                if ( p2 == 0 )
                {
                    plY = Math.floor( plY / 16 ) * 16 + 16;
                    spdY = 0;
                }
                
                if ( p1 == 0 )
                {
                    plX = Math.floor( (plX+i) / 16 ) * 16 + k// move back
                    spdX = 0;
                }
                
                if ( p0 == 0 && ( p2 != 0 && p1 != 0 ) )
                {
                    // ouch, down or back?!?
                    if ( spdY >= 0 || ((plY) % 16) < 11 )
                    {
                        plX = Math.floor( ( plX ) / 16 ) * 16 + j// move back
                        spdX = 0;
                    }
                    else
                    {
                        plY = Math.floor( (plY + 15) / 16 ) * 16// move down
                        spdY = 0;
                    }
                }
                
                // Jumping / pooping :)
                if ( spdY < -3 )
                {
                    part.push( { x:plX + Math.random() * 12 + 4 , y:plY + 15, sx:Math.random() * 4 - 2 + spdX * 0.5, sy:Math.random() * 4 + 1, col:0x6316128, cnt:4 } );
                }
            }
            else
            {
                if ( p0 == 0 )
                {
                    plX = Math.floor( (plX+i) / 16 ) * 16 + k// move back
                    spdX = 0;
                }
                
                if ( p3 == 0 )
                {
                    plY = Math.floor( (plY + 15) / 16 ) * 16 - 16// move up
                    spdY = 0;
                }
                
                if ( p1 == 0 && ( p0 != 0 && p3 != 0) )
                {
                    // ouch, up or back?!?
                    if ( spdY == 0 || ((plY + 15) % 16) > 8 )
                    {
                        plX = Math.floor( ( plX ) / 16 ) * 16 + j// move back
                        spdX = 0;
                    }
                    else
                    {
                        plY = Math.floor( (plY + 15) / 16 ) * 16 - 16// move up
                        spdY = 0;
                    }
                }
            }
            
            
            // Update camera pos from player pos - with smoothing
            camX = camX + (((plX - 136) - camX) * 0.3);
            camY = camY + (((plY - 88) - camY ) * 0.3);
            
            if ( camX < 0 )         camX = 0;
            if ( camX > 2320 )        camX = 2320;
            if ( camY < 0 )            camY = 0;
            if ( camY > 1424 )        camY = 1424;
            
            // Update map position
            mx = Math.floor( camX / 16 );
            my = Math.floor( camY / 16 );
            
            // Position the rectangle in the mini-map
            s.x = 306+mx;
            s.y = my;
            
            
            txt.text = "ENERGY: " + int(pow) + "\nSCORE: " + score;
            
            
            // Render bitmap
            bd.lock();
            if ( run )
                if ( !dmg )
                    bd.fillRect( new Rectangle( 0, 0, 240, 176 ), 0xffffffff );
                else
                    bd.fillRect( new Rectangle( 0, 0, 240, 176 ), 0xffff0000 );
            else
            {
                
                bd.fillRect( new Rectangle( 0, 0, 240, 176 ), 0xfff00000 );
                txt.x = 180;
                txt.y = 145;
                frame--;
                txt.text = "       FINAL SCORE: " + score + "\nPRESS ENTER TO START";
                if ( frame == 0 )
                    txt.text = "PRESS ENTER TO START\n\nCollect coins to gain energy.\nFlying requires more energy so\n              take it easy !";
                
            }
            var bol:* = false;
            
            for ( i = 0; i < 12; i++ ) {
                for ( j = 0; j < 16; j++ ) {
                    
                    p0 = map.getPixel( mx + j, my + i );
                    bol = false;
                    if ( p0 != 0x999999 )
                    {
                        if ( run )
                            colA = 0;
                        else
                            colA = 4;
                        p1 = map.getPixel( mx + j, my + i - 1 );
                        if ( p0 == 0xffff00 )    // found a gold coin
                        {
                            var coin:*= [8, 9, 10, 10, 9];
                            t = coin[frame % 4];
                            if ( frame % 4 > 2 ) bol = true;
                            colA = 8;
                        }
                        else if ( p0 == 0xff0000 )    // found a mine
                        {
                            t = 11;
                            colA = (frame % 2 == 0) ? 12 : 16;
                        } 
                        else if ( p1 == 0 )
                        {
                            t = 2;
                        }
                        else
                        {
                            p2 = map.getPixel( mx + j - 1, my + i );
                            p3 = map.getPixel( mx + j + 1, my + i );
                            if ( p2 == 0 && p3 == 0 )
                            {
                                t = 0;
                            }
                            else if ( p2 != 0 && p3 != 0 )
                            {
                                t = 3;
                            }
                            else
                            {
                                if ( p2 )
                                    t = 1;
                                else
                                {
                                    t = 1;
                                    bol = true;
                                }
                            }
                        }
                        
                        drawTo( j * 16 - camX % 16, i * 16 - camY % 16, a[t], colA, bol );
                    }
                }
            }
            
            // Render particles
            var p:*;
            for ( i = 0; i < part.length; i++ )
            {
                p = part[i];
                bd.setPixel( p.x - camX, p.y - camY, p.col );
                p.x += p.sx;
                p.y += p.sy;
                p.sx *= 0.7;
                p.sy *= 0.7;
                if ( p.cnt-- == 0 )
                    part.splice( i, 1 );
            }
            
            
            // Render player (frame depending on speed)
            if ( spdY == 0 && spdX == 0 )
            {
                t = 4;
            }
            else
            {
                if ( spdY < 0 )
                    t = 7;
                else if ( spdY > 0 )
                {
                    t = 6;
                }
                else
                {
                    t = frame % 4 + 5;
                    if (t == 8) t = 6;
                }
            }
            
            drawTo( int(plX - camX), int(plY - camY), a[t], 20, (dir < 0) );
            
            // Spawn objects, coins or mines
            if ( run )
            {
                if ( frame % 100 == 0 )
                {
                    j = int( Math.random() * 160 );    // x
                    k = int( Math.random() * 100 );    // y
                    if ( map.getPixel(j,k) == 0x999999 )    // dont place gold on top of solid ground
                        map.setPixel( j, k, 0xffff00 );    // Draw coin
                }
                
                if ( frame > 450 && frame % 6 == 0 )
                {
                    j = int( Math.random() * 160 );    // x
                    k = int( Math.random() * 100 );    // y
                    map.setPixel( j, k, 0xff0000 );    // Mines go everywhere - even inside solid ground
                }
            }
            else
            {
                drawTo( 100, 52, a[12], 8, false );
                drawTo( 116, 52, a[13], 8, false );
            }
            
            bd.unlock();
            
        }
        
        
        
        
        
        public final function drawTo( x:int, y:int, str:*, ca:int, inv:* ):void
        {
            var n:int, o:int, q:int, col:int, px:int, py:int;
            
            var colors:* = [0xff000000, 0xff606060, 0xffb0b0b0, 0xffffffff,0xff000000, 0xffFEB0B1, 0xffcc0000, 0, 0xff3e4000, 0, 0xffaba000, 0xfffff568, 0xff000000, 0, 0xff000000 , 0xffff0000, 0xff000000, 0, 0xffff0000 , 0xff000000, 0xff000000, 0, 0xffb0b0b0, 0xffffffff];
            
            if ( !run )
                colors[ca] = Math.random() * 0xffffffff;
                
            for ( n = 0; n < 128; n++ )
            {
                for ( o = 0; o < 2; o++ ) {
                    q = ( n*2 + o );
                    col = colors[ ca + ( uint("0x"+str.charAt( n )) >> (o*2) & 0x3 ) ];
                    
                    if ( col != 0 )
                    {
                        if ( !inv )
                        {
                            px = q % 16;
                        }
                        else
                        {
                            px = 15 - (q%16);
                        }
                        bd.setPixel32( x + px, y + (Math.floor( q / 16 )), col );
                    }
                }
            }
            
        }
        
        
        
        public final function gds(e:*):* {//generate dynamic sound
            // where, in time, the sound begins and ends, this affects the where on the sine curve the sound will start playing.
            var i:int;
            var beginAt:int = 100; 
            var endAt:int = 5000;
            var hz:* = 44.1;
            var r:* = (e.position / hz) + beginAt;
            var pitch:int = 1000;
            var flt:* = 0;
            var L:int = 8001;
            var f:*;
            /*
                The minimum is 512, but causes processor hit, maximum 8192 faster to process.
            */
            for (i = 0; i < 4096; i++) {
                if(sndType == 1){
                    //evt.data.writeFloat(eq5(i, evt, 1, r / brighten));
                    beginAt = 100;
                    endAt = 2000
                    pitch = 1000
                    r = (e.position / hz) + beginAt;
                    
                    if (r < endAt) {
                        //trace(e.position / hz);
                        f = (e.position / hz) + L / 2//time elapsed + 300 to offset the sound
                        flt = Math.sin((Number(i) / Math.PI / (1 - (r / pitch)) / 15)) * 40000;
                    }
                }
                if (sndType == 2) {
                    //beginAt = 100; 
                    //endAt = 5000;
                    //r = (e.position / hz) + beginAt;
                    //if (r < endAt) {
                        //trace(e.position / hz);
                        //f = (e.position / hz) + L/2//time elapsed + 300 to offset the sound
                        //flt = Math.tan((Number(i) / Math.PI / (1 - (r / pitch)) / 20)) * 15;
                    //}
                }
                if (sndType == 3) {
                    //pitch = 1000
                    beginAt = 850;
                    endAt =920;
                    hz = 44.1;
                    L = 1000;
                    pitch = 1000
                    //acc += 60;
                    r = (e.position / hz) + beginAt;
                    
                    //trace(e.position);
                    if (r < endAt) {
                        //trace(r);
                        f = (e.position / hz) + L/2//time elapsed + 300 to offset the sound
                        flt = Math.tan(Number(i) / Math.PI / (1 - (r / pitch)) / 80) * 40000;
                    }
                }
                if (sndType == 4) {
                    
                //pitch = 1000
                    beginAt = 500;
                    endAt =920;
                    hz = 44.1;
                    L = 1000;
                    pitch = 1000
                    //acc += 60;
                    r = (e.position / hz) + beginAt;
                    
                    //trace(e.position);
                    if (r < endAt) {
                        //trace(r);
                        f = (e.position / hz) + L/2//time elapsed + 300 to offset the sound
                        flt = Math.tan(Number(i) / Math.PI / (0 - (r / pitch)) / 80) * 40000;
                    }
                }
                
                
                if ( r <= endAt )
                {
                    e.data.writeFloat(flt);
                }
                
            }
        }
    }
    
}