/**
 * Copyright designquest ( http://wonderfl.net/user/designquest )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bjJQ
 */

/******************************
*  My Alternativa3D Study Roadmap
*  by Michael Chau (michael@designquest.com.hk)
*  http://www.designquest.com.hk/_experiments/alternativa3d/
*
*  create a GeoSphere? 
*
*  forked from designquest's Create one piece Polygonal Geometry 
*  forked from designquest's Create Polygonal Geometry 
*  Original code from : http://docs.alternativaplatform.com/display/TDEN/Building+geometry
*
*******************************/
package {
    import alternativ5.engine3d.controllers.*;
    import alternativ5.engine3d.core.*;
    import alternativ5.engine3d.display.*;
    import alternativ5.engine3d.materials.*;
    import alternativ5.engine3d.primitives.*;
    import alternativ5.types.*;
    import alternativ5.utils.*;
	import alternativ5.utils.FPS;
	
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;

	[SWF(backgroundColor="#000000", frameRate="100")]

	public class GeometryTutorial extends Sprite {

		private var scene:Scene3D;
		private var view:View;
		private var camera:Camera3D;
		private var cameraController:CameraController;
		private var sphere:GeoSphere;

		public function GeometryTutorial() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		public function init(e:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			// Create scene
			scene = new Scene3D();
			scene.root = new Object3D();

                        // Create sphere
                        sphere = new GeoSphere(100, 3);
                        sphere.cloneMaterialToAllSurfaces(new WireMaterial(1, 0xFFFFFF));
			scene.root.addChild(sphere);
			
			// Add camera and view
			camera = new Camera3D();
			camera.x = 130;
			camera.y = -90;
			camera.z = 130;
			scene.root.addChild(camera);
			
			view = new View();
			addChild(view);
			view.camera = camera;

			// Add camera controller
			cameraController = new CameraController(stage);
			cameraController.camera = camera;
			cameraController.lookAt(sphere.coords);
			cameraController.setDefaultBindings();
			cameraController.checkCollisions = true;
			cameraController.collisionRadius = 20;
			cameraController.speed = 200;
			cameraController.controlsEnabled = true;
			
			// FPS counter init
			FPS.init(stage);

			stage.addEventListener(Event.RESIZE, onResize);
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
			onResize(null);
		}

		private function onResize(e:Event):void {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}
		
		private function onEnterFrame(e:Event):void {
                        // Rotation
                        sphere.rotationZ += 0.01;
			// User input processing
			cameraController.processInput();
			// Scene calculation
			scene.calculate();
		}
	}
}