/**
 * Copyright hycro ( http://wonderfl.net/user/hycro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bjGQ
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.ui.Mouse;
    import flash.ui.MouseCursor;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
    public class Sketch_20110212 extends Sprite
    {
        private const _Density:Number = 0.3;
        private const _Text:String = "TEXTURE";
        
        private var _bgWidth:uint;
        private var _bgHeight:uint;
        private var _bgd:BitmapData;
        private var _fgd:BitmapData;
        private var _bg:Bitmap;
        private var _fg:Bitmap;
        private var _tf:TextField;
        private var _scrollFlag:Boolean;
        
        public function Sketch_20110212()
        {
            init();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(Event.RESIZE, stageResizeHandler);
            stage.addEventListener(MouseEvent.CLICK, stageClickHandler);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            Mouse.cursor = MouseCursor.BUTTON;
        }
        
        private function init():void
        {
            _bgWidth = stage.stageWidth;
            _bgHeight = stage.stageHeight;
            if (_bgd) _bgd.dispose();
            if (_fgd) _fgd.dispose();
            _bgd = new BitmapData(_bgWidth, _bgHeight, false, 0xFFFFFF);
            _fgd = new BitmapData(_bgWidth, _bgHeight, true, 0x00FFFFFF);
            if (_bg && contains(_bg)) removeChild(_bg);
            if (_fg && contains(_fg)) removeChild(_fg);
            _bg = new Bitmap(_bgd);
            _fg = new Bitmap(_fgd);
            addChild(_bg);
            addChild(_fg);
            
            _tf = new TextField();
            _tf.text = _Text;
            _tf.autoSize = TextFieldAutoSize.LEFT;
            _tf.setTextFormat(new TextFormat(null, 82, 0xFF000000));
            
            _scrollFlag = false;
            
            createTexture();
        }
        
        private function createTexture():void
        {
            _bgd.fillRect(_bgd.rect, 0xFFFFFF);
            _fgd.fillRect(_fgd.rect, 0x00FFFFFF);
            
            var matrix:Matrix = new Matrix();
            matrix.translate((_bgWidth-_tf.width)/2, (_bgHeight-_tf.height)/2);
            _fgd.draw(_tf, matrix);
            
            for (var i:uint = 0; i < _bgWidth; i++) {
                for (var j:uint = 0; j < _bgHeight; j++) {
                    var b:Boolean = (Math.random() < _Density);
                    if (b) {
                        _bgd.setPixel(i, j, 0x000000);
                    } else if (_fgd.getPixel(i, j) == 0x000000) {
                        _fgd.setPixel(i, j, 0xFFFFFF);
                    }
                }
            }
        }
        
        private function enterFrameHandler(evt:Event):void
        {
            if (_scrollFlag) {
                var tmp:BitmapData = new BitmapData(_bgd.width, 1);
                tmp.copyPixels(_bgd, new Rectangle(0, _bgd.height-1, _bgd.width, 1), new Point);
                _bgd.scroll(0, 1);
                _bgd.copyPixels(tmp, tmp.rect, new Point);
            }
        }
        
        private function stageClickHandler(evt:MouseEvent):void
        {
            _scrollFlag = !_scrollFlag;
        }
        
        private function stageResizeHandler(evt:Event):void
        {
            init();
        }
    }
}