/**
 * Copyright misinoe ( http://wonderfl.net/user/misinoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bhTg
 */

/*
* MouseMove等のイベントで取得できるポイントから中間のポイントを補間する仕組みについて思いついた事のスクラッチです
*
*/
package {
    import flash.text.TextField;
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        // 数学的定数
        static private var DEG_TO_RAD:Number = ( Math.PI * 2 ) / 360;    // 角度をラジアンに
        static private var RAD_TO_DEG:Number = 360 / ( Math.PI / 2 );    // ラジアンを角度に
        static private var HALF_RAD:Number = 1.0*Math.PI;    // 水平方向のラジアン角度
        static private var FULL_RAD:Number = 2.0*Math.PI;    // 一回転のラジアン角度 
        // 定数
        static private var ACUTE_RAD:Number = Math.PI * 1.0;    // 鋭角の判定
        static private var TURN_SPEED_RAD:Number = Math.PI / 30;    // 1セパレート毎に線の方向を変更するRAD角度
        static private var SPEED:Number = 1.0;    // 最大でこの距離pixel毎に区切り、TURN_SPEEDの値に従って徐々に線の移動方向を回頭させますE
        // 二つのポイントから角度を求める関数
        static private function getAngle( from:Point, to:Point ):Number{
            return Math.atan2( to.y-from.y, to.x-from.x );
        }

        
        
        private var strokes:Array/*of Point*/ = [];    // ストロークのPoint配列
        private var logText:TextField;
        
        
        // コンストラクタ
        public function FlashTest() {
            // write as3 code here..
            addChild( logText = new TextField() );
            logText.width = 200;
            logText.height = 600;
            logText.border = true;
            
            
            strokes = [ new Point(200,100), new Point(350,100), new Point( 350,350 ), new Point( 300, 350), new Point(200,100 ) ];
            draw();
            
        }
        // デバッグ用のログにテキストを追加
        public function debugLog( ...args ):void{
            logText.text = args+ "\n"+ logText.text;
        }

        
        // stroke配列の内容を描画します
        public function draw():void{
            graphics.clear();
            graphics.lineStyle( 1 );
            
            // 
            var point:Point;    // 今回のポイント
            var lastPoint:Point;    // 直前のポイント
            var distance:Number;    // 直前のポイントとの距離
            var separatedCount:int;    // 分割した数
            var currentPosition:Point;    // 分割した上での現在の位置
            var currentTurnRad:Number;    // 直前のポイントから現在のポイントから向いたcurrentPositionの向き
            
            
            // 始点処理
            point = strokes[0];
            graphics.moveTo( point.x, point.y );
            
            // 始点から次に続くデータの初期値
            lastPoint = point;
            currentPosition = point.clone();
            currentTurnRad = getAngle( point, strokes[1] );
            

            // ２点目以降の処理
            for( var i:int=1,len:int=strokes.length; i<len; i++ ){
                
                point = strokes[i];
                distance = Point.distance( point, lastPoint );
                separatedCount = (distance/SPEED<<0) - 1;    // 分割する数を計算
                
                
                debugLog( "count",separatedCount,point );
                
                // 鈍角の補正描画
                if( getAngle( lastPoint, point ) < ACUTE_RAD ){
                    // 分割した線
                    for( var l:int=0;l<separatedCount;l++ ){
                        
                        // 方向を変更、回頭
                        var angleRad:Number = getAngle( currentPosition, point );
                        if( currentTurnRad - HALF_RAD > angleRad ) angleRad += FULL_RAD;
                        if( currentTurnRad + HALF_RAD < angleRad ) angleRad -= FULL_RAD;
                        if( currentTurnRad - angleRad > TURN_SPEED_RAD ) currentTurnRad -= TURN_SPEED_RAD;
                        else if( currentTurnRad - angleRad < -TURN_SPEED_RAD ) currentTurnRad += TURN_SPEED_RAD;
                        else{
                            // 角度の変更が敷居以下になった場合はこのループを中断し、次のポイントに線分を描画し終了する
                            currentTurnRad = angleRad;
                            currentPosition = point.clone();
                            graphics.lineTo( point.x, point.y );
                            break;
                        }
    
                        
                        debugLog( currentPosition, point, currentTurnRad );
                        
                        // 移動
                        currentPosition.x += Math.cos( currentTurnRad ) * SPEED;
                        currentPosition.y += Math.sin( currentTurnRad ) * SPEED;
                        
                        // 線分を描画
                        graphics.lineStyle( 0, Math.random()*0xFFFFFF );
                        graphics.lineTo( currentPosition.x, currentPosition.y );
                        
                    }
                }else{
                    // 鋭角の描画
                    graphics.lineTo( point.x, point.y );
                    currentTurnRad = getAngle( lastPoint, point );
                    currentPosition = point.clone();
                    
                }

                
                
                
                lastPoint = point;    // 
            }

        }

    }
}