/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bgri
 */

package {
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var canvas:Bitmap;
        
        private var field:Array = [];
        private var rows:Array = [];
        
        private var freeBlock:Sprite = new Sprite();
        private var conectBlock:Sprite = new Sprite();
        
        private var timeUpdate:Timer = new Timer(50);
        
        public function FlashTest() {
            // write as3 code here..
            // Так ну окей, еще нужен подсчет очков...
            
            this.graphics.beginFill(0);
            this.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            canvas = new Bitmap( new BitmapData(stage.stageWidth, 
                                        stage.stageHeight, true, 0) );
            canvas.x = 20; canvas.y = 20;
            addChild(canvas);
            freeBlock.graphics.lineStyle(2,0x9EFF30);
            freeBlock.graphics.beginFill(0x2D490E);
            freeBlock.graphics.drawRect(0,0,10,10);
            freeBlock.graphics.endFill();
            freeBlock.graphics.lineStyle();
            freeBlock.graphics.beginFill(0x5A911B);
            freeBlock.graphics.drawRect(3,3,4,4);
            freeBlock.graphics.endFill();
            
            conectBlock.graphics.lineStyle(2,0x9EFF30);
            conectBlock.graphics.beginFill(0x2D490E);
            conectBlock.graphics.drawRect(0,0,10,10);
            conectBlock.graphics.beginFill(0x9EFF30);
            conectBlock.graphics.drawRect(3,3,4,4);
            conectBlock.graphics.endFill();
            
            for(var tx:int=0; tx<42; tx++){
                field.push(new Array());
                for(var ty:int=0; ty<42; ty++){    // 0 - пусто
                    field[tx][ty]=0;                // 1 - падающий блок
                }                                    // 2 - статичный блок
            }
            addEventListener(Event.ENTER_FRAME, redraw);
            timeUpdate.addEventListener(TimerEvent.TIMER, tickGame);
            timeUpdate.start();
            stage.addEventListener(KeyboardEvent.KEY_DOWN, correct);
        }
        // Двигаем все кубики влево или вправо... ** Баг - все кубики перестают двигаться если
        // один упирается в левый или правый край...
        private function correct(e:KeyboardEvent):void {
            if(e.keyCode == Keyboard.LEFT){
                for(var tx:int=0; tx<field.length; tx++){
                    for(var ty:int=field[0].length-1; ty>0; ty--){
                        // Так... и почему они перемещаются в самый левый угол... 
                        // Вероятно.. они проверяются справо-налево... вот и...
                        if(field[tx][ty]==1 && field[tx-1][ty]==0){
                            field[tx][ty]=0;
                            field[tx-1][ty]=1;
                        }
                    }
                }
            } else if(e.keyCode == Keyboard.RIGHT){
                for(var tx:int=field.length-1; tx>=0; tx-- ){
                    for(var ty:int=field[0].length-1; ty>0; ty--){
                        if(field[tx][ty]==1 && field[tx+1][ty]==0){
                            field[tx][ty]=0;
                            field[tx+1][ty]=1;
                        }
                    }
                }
            }
        }
// Шаг игры...
        private var counter:int = 0;
        private function tickGame(e:TimerEvent):void {
            counter++;
            if(counter==10){
                counter=0;
                // добавим блоков...
                var xpos:int = int(Math.random()*42+1);
                field[xpos][1] = 1;
                field[xpos+1][1] = 1;
                // ну окей, я сделал блоки по 2 единички...
            }
// Что за проблема с левым столбцом?
            for(var tx:int=field.length-1; tx>=0; tx--){
                for(var ty:int=field[0].length-1; ty>0; ty--){
                    // тут мы обновим положения... заметьте снизу вверх...
                    // снизу вверх тупо проще потому что нужно только проверить 
                    // нет ли пустого места и если есть, то двинуть вниз...
                    if(field[tx][ty]==1 && field[tx][ty+1]==0){
                        field[tx][ty]=0;
                        field[tx][ty+1]=1;
                    } else if(field[tx][ty]==1 && field[tx][ty+1]!=0){
                        field[tx][ty]=2;
                    }
                }
            }
            // Ну и в каждом шаге нужно проверять Y ряды на заполнение...
            // В каждом ряду 42... кубика...
        }

// Тут у нас банально отрисовка и всякая красотулька..
        private var m:Matrix = new Matrix();
        private var c:ColorTransform = new ColorTransform(0.9,1,1,0.9);
        private function redraw(e:Event):void {
            //canvas.bitmapData.fillRect(canvas.bitmapData.rect,0x1a000000);
            // colorTransform(bit.rect, new ColorTransform(1, 1, 1, 0.96, red, green, blue, 0));
            canvas.bitmapData.colorTransform(canvas.bitmapData.rect, c);
            for(var tx:int=0; tx<field.length; tx++){
                for(var ty:int=0; ty<field[0].length; ty++){
                    m.tx = tx*10;
                    m.ty = ty*10;
                    if(field[tx][ty]==1){
                        canvas.bitmapData.draw(freeBlock, m);
                    } else if(field[tx][ty]==2){
                        canvas.bitmapData.draw(conectBlock, m);
                    }
                }
            }
        }
        
    }
}

Class {
    class Block {
        public static const TYPE_L:String = 'typeL';
        public static const TYPE_T:String = 'typeT';
        public static const TYPE_B:String = 'typeB';
        public static const TYPE_I:String = 'typeI';
        public static const TYPE_Z:String = 'typeZ';
        private static var blocksArray:Array = [TYPE_L, TYPE_T, TYPE_B, TYPE_I, TYPE_Z];
        
    }
}
