/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bggs
 */

// forked from yd_niku's forked from: Stardust Stream
// forked from yd_niku's Stardust Stream
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    import frocessing.display.F5MovieClip2DBmp;
    [SWF(frameRate=60)]
    public class FlashTest extends F5MovieClip2DBmp {
        
        private var _particles:Vector.<Star>;
        public function FlashTest() {
        }
        public function setup():void {
            //キャンバスのサイズ指定
            size( 465, 465 );
            //背景の描画
            background( 0 );
            //HSV
            colorMode( HSV, 1 );
                
            const LEN:int = 7;
            _particles = new Vector.<Star>();
            for( var i:int=0; i<LEN; ++i ) {
                var angle :Number = Math.PI*2*Math.random();
                var radius:Number = 232*Math.random();
                _particles.push( new Star(Math.cos(angle)*radius+232,Math.sin(angle)*radius+232) );
            }
            stage.addEventListener(MouseEvent.MOUSE_DOWN,reset);
        }
        private function reset(e:Event):void{
            
            for each( var p:Star in _particles ){
                var angle :Number = Math.PI*2*Math.random();
                var radius:Number = 232*Math.random();
                p.x = Math.sin(angle)*radius + mouseX;
                p.y = Math.cos(angle)*radius + mouseY;
                p.vx = ( p.x - mouseX )*0.2;
                p.vy = ( p.y - mouseY )*0.2;
            }

        }

        public function draw():void{
            beginFill(0x000066,0.005);
            drawRect(0,0,465,465);
            endFill();
            
            var xx:Number, yy:Number;
            for each( var p:Star in _particles ){
                xx = p.x;
                yy = p.y;
                p.vx += ( mouseX - p.x ) * 0.005 + (Math.random()-0.5)*0.01;
                p.vy += ( mouseY - p.y ) * 0.005 + (Math.random()-0.5)*0.01;
                
                p.x += p.vx*p.mass;
                p.y += p.vy*p.mass;
                
                p.vx *= 0.98; 
                p.vy *= 0.98;
                noFill();
                stroke(random(0.8,0.45),random(0.8,1), 1 );
                drawCircle( p.x, p.y, sqrt(p.vx*p.vx+p.vy*p.vy)*0.22*p.mass );
                
                var angle:Number = random(Math.PI*2,0);
                var radius:Number = random(24,4); 
                var sx:Number = p.x+sin(angle)*radius;
                var sy:Number = p.y+cos(angle)*radius;
                var offset:Number = random(Math.PI);
                
                noStroke();
                beginFill(0xFFFFFF);
                var sradius:Number = random(6,0.2), ssradius:Number, partAngle:Number = Math.PI*2/10;
                
                var ssx:Number, ssy:Number;
                for(var j:int=0; j<10;++j){
                    ssradius = (j%2==0?0.35:1)*sradius;
                    ssx = sx+Math.sin(partAngle*j+offset)*ssradius;
                    ssy = sy+Math.cos(partAngle*j+offset)*ssradius;
                    if(j==0) moveTo( ssx, ssy );
                    lineTo( ssx, ssy ); 
                }
                endFill();
            }
            //scale(1.99,1.99);
            //rotate(-0.1);
            
        }
    }
}

class Star{
    public var x:Number;
    public var y:Number;
    public var vx:Number =0;
    public var vy:Number =0;
    public var mass:Number =0;
    public function Star(sx:Number,sy:Number){
        x = sx;
        y = sy;
        mass = Math.random()*0.8+0.2;
    }
}

