/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bg9E
 */

//
//    SoundVisualizer_piyo
//
//    音はTsabeat より拝借
//    http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
//
//
package 
{
    import flash.display.Loader;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.display.GradientType;
    
    [SWF(width = "465", height = "465")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var sunshinePath:String = "9/9b/9bbe/9bbec77d53bddc5e7a5f2c00abbade6bd641c549";
          
        private var _loader:Loader;
        private var _piyoPath:String = "http://www.project-nya.jp/images/flash/piyo25d.swf";
        private var Piyo:Class;
        
        private var piyos:/*MyPiyo*/Array;
        
        private static var policyPath:String = "http://mutast.heteml.jp/crossdomain.xml";
        private var _path:String = "http://mutast.heteml.jp/works/music/music.mp3";
    
        private var _soundloader:SoundLoader;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();        
            drawSky();
            DrawGround();
            Security.allowDomain("*");
            Security.loadPolicyFile("http://mutast.heteml.jp/crossdomain.xml");
            
            _loader = new Loader();
            _loader.contentLoaderInfo.addEventListener( Event.COMPLETE, Complete, false, 0, true );
            _loader.load( new URLRequest(_piyoPath), new LoaderContext(true) );
            
            
            _soundloader = new SoundLoader();
            _soundloader.Load( _path );

        }
        
        private function Complete(e:Event) : void
        {
            _loader.removeEventListener(Event.COMPLETE, Complete );
            var content:MovieClip = MovieClip(e.target.content);
            Piyo = MovieClip(content.piyo).constructor;
            InitPiyo();
            _loader = null;
            
            addEventListener(Event.ENTER_FRAME, Update);
        }
        
        private function InitPiyo() : void
        {
            piyos = new Array();
            
            for ( var i:int = 0; i < 100; i++ )
            {
                var piyo:MovieClip = new Piyo();
                var mypiyo:MyPiyo = new MyPiyo( (WIDTH / 100) * i, piyo, i%2 == 0 );
                addChild( piyo );
                piyo.scaleX = 0.5;
                piyo.scaleY = 0.5;
                
                piyos.push( mypiyo );
            }
        }
        
        private function Update(e:Event) : void
        {
            var array:Array = _soundloader.GetSpectrumData(true);
            
            
            for ( var i:int = 0; i < piyos.length; i++ )
            {
                piyos[i].Update(array);
            }
        }
        
        private function DrawGround():void
        {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 85, 0.5*Math.PI, 0, 380);
            graphics.beginGradientFill(GradientType.LINEAR, [0x99CC33, 0x7EB133], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 380, 465, 85);
            graphics.endFill();
        }
        
        private function drawSky():void {
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 380, 0.5*Math.PI, 0, 0);
            graphics.beginGradientFill(GradientType.LINEAR, [0x3F68AB, 0x77B2EE], [1, 1], [0, 255], matrix);
            graphics.drawRect(0, 0, 465, 380);
            graphics.endFill();
        }    
    }
    
}


    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;    
    import flash.media.SoundChannel;    
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.display.MovieClip;
    
    class SoundLoader
    {
        private  var _started:Boolean;
        private var sound:Sound;
        private var soundChannel:SoundChannel;
        private var bytes:ByteArray;

        
        public function SoundLoader() 
        {
            _started = false;
        }
        
        public function Load(path:String):void
        {
            sound = new Sound();
            sound.addEventListener( Event.COMPLETE, LoadComplete );
            sound.load( new URLRequest(path), new SoundLoaderContext( 10, true ) );
            
            bytes = new ByteArray();
            _started = false;
        }
        
        private function LoadComplete(e:Event):void
        {
            e.target.removeEventListener( Event.COMPLETE, LoadComplete );
            Start();
        }
        
        private function Start():void
        {
            soundChannel = sound.play( 0, 1000 );
            _started = true;
        }
        
        public    function GetSpectrumData(FFTMode:Boolean = false) : Array
        {
            var i:int;
            var buf:Array = new Array(512);
            if ( !_started )
            {
                for ( i = 0; i < 512; i++ )    buf[i] = 0;
                return    buf;
            }
            
            SoundMixer.computeSpectrum( bytes, FFTMode, 0 );
            bytes.position = 0;
            for ( i = 0; i < 512; i++ )    buf[i] = bytes.readFloat();
            
            return    buf;
        }
        
    }
    


    class MyPiyo
    {
        private static const LANDLINE:Number = Main.HEIGHT-65;
        
        public var piyo:MovieClip;
        
        private var mx:Number;
        private var my:Number;
        private var x:Number;
        private var y:Number;
        
        public function MyPiyo(_x:Number, _piyo:MovieClip, left:Boolean) 
        {
            x = _x;
            y = LANDLINE;
            piyo = _piyo;
            piyo.x = x;
            piyo.y = y;
            
            if ( left )
            {
                mx = -1;
                piyo.rotate( -45);    
            }else
            {
                mx = 1;
                piyo.rotate(45);    
            }
            my = 0;
            
        }
        
        public function Update(power:Array) : void
        {
            
            
            if ( y + my > LANDLINE )
            {
                y = LANDLINE;
                my = 0;
            }else
            if( y < LANDLINE )
            {
                my += 1;
            }
            y += my;
                        
            if ( power != null )
            {
                var pidx:int = int((x / Main.WIDTH) * power.length);
                if ( y == LANDLINE )
                {
                    my = -(int(power[pidx]*10)/10) * 25;
                }
            }
            
            if ( x + mx < 0 )
            {
                x = (x + mx) * -1;
                mx = 1;
                piyo.rotate(45);    
            }else
            if ( x + mx > Main.WIDTH )
            {
                x = Main.WIDTH - ((x + mx) - Main.WIDTH);
                mx = -1;
                piyo.rotate(-45);
            }else
            {
                x += mx;
            }
            
            piyo.x = x;
            piyo.y = y;
        
        }
        
    }
    
