/**
 * Copyright ta1 ( http://wonderfl.net/user/ta1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bg7w
 */

package {
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.events.Event;
    
    public class MytextField extends Sprite {
        public var fld:TextField;
        public var msg:String = "お疲れ様です！";
        public var timer:Timer;
        public var charPos:uint;
        public var counter:uint;
        public var currentMsg:String;
        public var offset:int = Math.floor(5 * Math.random()) +2;
        //コンストラクタ
        public function MytextField() {
            //テキストの書式
            var tf:TextFormat = new TextFormat();
            tf.font = "_sans";
            tf.size = 50;
            tf.color = 0xFF0000;
            tf.align = TextFormatAlign.CENTER;
            //テキストフィールドの作成※改行できる作りに変更する。
            fld = new TextField();
            fld.x = 100;
            fld.y = 150;
            fld.width = 250;
            fld.background = true;
            fld.autoSize = TextFieldAutoSize.CENTER;;
            //テキスト書式の初期値
            fld.defaultTextFormat = tf;
            addChild(fld);  
            //100ミリ秒ごとにtimerイベントを発生
            timer = new Timer(5,fld.length); 
            timer.addEventListener(TimerEvent.TIMER,timehandler);
            timer.start();         
        }
        //１文字ずつ追加
        public function timehandler(e:TimerEvent):void{
            //表示したい文字コードよりoffsetだけ小さい文字コード
            var startCharCode:uint = msg.charCodeAt(charPos) - offset;
            //文字コードを文字に変換
            var char:String = String.fromCharCode(startCharCode + counter);
            //表示済みのテキストに新しい文字と”_”を連結して表示
            fld.text = msg.substring(0,charPos) + char + "_";
            //表示したい文字と比較
            if(msg.charAt(charPos) == char){
                //すべてのメッセージを表示し終わったか確認
                if(charPos == msg.length - 1){
                    //終了
                    timer.stop();
                    fld.text = msg;//文末の”＿”を取り去るためにmsgを入れ直す
                }else{
                    //次に表示する文字に移る
                    offset = Math.floor(5 * Math.random()) + 10;
                    charPos++;
                    counter = 0;
                }
            }else{
                //次の文字コードに進める
                counter++;
            }

            
        }
    }
}



















