/**
 * Copyright wantora ( http://wonderfl.net/user/wantora )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bfrRD
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	
	[SWF(frameRate = "60")]
	
	public class Main extends Sprite {
		private var label:TextField;
		private var analogClock:AnalogClock;
		
		public function Main() {
			label = new TextField();
			label.x = 0;
			label.y = 0;
			addChild(label);
			
			analogClock = new AnalogClock(400, 0x000000, 0xffffff);
			analogClock.x = 30;
			analogClock.y = 30;
			addChild(analogClock);
			
			analogClock.init();
			analogClock.update(new Date());
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(e:Event):void {
			analogClock.update(new Date());
			label.text =  analogClock.getTime().toLocaleTimeString();
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

internal class AnalogClock extends Sprite {
	private var size:Number;
	private var color:uint;
	private var hhand:AnalogHand;
	private var mhand:AnalogHand;
	private var shand:AnalogHand;
	private var bgcolor:uint;
	
	private var time:Date;
	private var oldTime:Date;
	
	public function AnalogClock(size:Number, color:uint, bgcolor:uint) {
		this.size = size;
		this.color = color;
		this.bgcolor = bgcolor;
		
		time = new Date(1970, 1, 1, 0, 0, 0, 0);
		oldTime = time;
		
		hhand = new AnalogHand(color, 6, size * 0.25);
		hhand.x = size / 2;
		hhand.y = size / 2;
		addChild(hhand);
		
		mhand = new AnalogHand(color, 4, size * 0.45);
		mhand.x = size / 2;
		mhand.y = size / 2;
		addChild(mhand);
		
		shand = new AnalogHand(color, 2, size * 0.35, size * 0.125);
		shand.x = size / 2;
		shand.y = size / 2;
		addChild(shand);
		
		graphics.beginFill(bgcolor);
		graphics.lineStyle(2, color);
		graphics.drawCircle(size / 2, size / 2, size / 2);
		
		graphics.beginFill(color);
		graphics.lineStyle();
		graphics.drawCircle(size / 2, size / 2, size * 0.015);
		
		var radius:Number = size / 2;
		for (var i:int = 0; i < 12 * 5; i++) {
			var r:int = i * 360 / (12 * 5);
			var x:Number = Math.cos(r * Math.PI / 180) * radius;
			var y:Number = Math.sin(r * Math.PI / 180) * radius;
			var length:Number = (i % 5 == 0) ? 0.9 : 0.95;
			
			graphics.lineStyle((i % 5 == 0) ? 2 : 1, color);
			graphics.moveTo(radius + x * length, radius + y * length);
			graphics.lineTo(radius + x * 0.98, radius + y * 0.98);
		}
	}
	
	public function init():void {
		hhand.init();
		mhand.init();
		shand.init();
	}
	
	public function update(newTime:Date):void {
		var r:Number;
		
		if (hhand.mouseDown) {
			r = hhand.getInnerProduct() / 5;
			time = new Date(time.getTime() + r / 360 * 12 * 60 * 60 * 1000);
		} else if (mhand.mouseDown) {
			r = mhand.getInnerProduct() / 5;
			time = new Date(time.getTime() + r / 360 * 60 * 60 * 1000);
		} else if (shand.mouseDown) {
			r = shand.getInnerProduct() / 5;
			time = new Date(time.getTime() + r / 360 * 60 * 1000);
		} else {
			time = new Date(time.getTime() + (newTime.getTime() - oldTime.getTime()));
		}
		oldTime = newTime;
		
		var s:Number = time.seconds + time.milliseconds / 1000;
		var m:Number = time.minutes + s / 60;
		var h:Number = time.hours % 12 + m / 60;
		hhand.rotation = h / 12 * 360;
		mhand.rotation = m / 60 * 360;
		shand.rotation = s / 60 * 360;
	}
	
	public function getTime():Date {
		return new Date(time.getTime());
	}
}

internal class AnalogHand extends Sprite {
	private var color:uint;
	private var thickness:Number;
	private var length:Number;
	private var tailLength:Number;
	
	private var _mouseDown:Boolean;
	
	public function AnalogHand(color:uint,
			thickness:Number, length:Number, tailLength:Number = 0) {
		this.color = color;
		this.thickness = thickness;
		this.length = length;
		this.tailLength = tailLength;
		
		_mouseDown = false;
		draw();
	}
	
	public function init():void {
		addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
	}
	
	public function getInnerProduct():Number {
		var r:Number = rotation - 90;
		var v1x:Number = -Math.sin(r * Math.PI / 180);
		var v1y:Number = Math.cos(r * Math.PI / 180);
		var v2x:Number = parent.mouseX - x;
		var v2y:Number = parent.mouseY - y;
		
		var result:Number = (v1x * v2x + v1y * v2y);
		if (result < 1.5 && result > -1.5) return 0;
		else return result;
	}
	
	public function get mouseDown():Boolean {
		return _mouseDown;
	}
	
	private function onMouseDown(e:MouseEvent):void {
		_mouseDown = true;
	}
	
	private function onMouseUp(e:MouseEvent):void {
		_mouseDown = false;
	}
	
	private function draw():void {
		graphics.lineStyle(thickness, color);
		graphics.moveTo(0, -length);
		graphics.lineTo(0, tailLength);
	}
}
