/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bf6X
 */

package {
  import com.actionscriptbible.Example;
  import flash.events.*;
  import flash.net.*;
  public class ch28ex1 extends Example {
    private const ENDPOINT:String = "http://geocoder.us/service/rest/geocode";
    public function ch28ex1() {
      geocode("2225 Jackson Ave, Long Island City, NY");
    }
    public function geocode(address:String):void {
      trace("Looking up " + address + "...");
      var req:URLRequest = new URLRequest();
      req.url = ENDPOINT;
      req.method = URLRequestMethod.GET;
      req.data = "address=" + address;
      var loader:URLLoader = new URLLoader(req);
      loader.addEventListener(Event.COMPLETE, onLoadComplete);
      loader.addEventListener(IOErrorEvent.IO_ERROR, onError);
    }
    protected function onLoadComplete(event:Event):void {
      var loader:URLLoader = URLLoader(event.target);
      var response:XML = XML(loader.data);
      var geo:Namespace = response.namespace("geo");
      var lat:Number = parseFloat(response..geo::lat.text());
      var long:Number = parseFloat(response..geo::long.text());
      trace("(" + lat + ", " + long + ")");
    }
    protected function onError(event:Event):void {
      trace("Error!");
    }
  }
}