/**
 * Copyright test_flash ( http://wonderfl.net/user/test_flash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/beWq
 */

// forked from narutohyper's Alternativa3D 3Dスロット
// forked from clockmaker's [Alternativa3D] Basic Template 
package {
	import alternativ5.engine3d.materials.FillMaterial;
	import alternativ5.engine3d.materials.TextureMaterial;
	import alternativ5.engine3d.materials.TextureMaterialPrecision;

	import alternativ5.engine3d.primitives.Plane;
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.engine3d.primitives.Cone;
	import alternativ5.engine3d.core.Object3D;
	import alternativ5.engine3d.core.Mesh;
	import alternativ5.engine3d.events.MouseEvent3D
	import alternativ5.types.Point3D;
	import alternativ5.types.Texture;
	import alternativ5.utils.*

	import flash.display.Sprite;
	import flash.display.BlendMode;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.GradientType;
	import flash.display.BlendMode;

	//----------------------------------
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.ProgressEvent;
	import flash.events.IOErrorEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	//----------------------------------
	import flash.events.MouseEvent;

	import flash.text.TextField
	import flash.text.TextFieldAutoSize
	import flash.text.TextFormat



	import flash.geom.Matrix;
	

	[SWF(width = 465, height = 465, frameRate = 60,backgroundColor=0x000000)]
	/**
	 * 勝手に何でもAlternativa3Dで作っちゃおうのコーナー
	 * 
	 * 今回はAlternativa3Dスロットです
	 * とりあえず、Clickで動いてClickClickClickでとまります。
	 * そんな難しいことしてないはず
	 * フォーク元のtemplateから、大体2時間くらいで作りました（リール画像の作業は除く）
	 * 
	 *
	 * リール以外は、超手抜きですが、
	 * まあ、作り方のTIPSなんで、これ以上ソース長くしてもしょうがないしｗ
	 * 
	 * 遅いマシンじゃ、カクカクしちゃうかも
	 * 
	 * 少しずつ、ブラッシュアップしていきます
	 * 
	 * @narutohyper
	*/

	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	public class SimpleDemo extends Sprite {

		private var dataXml:XML =
			<menu>
					<imgurl>http://marubayashi.net/archive/sample/images/slot1.gif</imgurl>
					<imgurl>http://marubayashi.net/archive/sample/images/slot2.gif</imgurl>
					<imgurl>http://marubayashi.net/archive/sample/images/slot2.gif</imgurl>
			</menu>;

		private var dataArray:Array;
		private var imgArray:Array;
		private var dbg:TextField;
		private var dataCounter:uint=0;
		
		public function SimpleDemo():void {
			dbg=new TextField()
			dbg.autoSize=TextFieldAutoSize.LEFT
			dbg.selectable=false;
			dbg.mouseEnabled=false;
			var format:TextFormat=new TextFormat();
			format.color=0x666666
			format.size=12;
			format.font='_ゴシック';
			dbg.defaultTextFormat=format
			this.addChild(dbg)

			dataArray = new Array();
			imgArray = new Array();

			//取り込んだXMLデータの中の画像URL情報を配列に収納
			for each (var item:String in dataXml.imgurl) {
				dataArray.push(item)
			}
			
			new LoaderContext(true);
			//画像の読み込み開始
			imgLoader(0)

		}


		//画像読み込み
		private function imgLoader(no:uint):void {
			var bytesLoaded:Number;
			var bytesTotal:Number;
			dbg.appendText(dataArray[no]+' now loading '+"\n");
			var loader:Loader = new Loader();
			
			loader.load(new URLRequest(dataArray[no]), new LoaderContext(true));
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE,loaded);
			loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS,progressHandler);

			loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, error); 

			//読み込み監視
			function progressHandler(event:ProgressEvent):void {
				bytesLoaded = event.bytesLoaded
				bytesTotal	= event.bytesTotal
				dbg.text=dataArray[no]+' now loading '+(bytesLoaded / bytesTotal)+"\n";
			}

			function loaded(e:Event):void {
				dbg.appendText(dataArray[no]+' OK'+"\n");
				imgArray.push(loader.content);
				dbg.appendText(dataArray[no]+' OK'+"\n");
				nextProc()
			}

			function error(e:IOErrorEvent):void {
				dbg.appendText(dataArray[no]+' BAT'+"\n");
				nextProc()
			}

			function nextProc():void {
				dataCounter++
				if (dataArray.length>dataCounter) {
					dbg.appendText(String(dataCounter));
					imgLoader(dataCounter)
				} else {
					removeChild(dbg);
					init();
				}
			}
		}



		private function init():void {
			// テンプレートを作成します

			FPS.init(stage);

			var template:BasicTemplate = new BasicTemplate();
			addChild(template);
			template.camera.z = -800;

			// Planeプリミティブを作成します
			var Seg:uint=42;
			var plane1:Plane= new Plane(imgArray[0].width, imgArray[0].height, 1,Seg,false,false,true)
			var back1:Plane= new Plane(imgArray[0].width, imgArray[0].height, 1,Seg,false,true,true)

			var i:uint
			var id0:String
			var id1:String
			var temp0:Point3D;
			var temp1:Point3D;
			var vy:Number
			var vz:Number


			// ドラムの作成

			for(i=0;i<=Seg;i++) {
				//表面
				vy=Math.sin(MathUtils.toRadian(i*360/Seg))*(imgArray[0].height/Math.PI/2)
				vz=Math.cos(MathUtils.toRadian(i*360/Seg))*(imgArray[0].height/Math.PI/2)

				id0=0+'_'+i
				id1=1+'_'+i
				temp0=plane1.getVertexById(id0).coords
				temp1=plane1.getVertexById(id1).coords

				temp0.z=vz
				temp0.y=vy
				temp1.z=vz
				temp1.y=vy

				plane1.getVertexById(id0).coords=temp0
				plane1.getVertexById(id1).coords=temp1

				//裏
				vy=Math.sin(MathUtils.toRadian(i*360/42))*(imgArray[0].height/Math.PI/2-5)
				vz=Math.cos(MathUtils.toRadian(i*360/42))*(imgArray[0].height/Math.PI/2-5)

				temp0=back1.getVertexById(id0).coords
				temp1=back1.getVertexById(id1).coords

				temp0.z=vz
				temp0.y=vy
				temp1.z=vz
				temp1.y=vy

				back1.getVertexById(id0).coords=temp0
				back1.getVertexById(id1).coords=temp1
			}

			//グラデーションのマテリアルを作成する
				var bmd:BitmapData=new BitmapData(100,100,true,0xFF000000)
				var tempSprite:Sprite=new Sprite();
				var colors:Array=new Array(0x333333,0xCCCCCC,0x333333)
				var alphas:Array=new Array(1,1,1)
				var ratios:Array=new Array(0,127,255)
				var matrix:Matrix=new Matrix()
				matrix.createGradientBox(100,100,Math.PI/2,0,0)

				tempSprite.graphics.beginGradientFill(GradientType.LINEAR,colors, alphas, ratios, matrix)
				tempSprite.graphics.drawRect(0,0,100,100)
				bmd.draw(tempSprite)

				var backMaterial1:TextureMaterial=new TextureMaterial(new Texture(bmd))
				var backMaterial2:TextureMaterial=new TextureMaterial(new Texture(bmd))
				var backMaterial3:TextureMaterial=new TextureMaterial(new Texture(bmd))

				back1.setMaterialToSurface(backMaterial1,'back');

			var back2:Plane=Plane(back1.clone())
			var back3:Plane=Plane(back1.clone())

			var plane2:Plane=Plane(plane1.clone())
			var plane3:Plane=Plane(plane1.clone())


			var bmd1:BitmapData=new BitmapData(imgArray[0].width,imgArray[0].height,false,0xFFFFFFFF)
			var bmd2:BitmapData=new BitmapData(imgArray[0].width,imgArray[0].height,false,0xFFFFFFFF)
			var bmd3:BitmapData=new BitmapData(imgArray[0].width,imgArray[0].height,false,0xFFFFFFFF)
			bmd1.draw(imgArray[0])
			bmd2.draw(imgArray[1])
			bmd3.draw(imgArray[2])
			var ltm1:TextureMaterial=new TextureMaterial(new Texture(bmd1),1,true,true,BlendMode.NORMAL,-1,0,TextureMaterialPrecision.BEST)
			var ltm2:TextureMaterial=new TextureMaterial(new Texture(bmd2),1,true,true,BlendMode.NORMAL,-1,0,TextureMaterialPrecision.BEST)
			var ltm3:TextureMaterial=new TextureMaterial(new Texture(bmd3),1,true,true,BlendMode.NORMAL,-1,0,TextureMaterialPrecision.BEST)

			plane1.setMaterialToSurface(ltm1,'front');
			plane2.setMaterialToSurface(ltm2,'front');
			plane3.setMaterialToSurface(ltm3,'front');



			//最初の面をセット
			plane1.rotationX = MathUtils.toRadian(360/21)
			plane2.rotationX = MathUtils.toRadian(360/21)
			plane3.rotationX = MathUtils.toRadian(360/21)
			
			back1.rotationX = MathUtils.toRadian(90)
			back2.rotationX = MathUtils.toRadian(90)
			back3.rotationX = MathUtils.toRadian(90)

			plane1.x=-imgArray[0].width-10
			plane2.x=0
			plane3.x=imgArray[0].width+10
			plane1.y=5;
			plane2.y=5;
			plane3.y=5;		

			back1.x=-imgArray[0].width-10
			back2.x=0
			back3.x=imgArray[0].width+10
			back1.y=10;
			back2.y=10;
			back3.y=10;
				

			//筐体を作成
			var box:Box=new Box(500,560,420,1,3,1)
			//box.cloneMaterialToAllSurfaces(new FillMaterial(0x666666,0.5,BlendMode.NORMAL,1))
			box.cloneMaterialToAllSurfaces(new FillMaterial(0x666666))
			box.setMaterialToSurface(new FillMaterial(0x660000),'bottom')

			box.removeFace(box.getFaceById('bottom_0_1'))
			
			var item:String



			//筐体にドラムをセット
			box.addChild(plane1);
			box.addChild(plane2);
			box.addChild(plane3);
			//box.addChild(back1);
			//box.addChild(back2);
			//box.addChild(back3);

			// 3Dシーンのルートに筐体を追加
			template.scene.root.addChild(box);

			/*-------------------------------------------------------
				プリミティブのロールオーバー、クリックを有効にする為
				viewのbuttonModeとinteractiveをtrueにする
			-------------------------------------------------------*/
			//template.view.buttonMode = true;
			//template.view.interactive = true;

			stage.addEventListener(MouseEvent.CLICK,onClick)


			var actionCounter:uint=0

			var lilleCounter1:Number=0
			var lilleCounter2:Number=0
			var lilleCounter3:Number=0

			var lilleAction1:Boolean=false
			var lilleAction2:Boolean=false
			var lilleAction3:Boolean=false

			function onClick(e:MouseEvent):void {
				actionCounter++
				if (actionCounter==1) {
					//start
					lilleAction1=true
					lilleAction2=true
					lilleAction3=true
				} else if (actionCounter==2) {
					//第1リール停止
				} else if (actionCounter==3) {
					//第２リール停止
				} else if (actionCounter==4) {
					//第3リール停止
				}
			}


			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			template.onPreRender = function():void {

				// 立方体を回転させます (角度はラジアン)
				//box.rotationY += 1 * Math.PI / 180;
				var cut:uint=2;
				var pos:uint=0;
				if (lilleAction1) {
					if (actionCounter==1) {
						lilleCounter1=(lilleCounter1+1)%cut
						plane1.rotationX+=MathUtils.toRadian(360/21/cut)
					} else if (actionCounter) {
						//すべり
						if (lilleCounter1!=pos) {
							lilleCounter1=(lilleCounter1+1)%cut
							plane1.rotationX+=MathUtils.toRadian(360/21/cut)
						} else {
							lilleAction1=false
						}
					}
				}

				if (lilleAction2) {
					if (actionCounter<3) {
						lilleCounter2=(lilleCounter2+1)%cut
						plane2.rotationX+=MathUtils.toRadian(360/21/cut)
					} else {
						//すべり
						if (lilleCounter2!=pos) {
							lilleCounter2=(lilleCounter2+1)%cut
							plane2.rotationX+=MathUtils.toRadian(360/21/cut)
						} else {
							lilleAction2=false
						}
					}
				}
				
				if (lilleAction3) {
					if (actionCounter<4) {
						lilleCounter3=(lilleCounter3+1)%cut
						plane3.rotationX+=MathUtils.toRadian(360/21/cut)
					} else {
						//すべり
						if (lilleCounter3!=pos) {
							lilleCounter3=(lilleCounter3+1)%cut
							plane3.rotationX+=MathUtils.toRadian(360/21/cut)
						} else {
							lilleAction3=false
							actionCounter=0
						}
					}
				}

				// マウスがステージの高さ何%の位置にあるか算出
				var rateX:Number = (mouseX-(stage.stageWidth-2))*0.1+45/2;
				var rateY:Number = (mouseY-(stage.stageHeight-2))*0.1+45/2;
				
				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				//template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				box.rotationY += (MathUtils.toRadian(-rateX)-box.rotationY)*0.1;

				box.rotationX += (MathUtils.toRadian(rateY)-box.rotationX)*0.1;


				// マウスがステージの高さ何%の位置にあるか算出
				//var rateY:Number = mouseY / stage.stageHeight;
				
				// カメラの高さの座標を調整
				// イージングの公式 対象の値 += (目標値 - 現在の値) * 減速率
				//template.camera.y += ( - 1000 * rateY - template.camera.y) * 0.1;
				
				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());
			}
		}

	}
}






import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;


/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPostRender();
		_onPostRender();
		scene.calculate();
		atPreRender();
		_onPreRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}
