/**
 * Copyright saruzaru ( http://wonderfl.net/user/saruzaru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/beBD
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;

    import com.greensock.*;

    import com.greensock.easing.*;

    import flash.display.*;

    import flash.events.*;

    import flash.filters.BlurFilter;

    import flash.geom.*;

    import flash.geom.ColorTransform;

    import flash.utils.getDefinitionByName;

    import com.flashdynamix.motion.effects.*;

    import com.flashdynamix.motion.effects.core.*;

    import com.flashdynamix.motion.layers.*;


    public class Dots extends Sprite {
         function Dots() {

        {
            init();
        }

        

    private function init():void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);


            buildBalls();

            buildTweens();

            buildEffect();

        }

        

        public var dots:Array = [];

        public var dotColors:Array = [0xFF5349,0xFF6E4A,0xFFA343,0xFFCF48,0xFDFC74,0xB2EC5D,0x1CAC78,0x1CD3A2,0x1FCECB,0x1DACD6,0x1F75FE,0x7442C8,0xFF1DCE,0xFF43A4,0xF75394,0xEE204D,0xCB4154,0xCD4A4A,0xFF5349,0xFF6E4A,0xFFA343,0xFFCF48,0xFDFC74,0xB2EC5D,0x1CAC78,0x1CD3A2,0x1FCECB,0x1DACD6,0x1F75FE,0x7442C8,0xFF1DCE,0xFF43A4,0xF75394,0xEE204D,0xCB4154,0xCD4A4A];

        public var layer:BitmapLayer = new BitmapLayer(800, 800, 1, 0x00FFFFFF, true,true);

        

        public var container:MovieClip = new MovieClip();

        public var containerIn:MovieClip = new MovieClip();

        

         function buildBalls():void {

            var rotBall:Number = 10;

            

            this.addChild(container);

            container.x = 0;

            container.y = 0;

            container.addChild(containerIn);

            TweenMax.to(containerIn, 8, {rotation:-360, repeat:-1, ease:Linear.easeNone } );

            containerIn.x = stage.stageWidth / 2;

            containerIn.y = stage.stageHeight / 2;

            for (var i in dotColors) {
                var clip:MovieClip = new MovieClip();

                clip.rotation = rotBall;

                containerIn.addChild(clip);

                rotBall += 10;

                var circleCont:MovieClip = new MovieClip();

                var circle:Sprite = new Sprite();

                circle.graphics.beginFill(dotColors[i]);

                circle.graphics.drawCircle(0,0,8);

                circle.graphics.endFill();

                circleCont.addChild(circle);

                circleCont.cacheAsBitmap = true;

                clip.addChild(circleCont);

                dots.push(circleCont);

            }

        }


        public function buildTweens():void {

            var delAnim:Number = 0.33;

            for (var i in dots) {

                TweenMax.to(dots[i],0,{scale:0,x:23});

                TweenMax.to(dots[i],1,{x:280,repeat:-1,yoyo:true,ease:Sine.easeInOut,delay:delAnim});

                TweenMax.fromTo(dots[i],1,{scaleX:.11,scaleY:2.46,tint:0x000000,rotation:0},{scaleX:2,alpha:1,scaleY:2,tint:dotColors[i],rotation:-180,alpha:1,repeat:-1,yoyo:true,ease:Sine.easeOut,delay:delAnim});

                delAnim += 0.33;

            }

        }

        public function buildEffect():void {

        

            //container.visible = true;

            var layerContainer:MovieClip = new MovieClip();

            addChild(layerContainer);

            layer.add(new ScrollEffect(1,-1));

            layer.add(new FilterEffect(new BlurFilter(2, 2, 2)));

            layer.add(new ColorEffect(new ColorTransform(1, 0.5, 1.7, 0.5)));

            

            layer.draw(container);

            layer.x = layer.y = 0;

            layerContainer.addChild(layer);

            layerContainer.blendMode = "add";

            container.visible = true;

        }

        

        init();

            
        }
    }
}