/**
 * Copyright Torrunt ( http://wonderfl.net/user/Torrunt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/be57
 */

package {
    import flash.events.KeyboardEvent;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.ui.Mouse;
    import flash.text.*;
    
    public class FlashTest extends Sprite {
        
        public var size_min:Number = 1;
        public var size_max:Number = 6;
        public var speed:Number = 1.2;
        public var randomColours:Boolean = true;
        public var defaultColour:uint = 0xFF0000;
        
        private var guiTextFormat:TextFormat;
        private var gui_count:TextField;
        private var gui_sizes:TextField;
        private var gui_speed:TextField;
        private var gui_randomColours:TextField;
        
        public var layer_gui:Sprite;
        public var layer_display:Sprite;
        
        public function FlashTest() {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            
            // Layers
            layer_display = new Sprite();
            layer_gui = new Sprite();
            addChild(layer_display);
            addChild(layer_gui);
            
            layer_gui.visible = false;
            setupGui();
        }
        
        public function onEnterFrame(e:Event):void
        {
            gui_count.text = "Bubble Count: " + String(layer_display.numChildren);
            
            var sizes:Array = gui_sizes.text.split("-");
            size_min = sizes[0];
            size_max = sizes[1];
            
            speed = Number(gui_speed.text);
            
            randomColours = Boolean(gui_randomColours.text);
        }

        public function onMouseMove(e:MouseEvent):void
        {
            for (var i:int = 0; i < 4; i++)
            {
                var obj:MovieClip = new MovieClip();
                var color:uint;
                if (randomColours){
                    color = Math.random() * 0xFFFFFF;
                } else {
                    color = defaultColour;
                }

                obj.graphics.beginFill(color,1);
                obj.graphics.drawCircle(0,0,Math.ceil(Math.random()*size_max)+size_min);
                obj.x = stage.mouseX;
                obj.y = stage.mouseY;
                var angle:Number = (Math.ceil(Math.random()*360)-180) * Math.PI / 180;
                obj.xa = Math.cos(angle);
                obj.ya = Math.sin(angle);
                obj.speed = speed;
                obj.addEventListener(Event.ENTER_FRAME, move);
                layer_display.addChild(obj);
            }
        }
        
        public function move(e:Event):void
        {
            e.target.x += e.target.xa * e.target.speed;
            e.target.y += e.target.ya * e.target.speed;
            
            if (e.target.x-e.target.width > stage.stageWidth || e.target.x+e.target.width < 0 ||
                e.target.y-e.target.height > stage.stageHeight || e.target.y+e.target.height < 0)
            {
                e.target.parent.removeChild(e.target);
            }
        }
        
        public function clearChildren(what:Object):void {
            while (what.numChildren > 0) what.removeChildAt(0);
        }
        
        // Gui
        public function onKeyDown(e:KeyboardEvent):void
        {
            switch (e.keyCode)
            {
                case 67: clearChildren(layer_display); break;
                case 72: toggleGui(); break;
            }
        }
        
        public function toggleGui():void
        {
            layer_gui.visible = !layer_gui.visible;
        }

        public function setupGui():void
        {
            // Back
            var back:Sprite = new Sprite();
            layer_gui.addChild(back);
            back.graphics.beginFill(0x000000, 0.6);
            back.graphics.drawRect(0,stage.stageHeight-18,stage.stageWidth,18);
            
            // Format
            guiTextFormat = new TextFormat();
            setupFormat();
            
            // Count
            gui_count = new TextField();
            layer_gui.addChild(gui_count);
            
            gui_count.width = 120;
            gui_count.height = 18;
            gui_count.y = stage.stageHeight-gui_count.height;
            gui_count.selectable = false;
            gui_count.defaultTextFormat = guiTextFormat;
            
            // Sizes
            var gui_sizeMaxTitle:TextField = new TextField();
            setupTextField(gui_sizeMaxTitle);
            gui_sizeMaxTitle.text = "Sizes:";
            gui_sizeMaxTitle.x = gui_count.x + gui_count.width + 2;
            gui_sizeMaxTitle.width = 36;
            
            gui_sizes = new TextField();
            setupTextField(gui_sizes,true);
            gui_sizes.x = gui_sizeMaxTitle.x + gui_sizeMaxTitle.width;
            gui_sizes.text = String(size_min)+ "-" + String(size_max);
            gui_sizes.width = 40;
            
            // Speed
            var gui_speedTitle:TextField = new TextField();
            setupTextField(gui_speedTitle);
            gui_speedTitle.text = "Speed:";
            gui_speedTitle.x = gui_sizes.x + gui_sizes.width + 2;
            gui_speedTitle.width = 46;
            
            gui_speed = new TextField();
            setupTextField(gui_speed,true);
            gui_speed.x = gui_speedTitle.x + gui_speedTitle.width;
            gui_speed.text = String(speed);
            gui_speed.width = 30;
            
            // Random Colours
            var gui_randomColoursTitle:TextField = new TextField();
            setupTextField(gui_randomColoursTitle);
            gui_randomColoursTitle.text = "Rnd Colours:";
            gui_randomColoursTitle.x = gui_speed.x + gui_speed.width + 2;
            gui_randomColoursTitle.width = 80;
            
            gui_randomColours = new TextField();
            setupTextField(gui_randomColours,true);
            gui_randomColours.x = gui_randomColoursTitle.x + gui_randomColoursTitle.width;
            gui_randomColours.text = "o";
            gui_randomColours.maxChars = 1;
            gui_randomColours.width = 10;
        }
        
        public function setupFormat():void
        {
            guiTextFormat.size = 12;
            guiTextFormat.font = "Arial";
            guiTextFormat.color = 0xFFFFFF;
        }

        
        public function setupTextField(textbox:TextField, input:Boolean = false):void
        {
            layer_gui.addChild(textbox);

            textbox.width = 55;
            textbox.height = 18;
            textbox.y = stage.stageHeight-textbox.height;
            
            if (input)
            {
                textbox.type = TextFieldType.INPUT;
                guiTextFormat.color = 0x000000;
                textbox.background = true;
                textbox.backgroundColor = 0xFFFFFF;
                textbox.alpha = 0.5;
            } else {
                textbox.selectable = false;
            }
            textbox.defaultTextFormat = guiTextFormat;
            
            // reset format
            setupFormat();
        }

    }
}