/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/be4V
 */

// forked from ProjectNya's LightCircleSound
// forked from gaina's soundtest7 - E.R.O
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] LightCircleクラスだ！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1153
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var light:LightCircle;
        private var sound:Sound;
        private static var soundPath:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";

        public function Main() {
            Wonderfl.capture_delay(11);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(30, 30, 405, 405);
            light = new LightCircle(rect, 8);
            addChild(light);
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }
        private function start():void {
            var channel:SoundChannel = sound.play(0, 5);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
            light.start();
        }
        private function update(evt:Event):void {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 1);
            for (var n:uint = 0; n < 2; n++) {
                for (var t:uint = 0; t < 256; t++) {
                    var circle:Circle = light.circleList[t%4+n*4];
                    var rf:Number = bytes.readFloat();
                    circle.draw((rf + 0.5)*100);
                }
            }
        }

    }

}



import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import flash.filters.ColorMatrixFilter;
import frocessing.color.ColorHSV;

class LightCircle extends Sprite {
    private var rect:Rectangle;
    private var circles:uint;
    public var circleList:Array;
    private var colorMatrix:ColorMatrixFilter;
    private var matrix:Array;
    private var color:ColorHSV;

    public function LightCircle(r:Rectangle, n:uint) {
        rect = r;
        circles = n;
        init();
    }

    private function init():void {
        circleList = new Array();
        color = new ColorHSV(216, 0.6, 1);
        for (var n:uint = 0; n < circles; n++) {
            var circle:Circle = new Circle();
            circle.color = color.value;
            circle.blendMode = BlendMode.ADD;
            circleList.push(circle);
        }
        colorMatrix = new ColorMatrixFilter();
        matrix = new Array();
        matrix = [1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 128, 0, 0, 0, 1, 0];
        colorMatrix.matrix = matrix;
        filters = [colorMatrix];
        create();
    }
    private function create():void {
        for (var n:uint = 0; n < circles; n++) {
            var circle:Circle = circleList[n];
            circle.x = rect.x + Math.random()*rect.width;
            circle.y = rect.y + Math.random()*rect.height;
            circle.vx = Math.random()*8 - 4;
            circle.vy = Math.random()*8 - 4;
            addChild(circle);
        }
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, move, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, move);
    }
    private function move(evt:Event):void {
        for (var n:uint = 0; n < circles; n++) {
            var circle:Circle = circleList[n];
            if (circle.x < rect.left || circle.x > rect.right) circle.vx = - circle.vx;
            if (circle.y < rect.top || circle.y > rect.bottom) circle.vy = - circle.vy;
            circle.x += circle.vx;
            circle.y += circle.vy;
        }
    }


}



import flash.display.Shape;
import flash.filters.BlurFilter;

class Circle extends Shape {
    private var rgb:uint = 0xFFFFFF;
    private static var blur:BlurFilter = new BlurFilter(50, 50, 3);
    public var vx:Number = 0;
    public var vy:Number = 0;

    public function Circle() {
        filters = [blur];
    }

    public function draw(radius:Number):void {
        graphics.clear();
        graphics.beginFill(rgb);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function set color(c:uint):void {
        rgb = c;
    }

}
