/**
 * Copyright chippolot ( http://wonderfl.net/user/chippolot )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bdA3
 */

package {
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
        private var sp:Sprite;
        private var nX:Number;
        private var nY:Number;
        
        public function FlashTest() {
            this.addEventListener(Event.ENTER_FRAME, update);            
            
            var spHolder:Sprite = new Sprite;
            this.addChild(spHolder);
            spHolder.x = stage.stageWidth*0.5;
            spHolder.y = stage.stageHeight*0.5;
            
            sp = new Sprite;
            sp.graphics.beginFill(0xff0000, 1);
            sp.graphics.drawCircle(-3,-3,3);
            nX = 60;
            nY = 0;
            spHolder.addChild(sp);
            
        }
        
        public function update(e:Event):void {
           var myPnt:Point = new Point(nX,nY);
           var pntIso:Point = toIsoSpace(myPnt);
           /*var mat:Matrix = new Matrix;
           mat.rotate(Math.PI*0.1);
           myPnt = mat.transformPoint(myPnt);*/
           
           var mat3D:Matrix3D = new Matrix3D;
           mat3D.appendRotation(5, new Vector3D(0,0,1));
           var vec3D:Vector3D = new Vector3D(pntIso.x,pntIso.y,0);
           vec3D = mat3D.transformVector(vec3D);
           
           var pntScreen:Point = toScreenSpace(new Point(vec3D.x, vec3D.y));
           myPnt = pntScreen.clone();
           
           nX = myPnt.x;
           nY = myPnt.y;
           sp.x = nX;
           sp.y = nY;
        }
        
        private function toIsoSpace(pnt:Point):Point{
            return new Point(-pnt.x -pnt.y*2, pnt.x - pnt.y*2);
        }
        
        private function toScreenSpace(pnt:Point):Point{
            return new Point(0.5*(-pnt.x+pnt.y),0.25*(-pnt.x-pnt.y));
        }
    }
}