/**
 * Copyright j_fujiwara ( http://wonderfl.net/user/j_fujiwara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bcv0
 */

package {
	import flash.display.Sprite;
	import flash.geom.Point;
	import flash.utils.setInterval;
	import caurina.transitions.Tweener;

	public class Anime3 extends Sprite {
		// 前回のマウスの位置を保存する
		private var prevPos:Point;

		public function Anime3():void {
			prevPos = new Point();

			// 100ミリ秒に１回、update メソッドを呼び出す
			setInterval(update, 100);
		}

		private function update():void {
			// 円の表示位置を決定する
			var r:Number = Math.pow(Math.random(), 2) * 50;
			var theta:Number = Math.random() * 2 * Math.PI;

			// 円を追加する
			var s:Sprite = new Sprite();
			s.graphics.beginFill(0x808080);
			s.graphics.drawCircle(0, 0, 5 + Math.random() * 5);
			s.graphics.endFill();
			s.x = mouseX + r * Math.cos(theta);
			s.y = mouseY + r * Math.sin(theta);
			s.scaleX = s.scaleY = 0;
			addChild(s);

			// マウスの移動量を計算する
			var curPos:Point = new Point(mouseX, mouseY);
			var d:Number = Point.distance(curPos, prevPos);
			prevPos = curPos;

			// アニメーションを行う
			Tweener.addTween(s, {
				time: 3,
				scaleX: d / 15 + 2,   // マウス移動量が多いほど、
				scaleY: d / 15 + 2,   // 円を大きくする
				alpha: 0,
				onComplete: function():void{
					removeChild(s);
				}
			});
		}
	}
}
